/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.printer;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.NodeMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.PropertyMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.RuntimeXMLStreamException;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Utils;

public class XmlPrinter {
    private final boolean outputNodeType;
    private static final Class<?> TYPE_CLASS = Type.class;

    public XmlPrinter(boolean outputNodeType) {
        this.outputNodeType = outputNodeType;
    }

    public String output(Node node) {
        return this.stringWriterOutput(node, "root").toString();
    }

    @Deprecated
    public void output(Node node, String name, int level, StringBuilder builder) {
        builder.append(this.stringWriterOutput(node, name).toString());
    }

    public StringWriter stringWriterOutput(Node node, String name) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.outputDocument(node, name, stringWriter);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeXMLStreamException(ex);
        }
        return stringWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDocument(Node node, String name, Writer writer) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try (XMLStreamWriter xmlWriter = outputFactory.createXMLStreamWriter(writer);){
            this.outputDocument(node, name, xmlWriter);
        }
    }

    public void outputDocument(Node node, String name, XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartDocument();
        this.outputNode(node, name, xmlWriter);
        xmlWriter.writeEndDocument();
    }

    public void outputNode(Node node, String name, XMLStreamWriter xmlWriter) throws XMLStreamException {
        Utils.assertNotNull(node);
        Utils.assertNonEmpty(name);
        Utils.assertNotNull(xmlWriter);
        NodeMetaModel metaModel = node.getMetaModel();
        List<PropertyMetaModel> allPropertyMetaModels = metaModel.getAllPropertyMetaModels();
        Predicate<PropertyMetaModel> & Serializable nonNullNode = (Predicate<PropertyMetaModel> & Serializable)propertyMetaModel -> propertyMetaModel.getValue(node) != null;
        Predicate<PropertyMetaModel> & Serializable nonEmptyList = (Predicate<PropertyMetaModel> & Serializable)propertyMetaModel -> ((NodeList)propertyMetaModel.getValue(node)).isNonEmpty();
        Predicate<PropertyMetaModel> & Serializable typeList = (Predicate<PropertyMetaModel> & Serializable)propertyMetaModel -> TYPE_CLASS == propertyMetaModel.getType();
        xmlWriter.writeStartElement(name);
        if (this.outputNodeType) {
            xmlWriter.writeAttribute("type", metaModel.getTypeName());
        }
        try {
            allPropertyMetaModels.stream().filter(PropertyMetaModel::isAttribute).filter(PropertyMetaModel::isSingular).forEach((Consumer<PropertyMetaModel> & Serializable)attributeMetaModel -> {
                try {
                    String attributeName = attributeMetaModel.getName();
                    String attributeValue = attributeMetaModel.getValue(node).toString();
                    xmlWriter.writeAttribute(attributeName, attributeValue);
                }
                catch (XMLStreamException ex) {
                    throw new RuntimeXMLStreamException(ex);
                }
            });
            allPropertyMetaModels.stream().filter(PropertyMetaModel::isNode).filter(PropertyMetaModel::isSingular).filter(nonNullNode).forEach((Consumer<PropertyMetaModel> & Serializable)subNodeMetaModel -> {
                try {
                    Node subNode = (Node)subNodeMetaModel.getValue(node);
                    String subNodeName = subNodeMetaModel.getName();
                    this.outputNode(subNode, subNodeName, xmlWriter);
                }
                catch (XMLStreamException ex) {
                    throw new RuntimeXMLStreamException(ex);
                }
            });
            allPropertyMetaModels.stream().filter(PropertyMetaModel::isNodeList).filter(nonNullNode).filter(nonEmptyList.or(typeList)).forEach((Consumer<PropertyMetaModel> & Serializable)listMetaModel -> {
                try {
                    String listName = listMetaModel.getName();
                    String singular = listName.substring(0, listName.length() - 1);
                    NodeList nodeList = (NodeList)listMetaModel.getValue(node);
                    xmlWriter.writeStartElement(listName);
                    for (Node subNode : nodeList) {
                        this.outputNode(subNode, singular, xmlWriter);
                    }
                    xmlWriter.writeEndElement();
                }
                catch (XMLStreamException ex) {
                    throw new RuntimeXMLStreamException(ex);
                }
            });
        }
        catch (RuntimeXMLStreamException ex) {
            throw ex.getXMLStreamCause();
        }
        xmlWriter.writeEndElement();
    }

    public static void print(Node node) {
        System.out.println(new XmlPrinter(true).output(node));
    }
}

