/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.Value;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.LazyType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedLambdaConstraintType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedUnionType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedWildcard;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.ContextHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.LeastUpperBoundLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Pair;

public class MethodCallExprContext
extends AbstractJavaParserContext<MethodCallExpr> {
    public MethodCallExprContext(MethodCallExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<ResolvedType> solveGenericType(String name) {
        Optional<Expression> nodeScope = ((MethodCallExpr)this.wrappedNode).getScope();
        if (!nodeScope.isPresent()) {
            return Optional.empty();
        }
        ResolvedType typeOfScope = JavaParserFacade.get(this.typeSolver).getType(nodeScope.get());
        Optional<ResolvedType> resolvedType = typeOfScope.asReferenceType().getGenericParameterByName(name);
        return resolvedType;
    }

    public String toString() {
        return "MethodCallExprContext{wrapped=" + this.wrappedNode + "}";
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes) {
        int i;
        ResolvedType typeOfScope;
        if (((MethodCallExpr)this.wrappedNode).hasScope()) {
            String className;
            SymbolReference<ResolvedTypeDeclaration> ref;
            Expression scope = ((MethodCallExpr)this.wrappedNode).getScope().get();
            if (scope instanceof NameExpr && (ref = this.solveType(className = ((NameExpr)scope).getName().getId())).isSolved()) {
                SymbolReference<ResolvedMethodDeclaration> m = MethodResolutionLogic.solveMethodInType(ref.getCorrespondingDeclaration(), name, argumentsTypes);
                if (m.isSolved()) {
                    MethodUsage methodUsage = new MethodUsage(m.getCorrespondingDeclaration());
                    methodUsage = this.resolveMethodTypeParametersFromExplicitList(this.typeSolver, methodUsage);
                    methodUsage = this.resolveMethodTypeParameters(methodUsage, argumentsTypes);
                    return Optional.of(methodUsage);
                }
                throw new UnsolvedSymbolException(ref.getCorrespondingDeclaration().toString(), "Method '" + name + "' with parameterTypes " + argumentsTypes);
            }
            typeOfScope = JavaParserFacade.get(this.typeSolver).getType(scope);
        } else {
            typeOfScope = JavaParserFacade.get(this.typeSolver).getTypeOfThisIn(this.wrappedNode);
        }
        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
        for (i = 0; i < argumentsTypes.size(); ++i) {
            ResolvedType originalArgumentType = argumentsTypes.get(i);
            ResolvedType updatedArgumentType = this.usingParameterTypesFromScope(typeOfScope, originalArgumentType, inferredTypes);
            argumentsTypes.set(i, updatedArgumentType);
        }
        for (i = 0; i < argumentsTypes.size(); ++i) {
            ResolvedType updatedArgumentType = this.applyInferredTypes(argumentsTypes.get(i), inferredTypes);
            argumentsTypes.set(i, updatedArgumentType);
        }
        return this.solveMethodAsUsage(typeOfScope, name, argumentsTypes, (Context)this);
    }

    private MethodUsage resolveMethodTypeParametersFromExplicitList(TypeSolver typeSolver, MethodUsage methodUsage) {
        if (((MethodCallExpr)this.wrappedNode).getTypeArguments().isPresent()) {
            ArrayList<ResolvedType> typeArguments = new ArrayList<ResolvedType>();
            for (Type ty : ((MethodCallExpr)this.wrappedNode).getTypeArguments().get()) {
                typeArguments.add(JavaParserFacade.get(typeSolver).convertToUsage(ty));
            }
            List<ResolvedTypeParameterDeclaration> tyParamDecls = methodUsage.getDeclaration().getTypeParameters();
            if (tyParamDecls.size() == typeArguments.size()) {
                for (int i = 0; i < tyParamDecls.size(); ++i) {
                    methodUsage = methodUsage.replaceTypeParameter(tyParamDecls.get(i), (ResolvedType)typeArguments.get(i));
                }
            }
        }
        return methodUsage;
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name) {
        return this.solveSymbolAsValueInParentContext(name);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        Collection<ResolvedReferenceTypeDeclaration> rrtds = this.findTypeDeclarations(((MethodCallExpr)this.wrappedNode).getScope());
        if (rrtds.isEmpty()) {
            rrtds = Collections.singleton(this.typeSolver.getSolvedJavaLangObject());
        }
        for (ResolvedReferenceTypeDeclaration rrtd : rrtds) {
            SymbolReference<ResolvedMethodDeclaration> res = MethodResolutionLogic.solveMethodInType(rrtd, name, argumentsTypes, false);
            if (!res.isSolved()) continue;
            return res;
        }
        return SymbolReference.unsolved();
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedReferenceType refType, String name, List<ResolvedType> argumentsTypes, Context invokationContext) {
        if (!refType.getTypeDeclaration().isPresent()) {
            return Optional.empty();
        }
        Optional<MethodUsage> ref = ContextHelper.solveMethodAsUsage(refType.getTypeDeclaration().get(), name, argumentsTypes, invokationContext, refType.typeParametersValues());
        if (ref.isPresent()) {
            MethodUsage methodUsage = ref.get();
            methodUsage = this.resolveMethodTypeParametersFromExplicitList(this.typeSolver, methodUsage);
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> derivedValues = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            for (int i = 0; i < methodUsage.getParamTypes().size(); ++i) {
                ResolvedParameterDeclaration parameter = methodUsage.getDeclaration().getParam(i);
                ResolvedType parameterType = parameter.getType();
                if (parameter.isVariadic() && argumentsTypes.size() < methodUsage.getNoParams()) break;
                if (!argumentsTypes.get(i).isArray() && parameter.isVariadic()) {
                    parameterType = parameterType.asArrayType().getComponentType();
                }
                this.inferTypes(argumentsTypes.get(i), parameterType, derivedValues);
            }
            for (Map.Entry entry : derivedValues.entrySet()) {
                methodUsage = methodUsage.replaceTypeParameter((ResolvedTypeParameterDeclaration)entry.getKey(), (ResolvedType)entry.getValue());
            }
            ResolvedType returnType = refType.useThisTypeParametersOnTheGivenType(methodUsage.returnType());
            if (returnType != methodUsage.returnType() && returnType != ResolvedWildcard.UNBOUNDED) {
                methodUsage = methodUsage.replaceReturnType(returnType);
            }
            for (int i = 0; i < methodUsage.getParamTypes().size(); ++i) {
                ResolvedType replaced = refType.useThisTypeParametersOnTheGivenType(methodUsage.getParamTypes().get(i));
                methodUsage = methodUsage.replaceParamType(i, replaced);
            }
            return Optional.of(methodUsage);
        }
        return ref;
    }

    private void inferTypes(ResolvedType source, ResolvedType target, Map<ResolvedTypeParameterDeclaration, ResolvedType> mappings) {
        ResolvedReferenceType formalTypeAsReference;
        if (source.equals(target)) {
            return;
        }
        if (source.isReferenceType() && target.isReferenceType()) {
            ResolvedReferenceType sourceRefType = source.asReferenceType();
            ResolvedReferenceType targetRefType = target.asReferenceType();
            if (sourceRefType.getQualifiedName().equals(targetRefType.getQualifiedName()) && !sourceRefType.isRawType() && !targetRefType.isRawType()) {
                for (int i = 0; i < sourceRefType.typeParametersValues().size(); ++i) {
                    this.inferTypes(sourceRefType.typeParametersValues().get(i), targetRefType.typeParametersValues().get(i), mappings);
                }
            }
            return;
        }
        if (source.isReferenceType() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                this.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isWildcard() && target.isWildcard()) {
            if (source.asWildcard().isBounded() && target.asWildcard().isBounded()) {
                this.inferTypes(source.asWildcard().getBoundedType(), target.asWildcard().getBoundedType(), mappings);
            }
            return;
        }
        if (source.isReferenceType() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isArray() && target.isArray()) {
            ResolvedType sourceComponentType = source.asArrayType().getComponentType();
            ResolvedType targetComponentType = target.asArrayType().getComponentType();
            this.inferTypes(sourceComponentType, targetComponentType, mappings);
            return;
        }
        if (source.isArray() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                this.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isArray() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isReferenceType()) {
            if (source.asWildcard().isBounded()) {
                this.inferTypes(source.asWildcard().getBoundedType(), target, mappings);
            }
            return;
        }
        if (source.isConstraint() && target.isReferenceType()) {
            this.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isConstraint() && target.isTypeVariable()) {
            this.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isTypeVariable() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isTypeVariable()) {
            this.inferTypes(target, source, mappings);
            return;
        }
        if (source.isPrimitive() || target.isPrimitive()) {
            return;
        }
        if (source.isNull()) {
            return;
        }
        if (target.isReferenceType() && (formalTypeAsReference = target.asReferenceType()).isJavaLangObject()) {
            return;
        }
        throw new RuntimeException(source.describe() + " " + target.describe());
    }

    private MethodUsage resolveMethodTypeParameters(MethodUsage methodUsage, List<ResolvedType> actualParamTypes) {
        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
        if (methodUsage.getDeclaration().hasVariadicParameter()) {
            if (actualParamTypes.size() == methodUsage.getDeclaration().getNumberOfParams()) {
                Object componentType;
                ResolvedType lastActualParamType;
                ResolvedType expectedType = methodUsage.getDeclaration().getLastParam().getType().asArrayType().getComponentType();
                ResolvedType actualType = lastActualParamType = actualParamTypes.get(actualParamTypes.size() - 1);
                if (lastActualParamType.isArray() && ((componentType = lastActualParamType.asArrayType().getComponentType()).isReferenceType() && ResolvedTypeVariable.class.isInstance(expectedType) || !componentType.isReferenceType() && !ResolvedTypeVariable.class.isInstance(expectedType) || componentType.isReferenceType() && expectedType.isAssignableBy((ResolvedType)componentType))) {
                    actualType = lastActualParamType.asArrayType().getComponentType();
                }
                if (!expectedType.isAssignableBy(actualType)) {
                    for (ResolvedTypeParameterDeclaration tp : methodUsage.getDeclaration().getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, this.typeSolver);
                    }
                }
                if (!expectedType.isAssignableBy(actualType)) {
                    throw new UnsupportedOperationException(String.format("Unable to resolve the type typeParametersValues in a MethodUsage. Expected type: %s, Actual type: %s. Method Declaration: %s. MethodUsage: %s", expectedType, actualType, methodUsage.getDeclaration(), methodUsage));
                }
                this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
            } else {
                if (methodUsage.getDeclaration().getNumberOfParams() == 1) {
                    ResolvedType actualType;
                    ResolvedType expectedType = methodUsage.getDeclaration().getLastParam().getType().asArrayType().getComponentType();
                    if (!expectedType.isAssignableBy(actualType = actualParamTypes.get(actualParamTypes.size() - 1))) {
                        throw new UnsupportedOperationException(String.format("Unable to resolve the type typeParametersValues in a MethodUsage. Expected type: %s, Actual type: %s. Method Declaration: %s. MethodUsage: %s", expectedType, actualType, methodUsage.getDeclaration(), methodUsage));
                    }
                    this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
                    return this.replaceTypeParameter(methodUsage, matchedTypeParameters);
                }
                return methodUsage;
            }
        }
        int until = methodUsage.getDeclaration().hasVariadicParameter() ? actualParamTypes.size() - 1 : actualParamTypes.size();
        for (int i = 0; i < until; ++i) {
            ResolvedType expectedType = methodUsage.getParamType(i);
            ResolvedType actualType = actualParamTypes.get(i);
            this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
        }
        methodUsage = this.replaceTypeParameter(methodUsage, matchedTypeParameters);
        return methodUsage;
    }

    private MethodUsage replaceTypeParameter(MethodUsage methodUsage, Map<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters) {
        Map<String, Set<ResolvedType>> resolvedTypesByTypeVariable = this.groupResolvedTypeByTypeVariable(matchedTypeParameters);
        Map<String, ResolvedType> reducedResolvedTypesByTypeVariable = this.reduceResolvedTypesByTypeVariable(resolvedTypesByTypeVariable);
        this.convertTypesParameters(matchedTypeParameters, reducedResolvedTypesByTypeVariable);
        for (ResolvedTypeParameterDeclaration tp : matchedTypeParameters.keySet()) {
            methodUsage = methodUsage.replaceTypeParameter(tp, matchedTypeParameters.get(tp));
        }
        return methodUsage;
    }

    private void convertTypesParameters(Map<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters, Map<String, ResolvedType> reducedResolvedTypesByTypeVariable) {
        for (ResolvedTypeParameterDeclaration tp : matchedTypeParameters.keySet()) {
            String typeParameterName = tp.getName();
            boolean replacement = reducedResolvedTypesByTypeVariable.keySet().contains(typeParameterName);
            if (!replacement) continue;
            matchedTypeParameters.put(tp, reducedResolvedTypesByTypeVariable.get(typeParameterName));
        }
    }

    private Map<String, Set<ResolvedType>> groupResolvedTypeByTypeVariable(Map<ResolvedTypeParameterDeclaration, ResolvedType> typeParameters) {
        HashMap<String, Set<ResolvedType>> resolvedTypesByTypeVariable = new HashMap<String, Set<ResolvedType>>();
        for (ResolvedTypeParameterDeclaration tp : typeParameters.keySet()) {
            String typeParameterName = tp.getName();
            boolean alreadyCollected = resolvedTypesByTypeVariable.keySet().contains(typeParameterName);
            if (alreadyCollected) continue;
            Set<ResolvedType> resolvedTypes = this.findResolvedTypesByTypeVariable(typeParameterName, typeParameters);
            resolvedTypesByTypeVariable.put(typeParameterName, resolvedTypes);
        }
        return resolvedTypesByTypeVariable;
    }

    private Set<ResolvedType> findResolvedTypesByTypeVariable(String typeVariableName, Map<ResolvedTypeParameterDeclaration, ResolvedType> typeParameters) {
        return typeParameters.keySet().stream().filter((Predicate<ResolvedTypeParameterDeclaration> & Serializable)resolvedTypeParameterDeclaration -> resolvedTypeParameterDeclaration.getName().equals(typeVariableName)).map((Function<ResolvedTypeParameterDeclaration, ResolvedType> & Serializable)resolvedTypeParameterDeclaration -> (ResolvedType)typeParameters.get(resolvedTypeParameterDeclaration)).collect(Collectors.toSet());
    }

    private Map<String, ResolvedType> reduceResolvedTypesByTypeVariable(Map<String, Set<ResolvedType>> typeParameters) {
        HashMap<String, ResolvedType> reducedResolvedTypesList = new HashMap<String, ResolvedType>();
        for (String typeParameterName : typeParameters.keySet()) {
            ResolvedType type = this.reduceResolvedTypesWithLub(typeParameters.get(typeParameterName));
            reducedResolvedTypesList.put(typeParameterName, type);
        }
        return reducedResolvedTypesList;
    }

    private ResolvedType reduceResolvedTypesWithLub(Set<ResolvedType> resolvedTypes) {
        return LeastUpperBoundLogic.of().lub(resolvedTypes);
    }

    private void matchTypeParameters(ResolvedType expectedType, ResolvedType actualType, Map<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters) {
        if (expectedType.isTypeVariable()) {
            ResolvedReferenceTypeDeclaration resolvedTypedeclaration;
            ResolvedType type = actualType;
            if (type.isPrimitive()) {
                resolvedTypedeclaration = this.typeSolver.solveType(type.asPrimitive().getBoxTypeQName());
                type = new ReferenceTypeImpl(resolvedTypedeclaration);
            }
            if (type.isNull()) {
                resolvedTypedeclaration = this.typeSolver.getSolvedJavaLangObject();
                type = new ReferenceTypeImpl(resolvedTypedeclaration);
            }
            if (!(type.isTypeVariable() || type.isReferenceType() || type.isArray())) {
                throw new UnsupportedOperationException(type.getClass().getCanonicalName());
            }
            matchedTypeParameters.put(expectedType.asTypeParameter(), type);
        } else if (expectedType.isArray()) {
            if (!actualType.isArray() && !actualType.isNull()) {
                throw new UnsupportedOperationException(actualType.getClass().getCanonicalName());
            }
            this.matchTypeParameters(expectedType.asArrayType().getComponentType(), actualType.isNull() ? actualType : actualType.asArrayType().getComponentType(), matchedTypeParameters);
        } else if (expectedType.isReferenceType()) {
            if (actualType.isReferenceType() && actualType.asReferenceType().typeParametersValues().size() > 0) {
                int i = 0;
                for (ResolvedType tp : expectedType.asReferenceType().typeParametersValues()) {
                    this.matchTypeParameters(tp, actualType.asReferenceType().typeParametersValues().get(i), matchedTypeParameters);
                    ++i;
                }
            }
        } else if (!expectedType.isPrimitive() && !expectedType.isWildcard()) {
            throw new UnsupportedOperationException(expectedType.getClass().getCanonicalName());
        }
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedTypeVariable tp, String name, List<ResolvedType> argumentsTypes, Context invokationContext) {
        List<ResolvedTypeParameterDeclaration.Bound> bounds = tp.asTypeParameter().getBounds();
        if (bounds.isEmpty()) {
            bounds = Collections.singletonList(ResolvedTypeParameterDeclaration.Bound.extendsBound(new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject())));
        }
        for (ResolvedTypeParameterDeclaration.Bound bound : bounds) {
            Optional<MethodUsage> methodUsage = this.solveMethodAsUsage(bound.getType(), name, argumentsTypes, invokationContext);
            if (!methodUsage.isPresent()) continue;
            return methodUsage;
        }
        return Optional.empty();
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedType type, String name, List<ResolvedType> argumentsTypes, Context invokationContext) {
        if (type instanceof ResolvedReferenceType) {
            return this.solveMethodAsUsage((ResolvedReferenceType)type, name, argumentsTypes, invokationContext);
        }
        if (type instanceof LazyType) {
            return this.solveMethodAsUsage(type.asReferenceType(), name, argumentsTypes, invokationContext);
        }
        if (type instanceof ResolvedTypeVariable) {
            return this.solveMethodAsUsage((ResolvedTypeVariable)type, name, argumentsTypes, invokationContext);
        }
        if (type instanceof ResolvedWildcard) {
            ResolvedWildcard wildcardUsage = (ResolvedWildcard)type;
            if (wildcardUsage.isSuper()) {
                return this.solveMethodAsUsage(wildcardUsage.getBoundedType(), name, argumentsTypes, invokationContext);
            }
            if (wildcardUsage.isExtends()) {
                return this.solveMethodAsUsage(wildcardUsage.getBoundedType(), name, argumentsTypes, invokationContext);
            }
            return this.solveMethodAsUsage(new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject()), name, argumentsTypes, invokationContext);
        }
        if (type instanceof ResolvedLambdaConstraintType) {
            ResolvedLambdaConstraintType constraintType = (ResolvedLambdaConstraintType)type;
            return this.solveMethodAsUsage(constraintType.getBound(), name, argumentsTypes, invokationContext);
        }
        if (type instanceof ResolvedArrayType) {
            return this.solveMethodAsUsage(new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject()), name, argumentsTypes, invokationContext);
        }
        if (type instanceof ResolvedUnionType) {
            Optional<ResolvedReferenceType> commonAncestor = type.asUnionType().getCommonAncestor();
            if (commonAncestor.isPresent()) {
                return this.solveMethodAsUsage(commonAncestor.get(), name, argumentsTypes, invokationContext);
            }
            throw new UnsupportedOperationException("no common ancestor available for " + type.describe());
        }
        throw new UnsupportedOperationException("type usage: " + type.getClass().getCanonicalName());
    }

    private ResolvedType usingParameterTypesFromScope(ResolvedType scope, ResolvedType type, Map<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes) {
        if (type.isReferenceType()) {
            for (Pair<ResolvedTypeParameterDeclaration, ResolvedType> entry : type.asReferenceType().getTypeParametersMap()) {
                if (!((ResolvedTypeParameterDeclaration)entry.a).declaredOnType() || !scope.isReferenceType() || !scope.asReferenceType().getGenericParameterByName(((ResolvedTypeParameterDeclaration)entry.a).getName()).isPresent()) continue;
                type = type.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, scope.asReferenceType().getGenericParameterByName(((ResolvedTypeParameterDeclaration)entry.a).getName()).get(), inferredTypes);
            }
        }
        return type;
    }

    private ResolvedType applyInferredTypes(ResolvedType type, Map<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes) {
        for (ResolvedTypeParameterDeclaration tp : inferredTypes.keySet()) {
            type = type.replaceTypeVariables(tp, inferredTypes.get(tp), inferredTypes);
        }
        return type;
    }
}

