/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayInitializerExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BooleanLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CharLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ClassExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.DoubleLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.FieldAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.IntegerLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LongLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MemberValuePair;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Name;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NormalAnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.StringLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.ClassOrInterfaceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedAnnotationMemberDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;

public class ReflectionAnnotationMemberDeclaration
implements ResolvedAnnotationMemberDeclaration {
    private static Map<Class<?>, Function<Object, ? extends Expression>> valueAsExpressionConverters = new HashMap();
    private Method annotationMember;
    private TypeSolver typeSolver;

    public ReflectionAnnotationMemberDeclaration(Method annotationMember, TypeSolver typeSolver) {
        this.annotationMember = annotationMember;
        this.typeSolver = typeSolver;
    }

    @Override
    public Expression getDefaultValue() {
        Object value = this.annotationMember.getDefaultValue();
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            NodeList<Expression> expressions = Arrays.stream(values).map(this::transformDefaultValue).collect(NodeList.toNodeList());
            return new ArrayInitializerExpr(expressions);
        }
        return this.transformDefaultValue(value);
    }

    private Expression transformDefaultValue(Object value) {
        if (value instanceof Enum) {
            Class declaringClass = ((Enum)value).getDeclaringClass();
            String name = ((Enum)value).name();
            return new FieldAccessExpr(new NameExpr(declaringClass.getSimpleName()), name);
        }
        if (value instanceof Annotation) {
            Class<? extends Annotation> annotationType = ((Annotation)value).annotationType();
            Method[] declaredMethods = annotationType.getDeclaredMethods();
            NodeList<MemberValuePair> pairs = Arrays.stream(declaredMethods).map((Function<Method, MemberValuePair> & Serializable)m -> {
                ReflectionAnnotationMemberDeclaration nestedMemberDeclaration = new ReflectionAnnotationMemberDeclaration((Method)m, this.typeSolver);
                return new MemberValuePair(m.getName(), nestedMemberDeclaration.getDefaultValue());
            }).collect(NodeList.toNodeList());
            return new NormalAnnotationExpr(new Name(annotationType.getSimpleName()), pairs);
        }
        Function<Object, ? extends Expression> fn = valueAsExpressionConverters.get(value.getClass());
        if (fn == null) {
            throw new UnsupportedOperationException(String.format("Obtaining the default value of the annotation member %s (of type %s) is not supported yet.", this.annotationMember.getName(), value.getClass().getSimpleName()));
        }
        return fn.apply(value);
    }

    @Override
    public ResolvedType getType() {
        Class<?> returnType = this.annotationMember.getReturnType();
        if (returnType.isPrimitive()) {
            return ResolvedPrimitiveType.byName(returnType.getName());
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> rrtd = this.typeSolver.tryToSolveType(returnType.getName());
        if (rrtd.isSolved()) {
            return new ReferenceTypeImpl(rrtd.getCorrespondingDeclaration());
        }
        throw new UnsupportedOperationException(String.format("Obtaining the type of the annotation member %s is not supported yet.", this.annotationMember.getName()));
    }

    @Override
    public String getName() {
        return this.annotationMember.getName();
    }

    static {
        valueAsExpressionConverters.put(Boolean.class, (Function<Object, Expression> & Serializable)value -> new BooleanLiteralExpr((Boolean)value));
        valueAsExpressionConverters.put(Character.class, (Function<Object, Expression> & Serializable)value -> new CharLiteralExpr(((Character)value).charValue()));
        valueAsExpressionConverters.put(Double.class, (Function<Object, Expression> & Serializable)value -> new DoubleLiteralExpr((Double)value));
        valueAsExpressionConverters.put(Integer.class, (Function<Object, Expression> & Serializable)value -> new IntegerLiteralExpr((Integer)value));
        valueAsExpressionConverters.put(Long.class, (Function<Object, Expression> & Serializable)value -> new LongLiteralExpr((Long)value));
        valueAsExpressionConverters.put(String.class, (Function<Object, Expression> & Serializable)value -> new StringLiteralExpr((String)value));
        valueAsExpressionConverters.put(Class.class, (Function<Object, Expression> & Serializable)value -> {
            ClassOrInterfaceType type = new ClassOrInterfaceType(null, ((Class)value).getSimpleName());
            return new ClassExpr(type);
        });
    }
}

