/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.TabularHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class ArrayHandler
implements EnvironmentHandler {
    @Override
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        int numColumns = geometry[1];
        ArgumentContainerToken alignSpecToken = token.getArguments()[0];
        CharSequence alignSpecData = token.getArguments()[0].getSlice().extract();
        if (alignSpecData.length() == 0) {
            builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA1, new Object[0]);
            return;
        }
        ArrayList<String> alignments = new ArrayList<String>(alignSpecData.length());
        block5: for (int i = 0; i < alignSpecData.length(); ++i) {
            char c = alignSpecData.charAt(i);
            switch (c) {
                case 'c': {
                    alignments.add("center");
                    continue block5;
                }
                case 'l': {
                    alignments.add("left");
                    continue block5;
                }
                case 'r': {
                    alignments.add("right");
                    continue block5;
                }
                default: {
                    builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA0, String.valueOf(c));
                    alignments.add("center");
                }
            }
        }
        int maxColumns = alignments.size();
        if (maxColumns < numColumns) {
            builder.appendOrThrowError(parentElement, alignSpecToken, CoreErrorCode.TDEMA2, alignSpecData.length(), numColumns);
        }
        Element mtableElement = builder.appendMathMLElement(parentElement, "mtable");
        for (FlowToken rowToken : token.getContent()) {
            int i;
            Element mtrElement = builder.appendMathMLElement(mtableElement, "mtr");
            List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
            int rowColumns = columns.size();
            for (i = 0; i < maxColumns && i < rowColumns; ++i) {
                FlowToken columnToken = columns.get(i);
                Element mtdElement = builder.appendMathMLElement(mtrElement, "mtd");
                mtdElement.setAttribute("columnalign", (String)alignments.get(i));
                builder.handleTokens(mtdElement, ((CommandToken)columnToken).getArguments()[0].getContents(), true);
            }
            for (i = 0; i < maxColumns - rowColumns; ++i) {
                builder.appendMathMLElement(mtrElement, "mtd");
            }
        }
    }
}

