/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;

public class CommandLineRunner {
    private final String[] args;
    private final List<String> inputFiles;
    private WebPageOutputOptions snuggleOptions;
    private boolean requestedWebOutput;
    private boolean isQuiet;

    public CommandLineRunner(String[] args) {
        this.args = args;
        this.inputFiles = new ArrayList<String>();
        this.snuggleOptions = null;
        this.requestedWebOutput = false;
        this.isQuiet = false;
    }

    public int execute() {
        if (this.args.length == 0) {
            this.showHelp();
            return 1;
        }
        try {
            if (!this.parseCommandLineArguments()) {
                this.showUsage();
                return 1;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            this.showHelp();
            return 1;
        }
        if (this.inputFiles.isEmpty()) {
            System.err.println("No input files specified");
            this.showHelp();
            return 1;
        }
        SnuggleEngine engine = new SnuggleEngine();
        SnuggleSession session = engine.createSession();
        try {
            for (String inputFile : this.inputFiles) {
                SnuggleInput input = inputFile.equals("-") ? new SnuggleInput(System.in) : new SnuggleInput(new File(inputFile));
                session.parseInput(input);
            }
            if (this.requestedWebOutput) {
                session.writeWebPage(this.snuggleOptions, System.out, SnuggleSession.EndOutputAction.FLUSH);
            } else {
                System.out.println(session.buildXMLString(this.snuggleOptions));
            }
            System.out.println();
        }
        catch (IOException e) {
            System.err.println("Got IOException running SnuggleTeX: " + e.getMessage());
        }
        if (!this.isQuiet) {
            for (InputError error : session.getErrors()) {
                System.err.println(MessageFormatter.formatErrorAsString(error));
            }
        }
        return 0;
    }

    private void showHelp() {
        System.out.println("For help and usage, use the -? option");
    }

    private void showUsage() {
        InputStream usageStream = this.getClass().getClassLoader().getResourceAsStream("uk/ac/ed/ph/snuggletex/command-line-usage.txt");
        try {
            IOUtilities.transfer(usageStream, System.out);
        }
        catch (IOException e) {
            throw new SnuggleRuntimeException("Unexpected Exception printing out usage info", e);
        }
    }

    private boolean parseCommandLineArguments() {
        String nextArg;
        String arg;
        int i;
        WebPageOutputOptions.WebPageType webPageType = null;
        for (i = 0; i < this.args.length; ++i) {
            arg = this.args[i];
            String string = nextArg = i < this.args.length - 1 ? this.args[i + 1] : null;
            if (!"-web".equals(arg)) continue;
            String webPageTypeName = nextArg;
            if (webPageTypeName == null) {
                throw new IllegalArgumentException("No value provided for -web option");
            }
            try {
                webPageType = WebPageOutputOptions.WebPageType.valueOf(webPageTypeName);
                this.requestedWebOutput = true;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown web page type " + webPageTypeName + ". Legal values are" + Arrays.asList(WebPageOutputOptions.WebPageType.values()));
            }
            ++i;
        }
        this.snuggleOptions = this.requestedWebOutput ? WebPageOutputOptionsTemplates.createWebPageOptions(webPageType) : new WebPageOutputOptions();
        for (i = 0; i < this.args.length; ++i) {
            arg = this.args[i];
            String string = nextArg = i < this.args.length - 1 ? this.args[i + 1] : null;
            if ("-".equals(arg)) {
                this.inputFiles.add(arg);
                continue;
            }
            if ("-?".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                return false;
            }
            if ("-web".equals(arg)) {
                ++i;
                continue;
            }
            if ("-quiet".equals(arg)) {
                this.isQuiet = true;
                continue;
            }
            if (arg.startsWith("-")) {
                if (nextArg == null) {
                    throw new IllegalArgumentException("No value provided for " + arg + " option");
                }
                String name = arg.substring(1);
                String value = nextArg;
                if ("indent".equals(name)) {
                    int indentAmount = 0;
                    boolean badIndent = false;
                    try {
                        indentAmount = Integer.parseInt(value);
                        badIndent = indentAmount < 0;
                    }
                    catch (NumberFormatException e) {
                        badIndent = true;
                    }
                    if (badIndent) {
                        throw new IllegalArgumentException("Indent amount must be a non-negative integer");
                    }
                    if (indentAmount == 0) {
                        this.snuggleOptions.setIndenting(false);
                    } else {
                        this.snuggleOptions.setIndenting(true);
                        this.snuggleOptions.setIndent(indentAmount);
                    }
                } else if ("errors".equals(name)) {
                    try {
                        this.snuggleOptions.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.valueOf(value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unknown errors option " + value + ". Legal values are " + Arrays.asList(DOMOutputOptions.ErrorOutputOptions.values()));
                    }
                } else if ("inlinecss".equals(name)) {
                    this.snuggleOptions.setInliningCSS(this.parseBoolean(name, value));
                } else if ("xhtmlprefix".equals(name)) {
                    if (value.length() > 0) {
                        this.snuggleOptions.setXHTMLPrefix(value);
                        this.snuggleOptions.setPrefixingXHTML(true);
                    } else {
                        this.snuggleOptions.setPrefixingXHTML(false);
                    }
                } else if ("mathmlprefix".equals(name)) {
                    if (value.length() > 0) {
                        this.snuggleOptions.setMathMLPrefix(value);
                        this.snuggleOptions.setPrefixingMathML(true);
                    } else {
                        this.snuggleOptions.setPrefixingMathML(false);
                    }
                } else if ("snugglexmlprefix".equals(name)) {
                    if (value.length() > 0) {
                        this.snuggleOptions.setSnuggleXMLPrefix(value);
                        this.snuggleOptions.setPrefixingSnuggleXML(true);
                    } else {
                        this.snuggleOptions.setPrefixingSnuggleXML(false);
                    }
                } else if ("annotatemathml".equals(name)) {
                    this.snuggleOptions.setAddingMathSourceAnnotations(this.parseBoolean(name, value));
                } else if ("mathvariantmapping".equals(name)) {
                    this.snuggleOptions.setMathVariantMapping(this.parseBoolean(name, value));
                } else if ("enc".equals(name)) {
                    this.snuggleOptions.setEncoding(value);
                } else if ("xmldecl".equals(name)) {
                    this.snuggleOptions.setIncludingXMLDeclaration(this.parseBoolean(name, value));
                } else if ("entities".equals(name)) {
                    this.snuggleOptions.setUsingNamedEntities(this.parseBoolean(name, value));
                } else if ("dtpublic".equals(name)) {
                    this.snuggleOptions.setDoctypePublic(value);
                } else if ("dtsystem".equals(name)) {
                    this.snuggleOptions.setDoctypeSystem(value);
                } else if ("ctype".equals(name)) {
                    this.snuggleOptions.setContentType(value);
                } else if ("lang".equals(name)) {
                    this.snuggleOptions.setLang(value);
                } else if ("title".equals(name)) {
                    this.snuggleOptions.setTitle(value);
                } else if ("head".equals(name)) {
                    this.snuggleOptions.setAddingTitleHeading(this.parseBoolean(name, value));
                } else if ("style".equals(name)) {
                    this.snuggleOptions.setIncludingStyleElement(this.parseBoolean(name, value));
                } else if ("css".equals(name)) {
                    this.snuggleOptions.addCSSStylesheetURLs(value);
                } else if ("clientxsl".equals(name)) {
                    this.snuggleOptions.addClientSideXSLTStylesheetURLs(value);
                } else {
                    throw new IllegalArgumentException("Unknown option " + arg);
                }
                ++i;
                continue;
            }
            this.inputFiles.add(arg);
        }
        return true;
    }

    private boolean parseBoolean(String name, String value) {
        if ("true".equals(value) || "on".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "off".equals(value) || "0".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("Expected option " + name + " to have value true, false, on, off, 1 or 0, but got " + value);
    }

    public static void main(String[] args) {
        System.exit(new CommandLineRunner(args).execute());
    }
}

