/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.util.TimeUtils;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;

public class TestResultWrapper
implements TestResult,
GroovyObject {
    @Delegate
    private final TestResult testResult;
    private final TestLoggerExtension testLoggerExtension;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public TestResultWrapper(TestResult testResult, TestLoggerExtension testLoggerExtension) {
        TestLoggerExtension testLoggerExtension2;
        TestResult testResult2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.testResult = testResult2 = testResult;
        this.testLoggerExtension = testLoggerExtension2 = testLoggerExtension;
    }

    public boolean isLoggable() {
        boolean showPassed = DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowPassed()) && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSuccessfulTestCount());
        boolean showSkipped = DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowSkipped()) && (ScriptBytecodeAdapter.compareEqual((Object)this.testResult.getResultType(), (Object)TestResult.ResultType.SKIPPED) || DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSkippedTestCount()));
        boolean showFailed = DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowFailed()) && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getFailedTestCount());
        if (showPassed || showSkipped || showFailed) {
            boolean showSlow = DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowOnlySlow()) && (!this.isTooSlow() || !this.isMediumSlow());
            return !showSlow;
        }
        return false;
    }

    public boolean isStandardStreamLoggable() {
        return this.isLoggable() && DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowStandardStreams()) && (DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowPassedStandardStreams()) && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSuccessfulTestCount()) || DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowSkippedStandardStreams()) && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getSkippedTestCount()) || DefaultTypeTransformation.booleanUnbox((Object)this.testLoggerExtension.getShowFailedStandardStreams()) && DefaultTypeTransformation.booleanUnbox((Object)this.testResult.getFailedTestCount()));
    }

    public boolean isTooSlow() {
        return ScriptBytecodeAdapter.compareGreaterThanEqual((Object)(this.testResult.getEndTime() - this.testResult.getStartTime()), (Object)this.testLoggerExtension.getSlowThreshold());
    }

    public boolean isMediumSlow() {
        return ScriptBytecodeAdapter.compareGreaterThanEqual((Object)(this.testResult.getEndTime() - this.testResult.getStartTime()), (Object)NumberNumberDiv.div((Number)this.testLoggerExtension.getSlowThreshold(), (Number)2));
    }

    public String getDuration() {
        return TimeUtils.humanDuration(this.testResult.getEndTime() - this.testResult.getStartTime());
    }

    @Generated
    public TestResult.ResultType getResultType() {
        return this.testResult.getResultType();
    }

    @Generated
    public Throwable getException() {
        return this.testResult.getException();
    }

    @Generated
    public List<TestFailure> getFailures() {
        return this.testResult.getFailures();
    }

    @Generated
    public List<Throwable> getExceptions() {
        return this.testResult.getExceptions();
    }

    @Generated
    public long getStartTime() {
        return this.testResult.getStartTime();
    }

    @Generated
    public long getEndTime() {
        return this.testResult.getEndTime();
    }

    @Generated
    public long getTestCount() {
        return this.testResult.getTestCount();
    }

    @Generated
    public long getSuccessfulTestCount() {
        return this.testResult.getSuccessfulTestCount();
    }

    @Generated
    public long getFailedTestCount() {
        return this.testResult.getFailedTestCount();
    }

    @Generated
    public long getSkippedTestCount() {
        return this.testResult.getSkippedTestCount();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestResultWrapper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

