/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import com.google.gradle.osdetector.OsDetector;
import com.google.gradle.osdetector.OsDetectorPlugin;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.openjfx.gradle.JavaFXModule;
import org.openjfx.gradle.JavaFXOptions;
import org.openjfx.gradle.JavaFXPlatform;
import org.openjfx.gradle.metadatarule.JavaFXComponentMetadataRule;

@NonNullApi
public class JavaFXPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) < 0) {
            throw new GradleException("This plugin requires Gradle 6.1+");
        }
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().apply(OsDetectorPlugin.class);
        JavaFXOptions javaFXOptions = (JavaFXOptions)project.getExtensions().create("javafx", JavaFXOptions.class, new Object[]{project.getExtensions().getByType(SourceSetContainer.class), project.getExtensions().getByType(OsDetector.class)});
        for (JavaFXModule javaFXModule : JavaFXModule.values()) {
            project.getDependencies().getComponents().withModule((Object)("org.openjfx:" + javaFXModule.getArtifactName()), JavaFXComponentMetadataRule.class);
        }
        project.getPlugins().withId("java", p -> javaFXOptions.setConfiguration("implementation"));
        project.getPlugins().withId("application", p -> project.getTasks().named("run", JavaExec.class, execTask -> {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0 && execTask.getMainModule().isPresent()) {
                return;
            }
            execTask.doFirst(a -> {
                if (execTask.getExtensions().findByName("moduleOptions") != null) {
                    return;
                }
                JavaFXPlugin.putJavaFXJarsOnModulePathForClasspathApplication(execTask, javaFXOptions);
            });
        }));
    }

    private static void putJavaFXJarsOnModulePathForClasspathApplication(JavaExec execTask, JavaFXOptions javaFXOptions) {
        FileCollection classpath = execTask.getClasspath();
        execTask.setClasspath(classpath.filter(jar -> !JavaFXPlugin.isJavaFXJar(jar, javaFXOptions.getPlatform())));
        FileCollection modulePath = classpath.filter(jar -> JavaFXPlugin.isJavaFXJar(jar, javaFXOptions.getPlatform()));
        execTask.getJvmArgumentProviders().add(() -> List.of("--module-path", modulePath.getAsPath(), "--add-modules", String.join((CharSequence)",", javaFXOptions.getModules())));
    }

    private static boolean isJavaFXJar(File jar, JavaFXPlatform platform) {
        return jar.isFile() && Arrays.stream(JavaFXModule.values()).anyMatch(javaFXModule -> javaFXModule.compareJarFileName(platform, jar.getName()) || javaFXModule.getModuleJarFileName().equals(jar.getName()));
    }
}

