/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.context;

import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.typewrapper.BooleanTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.ColorTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.EnumTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.NumberTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TLIListTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TypeWrapper;

public enum Parameter {
    DISPLAY(EnumTypeWrapper.getInstance(Display.class), false, "display", "display style"),
    MATHSIZE(NumberTypeWrapper.getInstance(Float.class), false, "fontSize", "font size used for the output (mathsize)"),
    SCRIPTMINSIZE(NumberTypeWrapper.getInstance(Float.class), false, "scriptMinSize", "font size to be used for smallest script"),
    SCRIPTSIZEMULTIPLIER(NumberTypeWrapper.getInstance(Float.class), false, "scriptSizeMult", "script size multiplier"),
    SCRIPTLEVEL(NumberTypeWrapper.getInstance(Integer.class), false, "scriptLevel", "script level"),
    ANTIALIAS_MINSIZE(NumberTypeWrapper.getInstance(Float.class), false, "antiAliasMinSize", "minimum font size for which anti-alias is turned on"),
    DEBUG(BooleanTypeWrapper.getInstance(), false, "debug", "debug mode - if on, elements will have borders drawn around them"),
    ANTIALIAS(BooleanTypeWrapper.getInstance(), false, "antiAlias", "anti-alias mode"),
    MATHCOLOR(ColorTypeWrapper.getInstance(), false, "foregroundColor", "default foreground color (mathcolor)"),
    MATHBACKGROUND(ColorTypeWrapper.getInstance(), true, "backgroundColor", "default background color (mathbackground)"),
    FONTS_SANSSERIF(TLIListTypeWrapper.getInstance(), false, "fontsSansSerif", "list of font families for Sans-Serif"),
    FONTS_SERIF(TLIListTypeWrapper.getInstance(), false, "fontsSerif", "list of font families for Serif"),
    FONTS_MONOSPACED(TLIListTypeWrapper.getInstance(), false, "fontsMonospaced", "list of font families for Monospaced"),
    FONTS_SCRIPT(TLIListTypeWrapper.getInstance(), false, "fontsScript", "list of font families for Script"),
    FONTS_FRAKTUR(TLIListTypeWrapper.getInstance(), false, "fontsFraktur", "list of font families for Fraktur"),
    FONTS_DOUBLESTRUCK(TLIListTypeWrapper.getInstance(), false, "fontsDoublestruck", "list of font families for Double-Struck"),
    MFRAC_KEEP_SCRIPTLEVEL(BooleanTypeWrapper.getInstance(), false, "mfracKeepScriptLevel", "if true, <mfrac> element will NEVER increase children's scriptlevel (in violation of the spec)");

    private final TypeWrapper typeWrapper;
    private final boolean nullAllowed;
    private final String optionName;
    private final String optionDesc;

    private Parameter(TypeWrapper typeWrapper, boolean bl, String string2, String string3) {
        this.typeWrapper = typeWrapper;
        this.nullAllowed = bl;
        this.optionName = string2;
        this.optionDesc = string3;
    }

    public TypeWrapper getTypeWrapper() {
        return this.typeWrapper;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionDesc() {
        return this.optionDesc;
    }

    public boolean valid(Object object) {
        return object == null && this.nullAllowed || this.typeWrapper.valid(object);
    }

    public Object fromString(String string) {
        return this.typeWrapper.fromString(string);
    }

    public String toString(Object object) {
        return this.typeWrapper.toString(object);
    }
}

