/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.kde;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import java.io.IOException;
import java.util.List;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class KWalletBackend
implements KeyringBackend {
    private KWallet wallet;
    private DBusConnection connection;
    private int id = -1;

    public KWalletBackend() throws BackendNotSupportedException {
        try {
            this.connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            this.wallet = (KWallet)this.connection.getRemoteObject("org.kde.kwalletd5", "/modules/kwalletd5", KWallet.class, true);
            this.wallet.localWallet();
        }
        catch (Exception e) {
            throw new BackendNotSupportedException("Cannot connect to KWallet", e);
        }
    }

    @Override
    public synchronized String getPassword(String service, String account) throws PasswordAccessException {
        int id = this.openWallet(service);
        if (!this.wallet.hasEntry(id, service, account, service)) {
            throw new PasswordAccessException("Password is not in wallet");
        }
        String pass = this.wallet.readPassword(id, service, account, service);
        this.close(service);
        return pass;
    }

    @Override
    public synchronized void setPassword(String service, String account, String password) throws PasswordAccessException {
        int id = this.openWallet(service);
        this.wallet.writePassword(id, service, account, password, service);
        this.close(service);
    }

    @Override
    public synchronized void deletePassword(String service, String account) throws PasswordAccessException {
        int id = this.openWallet(service);
        if (!this.wallet.hasEntry(id, service, account, service)) {
            throw new PasswordAccessException("Password cannot be deleted, it is not in wallet");
        }
        this.wallet.removeEntry(id, service, account, service);
        if (this.wallet.entryList(id, service, service).isEmpty()) {
            this.wallet.removeFolder(id, service, service);
        }
        this.close(service);
    }

    private int openWallet(String service) {
        if (this.id >= 0) {
            if (!this.wallet.isOpen(this.id)) {
                this.id = 0;
            }
        } else {
            this.id = 0;
        }
        return this.wallet.open(this.wallet.localWallet(), this.id, service);
    }

    private void close(String service) {
        this.wallet.close(this.id, false, service);
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @DBusInterfaceName(value="org.kde.KWallet")
    static interface KWallet
    extends DBusInterface {
        public String localWallet();

        public boolean isOpen(int var1);

        public int open(String var1, long var2, String var4);

        public int close(int var1, boolean var2, String var3);

        public boolean hasEntry(int var1, String var2, String var3, String var4);

        public String readPassword(int var1, String var2, String var3, String var4);

        public int writePassword(int var1, String var2, String var3, String var4, String var5);

        public List<String> entryList(int var1, String var2, String var3);

        public int removeEntry(int var1, String var2, String var3, String var4);

        public boolean removeFolder(int var1, String var2, String var3);
    }
}

