/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.osx;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import pt.davidafsilva.apple.OSXKeychain;
import pt.davidafsilva.apple.OSXKeychainException;

public class ModernOsxKeychainBackend
implements KeyringBackend {
    private OSXKeychain keychain;

    public ModernOsxKeychainBackend() throws BackendNotSupportedException {
        if (System.getProperty("os.name", "").toLowerCase().contains("mac os")) {
            try {
                this.keychain = OSXKeychain.getInstance();
            }
            catch (OSXKeychainException e) {
                throw new BackendNotSupportedException("Modern OSX Keychain not supported.", e);
            }
        } else {
            throw new BackendNotSupportedException("Not running on Mac OS.");
        }
    }

    @Override
    public String getPassword(String service, String account) throws PasswordAccessException {
        try {
            return (String)this.keychain.findGenericPassword(service, account).orElseThrow(() -> new PasswordAccessException("No stored credentials match " + service + " account: " + account));
        }
        catch (OSXKeychainException e) {
            throw new PasswordAccessException("Failed to get credential. " + e.getMessage());
        }
    }

    @Override
    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        try {
            try {
                this.getPassword(service, account);
                this.keychain.modifyGenericPassword(service, account, password);
            }
            catch (PasswordAccessException pae) {
                this.keychain.addGenericPassword(service, account, password);
            }
        }
        catch (OSXKeychainException e) {
            throw new PasswordAccessException("Failed to set credential. " + e.getMessage());
        }
    }

    @Override
    public void deletePassword(String service, String account) throws PasswordAccessException {
        try {
            this.getPassword(service, account);
        }
        catch (PasswordAccessException pae) {
            throw new PasswordAccessException("No password to delete. " + pae.getMessage());
        }
        try {
            this.keychain.deleteGenericPassword(service, account);
        }
        catch (OSXKeychainException e) {
            throw new PasswordAccessException("Failed to set credential. " + e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
    }
}

