/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.daterange.DateRange;
import com.dlsc.gemsfx.daterange.DateRangePicker;
import com.dlsc.gemsfx.daterange.DateRangeView;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.time.format.DateTimeFormatter;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;

public class DateRangePickerSkin
extends ToggleVisibilityComboBoxSkin<DateRangePicker> {
    private final DateRangePicker picker;
    private final DateRangeView view;
    private Label titleLabel;
    private Label rangeLabel;
    private HBox hBox;

    public DateRangePickerSkin(DateRangePicker picker) {
        super(picker);
        this.picker = picker;
        this.view = picker.getDateRangeView();
        this.view.setFocusTraversable(false);
        this.view.valueProperty().bindBidirectional((Property)((DateRangePicker)this.getSkinnable()).valueProperty());
        this.view.setOnClose(this::hide);
        picker.setOnTouchPressed(evt -> {
            picker.requestFocus();
            picker.show();
        });
        picker.addEventHandler(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        picker.addEventHandler(MouseEvent.MOUSE_EXITED, this::mouseExited);
        picker.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        InvalidationListener updateLabelsListener = it -> this.updateLabels();
        picker.valueProperty().addListener(updateLabelsListener);
        picker.formatterProperty().addListener(updateLabelsListener);
        picker.valueProperty().addListener(it -> this.view.setValue((DateRange)picker.getValue()));
        picker.smallProperty().addListener(it -> this.updateView());
        this.updateView();
        this.updateLabels();
    }

    protected double computePrefHeight(double width, double v1, double v2, double v3, double v4) {
        return this.hBox.prefHeight(width);
    }

    protected double computeMaxHeight(double width, double v1, double v2, double v3, double v4) {
        return this.hBox.prefHeight(width);
    }

    @Override
    protected Node getPopupContent() {
        return this.view;
    }

    private void updateView() {
        VBox pane;
        DateRangePicker picker = (DateRangePicker)this.getSkinnable();
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"title-label");
        this.titleLabel.visibleProperty().bind((ObservableValue)picker.showPresetTitleProperty());
        this.titleLabel.managedProperty().bind((ObservableValue)picker.showPresetTitleProperty());
        this.rangeLabel = new Label();
        this.rangeLabel.getStyleClass().add((Object)"range-label");
        Region icon = new Region();
        icon.getStyleClass().add((Object)"icon");
        StackPane iconButton = new StackPane(new Node[]{icon});
        iconButton.getStyleClass().add((Object)"icon-button");
        iconButton.visibleProperty().bind((ObservableValue)picker.showIconProperty());
        iconButton.managedProperty().bind((ObservableValue)picker.showIconProperty());
        this.rangeLabel.setGraphic((Node)iconButton);
        if (!picker.isSmall()) {
            pane = new VBox(new Node[]{this.titleLabel, this.rangeLabel});
            pane.getStyleClass().remove((Object)"small");
        } else {
            Region divider = new Region();
            divider.getStyleClass().add((Object)"divider");
            divider.visibleProperty().bind((ObservableValue)picker.showPresetTitleProperty());
            divider.managedProperty().bind((ObservableValue)picker.showPresetTitleProperty());
            pane = new HBox(new Node[]{this.titleLabel, divider, this.rangeLabel});
            pane.getStyleClass().add((Object)"small");
        }
        pane.getStyleClass().add((Object)"inner-range-container");
        pane.setMinWidth(Double.NEGATIVE_INFINITY);
        Region arrow = new Region();
        arrow.getStyleClass().add((Object)"arrow");
        StackPane arrowButton = new StackPane(new Node[]{arrow});
        arrowButton.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        arrowButton.getStyleClass().add((Object)"arrow-button");
        HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
        this.hBox = new HBox(new Node[]{pane, arrowButton});
        this.hBox.setAlignment(Pos.CENTER_LEFT);
        this.hBox.getStyleClass().add((Object)"outer-range-container");
        this.updateLabels();
        this.getChildren().setAll((Object[])new Node[]{this.hBox});
    }

    private void updateLabels() {
        DateRange dateRange = (DateRange)((DateRangePicker)this.getSkinnable()).getValue();
        if (dateRange != null) {
            if (StringUtils.isNotBlank((CharSequence)dateRange.getTitle())) {
                this.titleLabel.setText(dateRange.getTitle());
            } else {
                this.titleLabel.setText(((DateRangePicker)this.getSkinnable()).getCustomRangeText());
            }
            this.rangeLabel.setText(this.toString(dateRange));
        } else {
            this.titleLabel.setText("");
            this.rangeLabel.setText("");
        }
    }

    public String toString(DateRange range) {
        DateTimeFormatter formatter = ((DateRangePicker)this.getSkinnable()).getFormatter();
        if (range.getStartDate().equals(range.getEndDate())) {
            return formatter.format(range.getStartDate());
        }
        return formatter.format(range.getStartDate()) + " - " + formatter.format(range.getEndDate());
    }
}

