/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.FamilyOptimizer;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.families.Family;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BD\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\f2\u0006\u0010\u0012\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016R\"\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/model/FamilyIdOptimizer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "D", "Lcom/intellij/database/model/FamilyOptimizer;", "idGetter", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "checker", "Lcom/intellij/database/model/ElementChecker;", "family", "Lcom/intellij/database/model/families/Family;", "<init>", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/database/model/ElementChecker;Lcom/intellij/database/model/families/Family;)V", "getIdGetter", "()Lkotlin/jvm/functions/Function1;", "findOptimized", "data", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicElement;", "optimizeOne", "", "(Lcom/intellij/database/model/families/Family;Ljava/lang/Object;)Ljava/lang/Iterable;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nElementCacheOptimizers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementCacheOptimizers.kt\ncom/intellij/database/model/FamilyIdOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
final class FamilyIdOptimizer<T extends BasicElement, D>
extends FamilyOptimizer<T, D> {
    @NotNull
    private final Function1<D, Long> idGetter;

    public FamilyIdOptimizer(@NotNull Function1<? super D, Long> idGetter, @NotNull ElementChecker<T, D> checker, @NotNull Family<? extends T> family) {
        Intrinsics.checkNotNullParameter(idGetter, (String)"idGetter");
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        Intrinsics.checkNotNullParameter(family, (String)"family");
        super(checker, family);
        this.idGetter = idGetter;
    }

    @NotNull
    public final Function1<D, Long> getIdGetter() {
        return this.idGetter;
    }

    @Override
    @Nullable
    public T findOptimized(D data) {
        return this.findIn(this.optimizeOne(this.getFamily(), data), data);
    }

    private final Iterable<T> optimizeOne(Family<? extends T> family, D data) {
        if (family.size() < this.getOptimizeAt()) {
            return family;
        }
        List<BasicIdentifiedElement> all = BaseModel.getIndexedElementsWithId(family, ((Number)this.idGetter.invoke(data)).longValue());
        if (all == null || all.size() > family.size()) {
            return family;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)all).filterMap(arg_0 -> FamilyIdOptimizer.optimizeOne$lambda$2(arg_0 -> FamilyIdOptimizer.optimizeOne$lambda$1(family, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return (Iterable)jBIterable;
    }

    private static final BasicElement optimizeOne$lambda$1(Family $family, BasicIdentifiedElement e) {
        BasicIdentifiedElement basicIdentifiedElement;
        BasicIdentifiedElement it = basicIdentifiedElement = e;
        boolean bl = false;
        BasicIdentifiedElement basicIdentifiedElement2 = Intrinsics.areEqual(e.getParentFamily(), (Object)$family) ? basicIdentifiedElement : null;
        return basicIdentifiedElement2 instanceof BasicElement ? (BasicElement)basicIdentifiedElement2 : null;
    }

    private static final BasicElement optimizeOne$lambda$2(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }
}

