/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.UtilKt;
import com.intellij.database.console.ssh.DatabaseSshTunnelsManager;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.RemoteDriverFactory;
import com.intellij.database.remote.jdbc.RemoteProcessController;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JdbcDriverManagerImpl
extends JdbcDriverManager
implements Disposable {
    private final EventDispatcher<ModificationTrackerListener<JdbcDriverManager>> myDispatcher;
    private final DatabaseSshTunnelsManager mySshManager;
    private final RemoteConsoleProcessSupport<LocalDataSource, RemoteDriverFactory> mySupport;
    private final Project myProject;

    public JdbcDriverManagerImpl(@NotNull Project project) {
        if (project == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = DataSourceUtil.eventDispatcher(ModificationTrackerListener.class);
        this.myProject = project;
        this.mySshManager = new DatabaseSshTunnelsManager(project);
        this.mySupport = new RemoteConsoleProcessSupport<LocalDataSource, RemoteDriverFactory>(RemoteDriverFactory.class){

            protected void fireModificationCountChanged() {
                JdbcDriverManagerImpl.this.incModificationCount();
                ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)JdbcDriverManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)JdbcDriverManagerImpl.this));
            }

            @Override
            protected ConsoleRunConfiguration.RunContext createRunContext(@NotNull LocalDataSource target) {
                if (target == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new JdbcConsoleRunContext(target);
            }

            protected String getName(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSource.getName();
            }

            protected void logText(@NotNull ConsoleRunConfiguration configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (1.passDebuggerAttachMessage(event, outputType)) {
                    return;
                }
                String text = StringUtil.notNullize((String)event.getText());
                if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.warn(text.trim());
                } else {
                    LOG.info(text.trim());
                }
            }

            private static boolean passDebuggerAttachMessage(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return false;
                }
                String text = event.getText();
                if (text == null) {
                    return false;
                }
                if (!text.startsWith("Listening for transport ") || !text.contains(" at address: ")) {
                    return false;
                }
                System.out.println("Remote JDBC process is ready for debug: " + text);
                return true;
            }

            @Override
            protected RunProfileState getRunProfileState(@NotNull LocalDataSource target, @NotNull ConsoleRunConfiguration configuration, @NotNull Executor executor) throws ExecutionException {
                if (target == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (configuration == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (executor == null) {
                    1.$$$reportNull$$$0(9);
                }
                RunProfileState result = super.getRunProfileState(target, configuration, executor);
                JdbcDriverManagerImpl.this.mySshManager.createTunnels(target);
                return result;
            }

            @Override
            public RemoteDriverFactory acquire(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration, @Nullable ProgressIndicator indicator) throws Exception {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (configuration == null) {
                    1.$$$reportNull$$$0(11);
                }
                RemoteDriverFactory driverFactory = (RemoteDriverFactory)super.acquire(dataSource, configuration, indicator);
                JdbcDriverManagerImpl.this.mySshManager.validateSshTunnels(dataSource);
                return driverFactory;
            }

            protected void onCreated(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration, @NotNull RemoteDriverFactory result) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (configuration == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(14);
                }
                ((JdbcDriverManager.Listener)JdbcDriverManagerImpl.this.myProject.getMessageBus().syncPublisher(JdbcDriverManager.TOPIC)).onStarted(dataSource, configuration);
            }

            @Override
            @NotNull
            protected ThrowableComputable<RemoteDriverFactory, Exception> acquireInProcessFactory(LocalDataSource target, ConsoleRunConfiguration configuration) throws Exception {
                ThrowableComputable<@Nullable V, Exception> res2 = super.acquireInProcessFactory(target, configuration);
                JdbcDriverManagerImpl.this.mySshManager.createTunnels(target);
                ThrowableComputable throwableComputable = res2;
                if (throwableComputable == null) {
                    1.$$$reportNull$$$0(15);
                }
                return throwableComputable;
            }

            public void stopAll(boolean waitFor2) {
                super.stopAll(waitFor2);
                JdbcDriverManagerImpl.this.mySshManager.destroyAllTunnels();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 15 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: 
                    case 10: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 11: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcDriverManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl$1";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "acquireInProcessFactory";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createRunContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "logText";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "passDebuggerAttachMessage";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getRunProfileState";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "acquire";
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "onCreated";
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 15 -> new IllegalStateException(string);
                };
            }
        };
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> {
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)this.myProject);
            for (Pair pair : this.mySupport.getActiveConfigurations()) {
                DbDataSource dataSource = facade.findDataSource(((LocalDataSource)pair.first).getUniqueId());
                if (DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource) == pair.first) continue;
                this.releaseDriver((LocalDataSource)pair.first, null);
            }
        });
        Disposer.register((Disposable)this, this.mySupport);
    }

    public void dispose() {
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource dataSource, @Nullable DatabaseCredentials credentialsStore) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(1);
        }
        ConsoleRunConfiguration consoleRunConfiguration = JdbcDriverManagerImpl.chooseRunConfiguration(this.myProject, dataSource, credentialsStore);
        if (consoleRunConfiguration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return consoleRunConfiguration;
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(3);
        }
        return this.mySupport.getActiveConfigurations(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteDriver getDriver(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        RemoteDriverFactory factory;
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(5);
        }
        if ((factory = this.mySupport.acquire(dataSource, configuration, ProgressIndicatorProvider.getGlobalProgressIndicator())).tryLockIfNotInitialized()) {
            try {
                factory.setClassPath(JdbcConsoleRunContext.shouldIsolateClassPath(dataSource) ? JdbcConsoleRunContext.getIsolatedClassPath(dataSource).getPathList() : List.of());
                UtilKt.initProcessBlocking((RemoteProcessController)factory, dataSource, configuration, this.myProject);
            }
            finally {
                factory.unlock();
            }
        }
        return factory.getDriver();
    }

    @Override
    @NotNull
    public List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(6);
        }
        List<DatabaseSshTunnelEstablisher.SshTunnel> list = this.mySshManager.getTunnels(dataSource);
        if (list == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public HostPort createProxyServer(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(8);
        }
        return this.mySshManager.createProxyServer(dataSource);
    }

    @Nullable
    public Throwable getTunnelsState(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(9);
        }
        return this.mySshManager.getTunnelsState(dataSource);
    }

    @Override
    @NotNull
    public Future<?> releaseDriver(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(10);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            JdbcDriverManagerImpl.terminateConnections(dataSource, configuration);
            try {
                this.mySupport.release(dataSource, (Object)configuration).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((JdbcDriverManager.Listener)this.getProject().getMessageBus().syncPublisher(TOPIC)).onTerminated(dataSource, configuration);
            (configuration == null ? DatabaseCredentials.getInstance() : configuration.CREDENTIALS).handleSessionFinished((DasDataSource)dataSource);
            if (this.getActiveConfigurations(dataSource).isEmpty()) {
                this.mySshManager.destroyTunnels(dataSource);
            }
        });
        if (future == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(11);
        }
        return future;
    }

    @TestOnly
    public void killRemote(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) throws Exception {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(12);
        }
        this.mySupport.release(dataSource, (Object)configuration).get();
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> listener2, Disposable disposable) {
        this.myDispatcher.addListener(listener2, disposable);
    }

    private static ConsoleRunConfiguration chooseRunConfiguration(Project project, LocalDataSource dataSource, DatabaseCredentials credentialsStore) {
        List<ConsoleRunConfiguration> active;
        JdbcDriverManager driverManager = JdbcDriverManagerImpl.getDriverManager(project);
        boolean isTemporary = dataSource.isTemporary();
        if (!isTemporary && !(active = driverManager.getActiveConfigurations(dataSource)).isEmpty()) {
            return active.get(0);
        }
        ConsoleRunConfiguration configuration = ConsoleRunConfiguration.newConfiguration(project);
        configuration.setOptionsFromDataSource(dataSource);
        if (credentialsStore != null) {
            configuration.CREDENTIALS = credentialsStore;
        }
        return configuration;
    }

    private static void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(13);
        }
        try {
            DatabaseConnectionManager.getInstance().terminateConnections(dataSource, configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTunnels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "releaseDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDriver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTunnels";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProxyServer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTunnelsState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "releaseDriver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "killRemote";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "terminateConnections";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 11 -> new IllegalStateException(string);
        };
    }
}

