/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.data.input;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.dataspell.jupyter.customCells.sql.metadata.JupyterSqlVariableName;
import com.intellij.dataspell.jupyter.customCells.sql.metadata.SqlCellMetadata;
import com.intellij.dataspell.jupyter.customCells.sql.metadata.SqlCellMetadataKt;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverterTask;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlagKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/data/input/JupyterDataInputToSqlCellConverter;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter;", "<init>", "()V", "convertCell", "", "task", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverterTask;", "replaceDataInputWithSql", "intellij.dataspell.jupyter.customCells"})
public final class JupyterDataInputToSqlCellConverter
implements NotebookCellConverter {
    public boolean convertCell(@NotNull NotebookCellConverterTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return !JupyterEditorInitializationFlagKt.isJupyterInitialized((Editor)task.getEditor()) ? false : (JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(task.getInterval()) == JupyterCellType.DATA_INPUT && task.getNewType().getJupyterCellType() == JupyterCellType.SQL ? this.replaceDataInputWithSql(task) : false);
    }

    private final boolean replaceDataInputWithSql(NotebookCellConverterTask task) {
        Editor editor = task.getEditor();
        NotebookCellLines.Interval interval = task.getInterval();
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook();
        JupyterCell jupyterCell = notebook.getCellOrNull(interval.getOrdinal());
        if (jupyterCell == null) {
            return false;
        }
        JupyterCell cell = jupyterCell;
        if (!JupyterDataInputCellTableMetadataKt.getHasTableMetadata((JupyterCell)cell)) {
            return false;
        }
        JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata((JupyterCell)cell);
        if (jupyterDataInputCellTableMetadata == null) {
            return false;
        }
        JupyterDataInputCellTableMetadata tableMetadata = jupyterDataInputCellTableMetadata;
        String string = tableMetadata.getDataSourceUniqueId();
        if (string == null) {
            return false;
        }
        String dataSourceUniqueId = string;
        String string2 = tableMetadata.getTableObjectPath();
        if (string2 == null) {
            return false;
        }
        String tableObjectPathDeserialized = string2;
        ObjectPath objectPath = ObjectPath.deserialize((String)tableObjectPathDeserialized);
        if (objectPath == null) {
            return false;
        }
        ObjectPath tableObjectPath = objectPath;
        DbDataSource dbDataSource = DbPsiFacade.getInstance((Project)project2).findDataSource(dataSourceUniqueId);
        if (dbDataSource == null) {
            return false;
        }
        DbDataSource dataSource = dbDataSource;
        DbElement dbElement = dataSource.findElement(tableObjectPath);
        if (dbElement == null) {
            return false;
        }
        DbElement tableElement = dbElement;
        String string3 = dataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String dataSourceName = string3;
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        DmlHelper generator = DmlUtilKt.dmlGenerator((Dbms)dbms);
        SelectTask.Companion.Builder builder = DmlTaskKt.allColumns((DasObject)((DasObject)tableElement)).version(dataSource.getVersion());
        DdlBuilder ddlBuilder = DbImplUtilCore.createBuilderForUIExec((Dbms)dataSource.getDbms(), (DasObject)((DasObject)tableElement));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"createBuilderForUIExec(...)");
        SelectTask selectTask = builder.build(ddlBuilder);
        String query = ((SelectGenerationResult)generator.generate((DmlTask)selectTask)).getStatement();
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (object == null || (object = object.makeCell(query, NotebookCellLines.CellType.CODE, "sql")) == null) {
            return false;
        }
        Object cellText = object;
        List newIntervals = NotebookCellConverter.Companion.replaceCellWithUndoSupport(editor, (String)cellText, interval, NotebookCellLines.Companion.get(editor));
        for (NotebookCellLines.Interval interval2 : newIntervals) {
            JupyterCell newCell = notebook.getCell(interval2.getOrdinal());
            SqlCellMetadataKt.setSqlMetadata(newCell, new SqlCellMetadata(dataSourceName, JupyterSqlVariableName.Companion.getNameGenerator().makeUniqueName(JupyterEditorExtensionsKt.getNotebookFile((Editor)editor).getNotebook())));
        }
        return true;
    }
}

