/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion.common;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.platform.trialPromotion.common.TrialStateService;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.EnvironmentUtil;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J;\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\tJ\n\u0010\u0011\u001a\u00020\u0005*\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/trialPromotion/common/TrialStateUtils;", "", "<init>", "()V", "isNonEvaluationLicenseActive", "", "getTrialLengthDays", "", "showRegister", "", "productCode", "", "requestTrial", "requestRevalidate", "showTrialDialog", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "openTrialStateTab", "isBeforeToday", "", "isEligibleForAutoTrial", "checkTrialState", "LS_URL_ENVIRONMENT_VAR", "isLicenseServerUrlSpecified", "isImportedConfigOldEnough", "intellij.platform.trialPromotion.common"})
@SourceDebugExtension(value={"SMAP\nTrialStateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrialStateUtils.kt\ncom/intellij/platform/trialPromotion/common/TrialStateUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class TrialStateUtils {
    @NotNull
    public static final TrialStateUtils INSTANCE = new TrialStateUtils();
    @NotNull
    private static final String LS_URL_ENVIRONMENT_VAR = "JETBRAINS_LICENSE_SERVER";

    private TrialStateUtils() {
    }

    public final boolean isNonEvaluationLicenseActive() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return false;
        }
        LicensingFacade licensingFacade2 = licensingFacade;
        if (licensingFacade2.getConfirmationStamp(licensingFacade2.platformProductCode) == null) {
            return false;
        }
        return !licensingFacade2.isEvaluation;
    }

    public final int getTrialLengthDays() {
        Date date;
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return 0;
        }
        LicensingFacade license = licensingFacade;
        Date date2 = license.getLicenseExpirationDate();
        if (date2 == null) {
            return 0;
        }
        Date expirationDate = date2;
        String metadata = license.metadata;
        if (metadata == null || metadata.length() < 20) {
            return 0;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            String string = metadata.substring(2, 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return 0;
        }
        Date generationDate = date;
        long result = Math.max(ChronoUnit.DAYS.between(generationDate.toInstant(), expirationDate.toInstant()), 0L);
        return (int)result;
    }

    public final void showRegister(@Nullable String productCode, @Nullable Boolean requestTrial, @Nullable Boolean requestRevalidate, @Nullable Boolean showTrialDialog) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Register");
        if (anAction == null) {
            return;
        }
        AnAction registerAction = anAction;
        DataContext dataContext = arg_0 -> TrialStateUtils.showRegister$lambda$0(productCode, requestRevalidate, requestTrial, showTrialDialog, arg_0);
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext, null, (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        ActionUtil.performAction((AnAction)registerAction, (AnActionEvent)event);
    }

    public static /* synthetic */ void showRegister$default(TrialStateUtils trialStateUtils, String string, Boolean bl, Boolean bl2, Boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            bl3 = null;
        }
        trialStateUtils.showRegister(string, bl, bl2, bl3);
    }

    public final void openTrialStateTab() {
        AnAction action = ActionManager.getInstance().getAction("TrialStateWidget");
        if (action != null) {
            ActionManager.getInstance().tryToExecute(action, null, null, "MainToolbar", false);
        }
    }

    public final boolean isBeforeToday(long $this$isBeforeToday) {
        LocalDateTime time = Instant.ofEpochMilli($this$isBeforeToday).atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        return time.isBefore(startOfDay);
    }

    public final boolean isEligibleForAutoTrial(boolean checkTrialState) {
        return !(checkTrialState && !TrialStateService.Companion.isTrialAvailable() || this.isLicenseServerUrlSpecified() || !ConfigImportHelper.isNewUser() && !this.isImportedConfigOldEnough());
    }

    public static /* synthetic */ boolean isEligibleForAutoTrial$default(TrialStateUtils trialStateUtils, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return trialStateUtils.isEligibleForAutoTrial(bl);
    }

    private final boolean isLicenseServerUrlSpecified() {
        String string;
        String envVar;
        String string2 = EnvironmentUtil.getValue((String)LS_URL_ENVIRONMENT_VAR);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            v1 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            v1 = envVar = null;
        }
        if (envVar != null) {
            return true;
        }
        String string4 = System.getProperty(LS_URL_ENVIRONMENT_VAR, null);
        if (string4 != null) {
            String string5;
            String it = string5 = string4;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string5 : null;
        } else {
            string = null;
        }
        String systemProperty = string;
        return systemProperty != null;
    }

    private final boolean isImportedConfigOldEnough() {
        String string = System.getProperty("intellij.config.imported.from.other.product");
        if (string == null && (string = System.getProperty("intellij.config.imported.from.previous.version")) == null) {
            return false;
        }
        String configFolder = string;
        Path configFolderPath = Path.of(configFolder, new String[0]);
        Intrinsics.checkNotNull((Object)configFolderPath);
        Matcher matcher = ConfigImportHelper.SELECTOR_PATTERN.matcher(PathsKt.getName((Path)configFolderPath));
        if (!matcher.matches()) {
            return false;
        }
        FileTime fileTime = ConfigImportHelper.getConfigLastModifiedTime((Path)configFolderPath);
        if (fileTime == null) {
            return false;
        }
        FileTime lastModified = fileTime;
        return ConfigImportHelper.isConfigOld((FileTime)lastModified);
    }

    private static final Object showRegister$lambda$0(String $productCode, Boolean $requestRevalidate, Boolean $requestTrial, Boolean $showTrialDialog, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (it) {
            case "register.product-descriptor.code" -> $productCode;
            case "register.request.revalidate" -> $requestRevalidate;
            case "register.request.trial" -> $requestTrial;
            case "register.show.trial.dialog" -> $showTrialDialog;
            default -> null;
        };
    }
}

