/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.lang.javascript.structureView.JSStructureViewModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;

public class JSStructureViewExtension
implements StructureViewExtension {
    public Class<? extends PsiElement> getType() {
        return XmlTag.class;
    }

    public StructureViewTreeElement[] getChildren(PsiElement parent) {
        JSElement element2 = JSStructureViewExtension.findScriptFile(parent, true);
        if (element2 != null) {
            boolean ecma = element2.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
            return new JSStructureViewElement((PsiElement)element2, ecma).getChildren();
        }
        return null;
    }

    public Object getCurrentEditorElement(Editor editor, PsiElement parent) {
        JSElement element2 = JSStructureViewExtension.findScriptFile(parent, false);
        if (element2 != null) {
            PsiFile file = element2.getContainingFile();
            if (InjectedLanguageManager.getInstance((Project)element2.getProject()).isInjectedFragment(file)) {
                editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file);
            }
            return new JSStructureViewModel((PsiElement)element2, editor).getCurrentEditorElement();
        }
        return null;
    }

    private static JSElement findScriptFile(PsiElement parent, boolean respectFileReferences) {
        JSElement element2 = null;
        XmlTag xmlTag = (XmlTag)parent;
        String name = xmlTag.getLocalName();
        if (respectFileReferences && "Script".equals(xmlTag.getLocalName()) && FlexSupportLoader.isLanguageNamespace(xmlTag.getNamespace())) {
            PsiFile includedFile;
            XmlAttribute sourceAttribute = xmlTag.getAttribute("source");
            PsiFile psiFile = includedFile = sourceAttribute == null ? null : FileReferenceUtil.findFile((PsiElement)sourceAttribute.getValueElement());
            if (includedFile instanceof JSFile) {
                return (JSFile)includedFile;
            }
        }
        if ("script".equalsIgnoreCase(name) && (element2 = (JSElement)PsiTreeUtil.getChildOfType((PsiElement)xmlTag, JSElement.class)) == null) {
            JSFile[] injectedFile = new JSFile[1];
            for (XmlTagChild c : xmlTag.getValue().getChildren()) {
                if (!(c instanceof PsiLanguageInjectionHost)) continue;
                InjectedLanguageManager.getInstance((Project)c.getProject()).enumerate((PsiElement)c, (injectedPsi, places) -> {
                    if (injectedPsi instanceof JSFile) {
                        injectedFile[0] = (JSFile)injectedPsi;
                    }
                });
            }
            if (injectedFile[0] != null) {
                element2 = injectedFile[0];
            }
        }
        return element2;
    }
}

