/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.editor.markup.ExtendedBackendProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.TextUpdateModel;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfo;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderLinkActivationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\u001c\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cJ$\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\u0006\u0010#\u001a\u00020\fJ\u0018\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001fJ!\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020%0(\u00a2\u0006\u0002\b)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager;", "<init>", "()V", "removeAllItems", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "setItemsToEditor", "itemsToSet", "Lcom/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items;", "collapseNewItems", "", "resetToDefaultState", "getItems", "", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "isRenderedDocHighlighter", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addFolding", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/DocRenderInfo;", "h", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "addItems", "highlighters", "", "removeItems", "ids", "", "updateItems", "updates", "Lcom/jetbrains/rd/ide/model/TextUpdateModel;", "recreate", "getItem", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "id", "getStorage", "", "Lorg/jetbrains/annotations/Nullable;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocRenderItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocRenderItemManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1617#2,9:126\n1869#2:135\n1870#2:137\n1626#2:138\n1#3:136\n14#4:139\n*S KotlinDebug\n*F\n+ 1 FrontendDocRenderItemManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager\n*L\n80#1:126,9\n80#1:135\n80#1:137\n80#1:138\n80#1:136\n99#1:139\n*E\n"})
public final class FrontendDocRenderItemManager
implements DocRenderItemManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Map<Long, FrontendDocRenderItem>> OUR_ITEMS;
    @NotNull
    private static final Logger logger;

    public void removeAllItems(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Map map = (Map)editor.getUserData(OUR_ITEMS);
        if (map == null) {
            return;
        }
        map.clear();
        this.setupListeners(editor, true);
        editor.putUserData(OUR_ITEMS, null);
    }

    public void setItemsToEditor(@NotNull Editor editor, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)itemsToSet, (String)"itemsToSet");
    }

    public void resetToDefaultState(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    @NotNull
    public Collection<DocRenderItem> getItems(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = (Map)editor.getUserData(OUR_ITEMS);
        if (object == null || (object = object.values()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public boolean isRenderedDocHighlighter(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        ExtendedBackendProperties extendedBackendProperties = UtilKt.getExtendedBackendProperties((RangeHighlighter)highlighter);
        return (extendedBackendProperties != null ? extendedBackendProperties.getHandler() : null) instanceof FrontendDocRenderHighlighterModelHandler;
    }

    @Nullable
    public final CustomFoldRegion addFolding(@NotNull Editor editor, @NotNull DocRenderInfo info2, @NotNull RangeHighlighterEx h) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        long id = info2.getId();
        FrontendDocRenderItem item = this.getStorage(editor).get(id);
        if (item == null) {
            logger.error("no item on folding creation in " + editor);
            return null;
        }
        item.setTextToRender(info2.getTextToRender());
        item.setRenderer(info2.getGutterRenderer());
        DocRenderer renderer = new DocRenderer((DocRenderItem)item, (DocRenderLinkActivationHandler)FrontendDocRenderLinkActivationHandler.INSTANCE);
        CustomFoldRegion region = editor.getFoldingModel().addCustomLinesFolding(editor.getDocument().getLineNumber(h.getStartOffset()), editor.getDocument().getLineNumber(h.getEndOffset()), (CustomFoldRegionRenderer)renderer);
        item.setFoldRegion(region);
        item.setRegionBackendId(UtilKt.getBackendId((RangeHighlighter)((RangeHighlighter)h)));
        return region;
    }

    public final void addItems(@NotNull Editor editor, @NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        if (highlighters.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> storage = this.getStorage(editor);
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            Long l = UtilKt.getBackendId((RangeHighlighter)((RangeHighlighter)rangeHighlighterEx));
            Intrinsics.checkNotNull((Object)l);
            storage.put(l, new FrontendDocRenderItem((RangeHighlighter)rangeHighlighterEx, editor));
        }
    }

    public final void removeItems(@NotNull Editor editor, @NotNull List<Long> ids) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> storage = this.getStorage(editor);
        Iterator<Long> iterator2 = ids.iterator();
        while (iterator2.hasNext()) {
            long id = ((Number)iterator2.next()).longValue();
            storage.remove(id);
        }
        if (storage.isEmpty()) {
            this.removeAllItems(editor);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateItems(@NotNull Editor editor, @NotNull List<TextUpdateModel> updates, boolean recreate) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        if (updates.isEmpty()) {
            return;
        }
        Map<Long, FrontendDocRenderItem> storage = this.getStorage(editor);
        Iterable $this$mapNotNull$iv = updates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FrontendDocRenderItem it$iv$iv;
            FrontendDocRenderItem item;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TextUpdateModel textUpdateModel = (TextUpdateModel)element$iv$iv;
            boolean bl2 = false;
            FrontendDocRenderItem frontendDocRenderItem = item = storage.get(textUpdateModel.getId());
            if (frontendDocRenderItem != null) {
                frontendDocRenderItem.setTextToRender(textUpdateModel.getText());
            }
            if (item == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List regionsToUpdate = (List)destination$iv$iv;
        DocRenderItemUpdater.updateRenderers((Collection)regionsToUpdate, (boolean)recreate);
    }

    @Nullable
    public final FrontendDocRenderItem getItem(@NotNull Editor editor, long id) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getStorage(editor).get(id);
    }

    private final Map<Long, FrontendDocRenderItem> getStorage(Editor editor) {
        Map map = (Map)editor.getUserData(OUR_ITEMS);
        if (map == null) {
            HashMap hashMap;
            HashMap it = hashMap = new HashMap();
            boolean bl = false;
            this.setupListeners(editor, false);
            editor.putUserData(OUR_ITEMS, it);
            map = hashMap;
        }
        return map;
    }

    static {
        Key key = Key.create((String)"frontend.doc.render.items");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        OUR_ITEMS = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDocRenderItemManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDocRenderItemManager.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItemManager$Companion;", "", "<init>", "()V", "OUR_ITEMS", "Lcom/intellij/openapi/util/Key;", "", "", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

