/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DerbyJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> DERBY_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "smallint", "bigint", "date", "time", "xml", "timestamp", "boolean", "double", "real", "float", "long varchar", "long varchar for bit data");

    public DerbyJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("DERBY", version, connection, jdbcClassLoader);
    }

    public DerbyJdbcHelper() {
        this(null, null, null);
    }

    private DerbyJdbcHelper(@NotNull DerbyJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return DerbyJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new DerbyJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(2);
        }
        return new DerbyJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(3);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DERBY_UNLIMITED_TYPES.contains(t) || DEFAULT_UNLIMITED_TYPES.contains(t) && e.length == Integer.MAX_VALUE) {
            e.length = -1;
        }
        DerbyJdbcHelper.processForBitData(e);
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) {
        if (!JdbcNativeUtil.detectString(product, "derby")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return DerbyJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(4);
        }
        return DerbyJdbcHelper.classNameContains(driver, "apache.derby.");
    }

    @NotNull
    private static DerbyJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new DerbyJdbcHelper(DerbyJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        if (level != null) {
            DerbyJdbcHelper.setIfEmpty(properties, "traceLevel", "-1");
        }
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/DerbyJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

