/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.openapi.util.Pair;
import com.intellij.python.remoteInterpreter.PySshProcessHandlerProviderKt;
import com.intellij.ssh.SshSession;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/remoteInterpreter/SshSessionPortForwarder;", "Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;", "session", "Lcom/intellij/ssh/SshSession;", "<init>", "(Lcom/intellij/ssh/SshSession;)V", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "forwardedRemotePorts", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "close", "", "getRemoteSocket", "Lcom/intellij/openapi/util/Pair;", "", "localPort", "intellij.python.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nPySshProcessHandlerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySshProcessHandlerProvider.kt\ncom/intellij/python/remoteInterpreter/SshSessionPortForwarder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1869#2,2:57\n*S KotlinDebug\n*F\n+ 1 PySshProcessHandlerProvider.kt\ncom/intellij/python/remoteInterpreter/SshSessionPortForwarder\n*L\n37#1:57,2\n*E\n"})
final class SshSessionPortForwarder
implements PyRemoteSocketToLocalHostProvider {
    @NotNull
    private final SshSession session;
    @NotNull
    private final AtomicBoolean isClosed;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> forwardedRemotePorts;

    public SshSessionPortForwarder(@NotNull SshSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.isClosed = new AtomicBoolean(false);
        this.forwardedRemotePorts = ConcurrentHashMap.newKeySet();
    }

    /*
     * WARNING - void declaration
     */
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            void $this$forEach$iv;
            ConcurrentHashMap.KeySetView<Integer, Boolean> keySetView = this.forwardedRemotePorts;
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"forwardedRemotePorts");
            Iterable iterable = keySetView;
            SshSession sshSession = this.session;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int p0 = ((Number)element$iv).intValue();
                boolean bl = false;
                PySshProcessHandlerProviderKt.access$safeRemoveRemoteTunnel(sshSession, p0);
            }
        }
    }

    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("SSH session port forwarder is closed");
        }
        int remotePort = this.session.addRemoteTunnelWithRandomRemotePort("localhost", localPort);
        this.forwardedRemotePorts.add(remotePort);
        Pair pair = Pair.create((Object)"localhost", (Object)remotePort);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }
}

