/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.popups;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.impl.popups.GraphPopupManager;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.project.Project;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/graph/impl/popups/GraphPopupMode;", "N", "E", "Lcom/intellij/openapi/graph/view/ViewMode;", "builder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "GraphPopupMode", "(Lcom/intellij/openapi/graph/builder/GraphBuilder;)V", "popupManager", "Lcom/intellij/openapi/graph/impl/popups/GraphPopupManager;", "mouseMoved", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "mouseClicked", "intellij.platform.graph.impl"})
public final class GraphPopupMode<N, E>
extends ViewMode {
    @NotNull
    private final GraphBuilder<N, E> builder;
    @NotNull
    private final GraphPopupManager<N, E> popupManager;

    public GraphPopupMode(@NotNull GraphBuilder<N, E> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.builder = builder;
        Project project = this.builder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.popupManager = GraphPopupManager.Companion.getInstance(project);
    }

    public void mouseMoved(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        this.builder.getActionExecutor().tryRunReadAction(() -> GraphPopupMode.r(this, mouseEvent));
    }

    public void mouseClicked(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        super.mouseClicked(mouseEvent);
        this.popupManager.hidePopup();
    }

    private static final void r(GraphPopupMode graphPopupMode, MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        HitInfo hitInfo = graphPopupMode.getHitInfo(mouseEvent);
        Node node = hitInfo.getHitNode();
        Edge edge = hitInfo.getHitEdge();
        graphPopupMode.popupManager.handleMouseEvent(graphPopupMode.builder, mouseEvent, node, edge);
    }
}

