# Projects Using Rhino JavaScript Engine

Many projects leverage the Rhino library to add JavaScript support to their Java applications. Here is a comprehensive list of notable implementations.

**Know of other projects using Rhino?** 🚀  
We'd love to hear about them! If you know of any other applications, platforms, or projects that use the Rhino JavaScript engine,
please share them in our community discussion: **[Report Rhino Usage Examples](https://github.com/mozilla/rhino/discussions/1425)**


## Enterprise & Cloud Platforms

- **VMware Aria Automation 8.18.1** - Data center automation platform
  [Source](https://techdocs.broadcom.com/us/en/vmware-cis/aria/aria-automation/8-18/vco-installing-and-configuring-8-18/key-features-of-the-orchestrator-platform.html)

- **[ThingWorx](https://www.ptc.com/de/products/thingworx) 9.7** - Industrial IoT platform for connecting and managing industrial assets
  [Source](https://support.ptc.com/help/thingworx/platform/r9.7/en/index.html#page/ThingWorx/Help/Composer/Things/ThingServices/RhinoJavaScriptEngine.html)

- **[Apigee](https://cloud.google.com/apigee)** - Google Cloud's native API management platform for building, managing, and securing APIs
  [Source](https://cloud.google.com/apigee/docs/api-platform/reference/policies/javascript-policy)

- **[ServiceNow](https://www.servicenow.com/)** - Intelligent platform for digital transformation and enterprise workflow automation
  [Source](https://support.servicenow.com/kb?id=kb_article_view&sysparm_article=KB0721865)

- **[Salesforce B2C Commerce](https://www.salesforce.com/products/commerce-cloud/ecommerce/)** - Enterprise e-commerce platform using Rhino for server-side JavaScript scripting
  [Source](https://developer.salesforce.com/docs/commerce/b2c-commerce/guide/demandwarejavascript.html)

## Healthcare & Integration

- **Mirth Connect 4.5** - Healthcare integration engine supporting HL7, EDI, and other healthcare standards
  [Source](https://docs.nextgen.com/bundle/Mirth_User_Guide_4_5_0/page/connect/connect/topics/c_The_mirth_properties_File_connect_ug.html)

- **[Open Integration Engine (OIE)](https://openintegrationengine.org/)** - Open-source healthcare integration engine for HL7 message processing and healthcare data exchange
  [Source](https://openintegrationengine.org/)

## IBM Enterprise Solutions

- **IBM MobileFirst Platform Foundation 7.1.0** - Integrated platform for extending business applications to mobile devices (until release 7.1.0 on IBM Containers)
  [Source](https://www.ibm.com/docs/en/mpf/7.1.0?topic=code-rhino-container)

- **IBM Rational Software Architect 9.7.0** - Model-driven development environment for software architects
  [Source](https://www.ibm.com/docs/en/rational-soft-arch/9.7.0?topic=launching-rhino-launch-shortcut)

- **IBM Tivoli Netcool/Impact 7.1.0** - Event management and integration platform with runnable server components
  [Source](https://www.ibm.com/docs/en/tivoli-netcoolimpact/7.1?topic=fundamentals-setting-javascript-version-use)

## Development Tools & Platforms

- **[RingoJS](https://ringojs.org/) 4.0.0** - JavaScript platform built on the JVM and optimized for server-side applications
  [Source](https://ringojs.org/)

- **[ClojureScript](https://clojurescript.org/)** - Robust functional programming language that compiles to JavaScript
  [Source](https://lambdaisland.com/guides/clojure-repls/clojurescript-repls)

- **[Adobe Experience Manager (AEM) 6.5](https://business.adobe.com/products/experience-manager/adobe-experience-manager.html)** - Comprehensive content management solution for marketing content and digital assets
  [Source](https://developer.adobe.com/experience-manager/reference-materials/6-5/javadoc/overview-summary.html)

- **[MagicDraw 2024](https://www.3ds.com/products/catia/no-magic/magicdraw)** - Visual UML, SysML, BPMN, and UPDM modeling tool with team collaboration support
  [Source](https://docs.nomagic.com/spaces/MD2024x/pages/136727575/Deprecated+JavaScript+Nashorn)

- **[IntelliJ IDEA](https://www.jetbrains.com/idea/)** - IDE for Professional Development in Java and Kotlin
  [Source](https://www.jetbrains.com/legal/third-party-software/?product=IIU)

- **[Pentaho Data Integration (Kettle)](https://www.hitachivantara.com/en-us/products/pentaho-plus-platform/data-integration-analytics.html)** - ETL (Extract, Transform, Load) tool that uses Rhino for JavaScript steps and transformations in data processing workflows
  [Source](https://forums.pentaho.com/threads/64376-Can-we-upgrade-the-Rhino-Javascript-engine-to-1-7R1/)

- **[Servoy Developer](https://docs.servoy.com/)** - Application development platform for professional developers
  [Source](https://docs.servoy.com/release-notes/release-notes/2024.06#lib-upgrades)

## Data & Analytics

- **[Apache Druid 31.0.1](https://druid.apache.org/)** - Real-time analytics database designed for fast slice-and-dice analytics on large datasets
  [Source](https://druid.apache.org/docs/latest/development/javascript/)

## Template Engines & XML Processing

- **[Apache FreeMarker](https://freemarker.apache.org/index.html)** - Template engine for generating text output (HTML, emails, configuration files) from templates and data
  [Source](https://github.com/apache/freemarker/blob/2.3-gae/build.gradle.kts)

- **[Apache Xalan](https://xalan.apache.org/index.html)** - XSLT processor for transforming XML documents using XSLT stylesheets
  [Source](https://xalan.apache.org/xalan-j/getstarted.html)

## Business Intelligence & Reporting

- **[Eclipse BIRT (Business Intelligence Reporting Tool) 4.18.0](https://eclipse-birt.github.io/birt-website/)** - Platform for creating data visualizations, dashboards and reports for web applications
  [Source](https://download.eclipse.org/birt/updates/release/latest/) *(Download birt-runtime and search for org.mozilla.rhino*)*

## Office & Productivity Software

- **[LibreOffice](https://www.libreoffice.org/)** - Free and open-source office suite, successor to OpenOffice
  [Source](https://wiki.documentfoundation.org/Documentation/DevGuide/Scripting_Framework)

## Testing & Automation Tools

- **[Sahi Pro 11.0.1](https://www.sahipro.com/)** - Test automation tool for browser, desktop, mobile & SAP applications
  [Source](https://resources.sahipro.com/docs/scripting/calling-java.html)

- **[HtmlUnit](https://www.htmlunit.org/)** - "GUI-Less browser for Java programs" that supports JavaScript via the Mozilla Rhino engine
  [Source](https://www.htmlunit.org/)

## Educational & Mathematical Tools

- **[GeoGebra](https://www.geogebra.org/)** - Interactive mathematics software for learning and teaching geometry, algebra, statistics, and calculus
  [Source](https://github.com/geogebra/geogebra/blob/main/doc/Libraries.md)

## Database

- **[Memento Database 3.4.0](https://mementodatabase.com/)** - Customizable database application for tracking and organizing data
  [Source](https://wiki.mementodatabase.com/index.php/JavaScript_field)

## Security & Smart Card Development

- **[OpenSCDP](https://www.openscdp.org/)** - Open Smart Card Development Platform for smart card application development
  [Source](https://www.openscdp.org/scsh3/)

## Mobile Applications

- **[EBTCalc](https://play.google.com/store/apps/details?id=com.ericbt.rpncalcpaid)** - Reverse Polish Notation (RPN) calculator with JavaScript programming capabilities
  [Source](https://github.com/EricTerrell/EBTCalc.Android)

## Additional Resources

For a more comprehensive list of projects and libraries using Rhino, visit:  
**[Maven Repository - Rhino Usage Statistics](https://mvnrepository.com/artifact/org.mozilla/rhino/usages)**
