/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.util.Arrays;

public class SymmetricEncIntegrityPacket
extends InputStreamPacket
implements BCPGHeaderObject {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    int version;
    int cipherAlgorithm;
    int aeadAlgorithm;
    int chunkSize;
    byte[] salt;

    SymmetricEncIntegrityPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    SymmetricEncIntegrityPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(bCPGInputStream, 18, bl);
        this.version = bCPGInputStream.read();
        if (this.version == 2) {
            this.cipherAlgorithm = bCPGInputStream.read();
            this.aeadAlgorithm = bCPGInputStream.read();
            this.chunkSize = bCPGInputStream.read();
            this.salt = new byte[32];
            if (bCPGInputStream.read(this.salt) != this.salt.length) {
                throw new EOFException("Premature end of stream.");
            }
        }
    }

    public SymmetricEncIntegrityPacket() {
        super(null, 18);
        this.version = 1;
    }

    private SymmetricEncIntegrityPacket(int n, int n2, int n3, int n4, byte[] byArray) {
        super(null, 18);
        this.version = n;
        this.cipherAlgorithm = n2;
        this.aeadAlgorithm = n3;
        this.chunkSize = n4;
        this.salt = Arrays.clone(byArray);
    }

    public static SymmetricEncIntegrityPacket createVersion1Packet() {
        return new SymmetricEncIntegrityPacket();
    }

    public static SymmetricEncIntegrityPacket createVersion2Packet(int n, int n2, int n3, byte[] byArray) {
        return new SymmetricEncIntegrityPacket(2, n, n2, n3, byArray);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.write(this.getVersion());
        if (this.version == 2) {
            bCPGOutputStream.write(this.cipherAlgorithm);
            bCPGOutputStream.write(this.aeadAlgorithm);
            bCPGOutputStream.write(this.chunkSize);
            bCPGOutputStream.write(this.salt);
        }
    }

    public int getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public byte[] getAAData() {
        return SymmetricEncIntegrityPacket.createAAData(this.getVersion(), this.getCipherAlgorithm(), this.getAeadAlgorithm(), this.getChunkSize());
    }

    public static byte[] createAAData(int n, int n2, int n3, int n4) {
        return new byte[]{-46, (byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 & 0xFF)};
    }

    public byte[] getSalt() {
        return Arrays.copyOf(this.salt, this.salt.length);
    }
}

