/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickLabels;
import org.knowm.xchart.internal.chartpart.AxisTickMarks;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.style.AxesChartStyler;

public class AxisTick<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartPart {
    private final Chart<ST, S> chart;
    private final Axis.Direction direction;
    private final AxisTickLabels<ST, S> axisTickLabels;
    private final AxisTickMarks<ST, S> axisTickMarks;
    private Rectangle2D bounds;

    AxisTick(Chart<ST, S> chart, Axis.Direction direction, Axis yAxis) {
        this.chart = chart;
        this.direction = direction;
        this.axisTickLabels = new AxisTickLabels<ST, S>(chart, direction, yAxis);
        this.axisTickMarks = new AxisTickMarks<ST, S>(chart, direction, yAxis);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.direction == Axis.Direction.Y && ((AxesChartStyler)this.chart.getStyler()).isYAxisTicksVisible()) {
            this.axisTickLabels.paint(g);
            this.axisTickMarks.paint(g);
            this.bounds = new Rectangle2D.Double(this.axisTickLabels.getBounds().getX(), this.axisTickLabels.getBounds().getY(), this.axisTickLabels.getBounds().getWidth() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTickPadding() + this.axisTickMarks.getBounds().getWidth(), this.axisTickMarks.getBounds().getHeight());
        } else if (this.direction == Axis.Direction.X && ((AxesChartStyler)this.chart.getStyler()).isXAxisTicksVisible()) {
            this.axisTickLabels.paint(g);
            this.axisTickMarks.paint(g);
            this.bounds = new Rectangle2D.Double(this.axisTickMarks.getBounds().getX(), this.axisTickMarks.getBounds().getY(), this.axisTickLabels.getBounds().getWidth(), this.axisTickMarks.getBounds().getHeight() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTickPadding() + this.axisTickLabels.getBounds().getHeight());
        } else {
            this.bounds = new Rectangle2D.Double();
        }
    }

    AxisTickLabels<ST, S> getAxisTickLabels() {
        return this.axisTickLabels;
    }
}

