// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CountTokensInput {
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub model_id: ::std::option::Option<::std::string::String>,
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub input: ::std::option::Option<crate::types::CountTokensInput>,
}
impl CountTokensInput {
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn model_id(&self) -> ::std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn input(&self) -> ::std::option::Option<&crate::types::CountTokensInput> {
        self.input.as_ref()
    }
}
impl CountTokensInput {
    /// Creates a new builder-style object to manufacture [`CountTokensInput`](crate::operation::count_tokens::CountTokensInput).
    pub fn builder() -> crate::operation::count_tokens::builders::CountTokensInputBuilder {
        crate::operation::count_tokens::builders::CountTokensInputBuilder::default()
    }
}

/// A builder for [`CountTokensInput`](crate::operation::count_tokens::CountTokensInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CountTokensInputBuilder {
    pub(crate) model_id: ::std::option::Option<::std::string::String>,
    pub(crate) input: ::std::option::Option<crate::types::CountTokensInput>,
}
impl CountTokensInputBuilder {
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    /// This field is required.
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.model_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.model_id = input;
        self
    }
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.model_id
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    /// This field is required.
    pub fn input(mut self, input: crate::types::CountTokensInput) -> Self {
        self.input = ::std::option::Option::Some(input);
        self
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn set_input(mut self, input: ::std::option::Option<crate::types::CountTokensInput>) -> Self {
        self.input = input;
        self
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn get_input(&self) -> &::std::option::Option<crate::types::CountTokensInput> {
        &self.input
    }
    /// Consumes the builder and constructs a [`CountTokensInput`](crate::operation::count_tokens::CountTokensInput).
    pub fn build(self) -> ::std::result::Result<crate::operation::count_tokens::CountTokensInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::count_tokens::CountTokensInput {
            model_id: self.model_id,
            input: self.input,
        })
    }
}
