








// This file contains the native implementations for JNI
// functions used in GprParser.java

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jni.h>

#include "com_adacore_gpr_parser_GprParser_JNI_LIB.h"
#include "gpr_parser.h"

// ==========
// Global declarations
// ==========

char jvm_running = 0;

// ==========
// Type declaration
// ==========

// Structure to store the information for event handler
typedef struct {
    JNIEnv *env;
    jobject unit_requested_callback;
    jobject unit_parsed_callback;
} event_handler_data;

// ==========
// Function delcarations
// ==========

jclass main_class_ref = NULL;
jmethodID encodeUTF32_method_id = NULL;
jmethodID decodeUTF32_method_id = NULL;
jmethodID check_exception_method_id = NULL;

void * PointerWrapper_new_value();
jobject PointerWrapper_wrap(JNIEnv *, void *);
void * PointerWrapper_unwrap(JNIEnv *, jobject);

jclass PointerWrapper_class_ref = NULL;
jmethodID PointerWrapper_constructor_id = NULL;
jmethodID PointerWrapper_getter_id = NULL;

gpr_exception LangkitException_new_value();
jthrowable LangkitException_wrap(JNIEnv *, gpr_exception);

jclass LangkitException_class_ref = NULL;
jmethodID LangkitException_constructor_id = NULL;

gpr_token_kind TokenKind_new_value();
jobject TokenKind_wrap(JNIEnv *, gpr_token_kind);
gpr_token_kind TokenKind_unwrap(JNIEnv *, jobject);

jclass TokenKind_class_ref = NULL;
jmethodID TokenKind_from_c_method_id = NULL;
jmethodID TokenKind_to_c_method_id = NULL;


    

gpr_analysis_unit_kind AnalysisUnitKind_new_value();
jobject AnalysisUnitKind_wrap(JNIEnv *, gpr_analysis_unit_kind);
gpr_analysis_unit_kind AnalysisUnitKind_unwrap(JNIEnv *, jobject);

jclass AnalysisUnitKind_class_ref = NULL;
jmethodID AnalysisUnitKind_from_c_method_id = NULL;
jmethodID AnalysisUnitKind_to_c_method_id = NULL;


    

gpr_lookup_kind LookupKind_new_value();
jobject LookupKind_wrap(JNIEnv *, gpr_lookup_kind);
gpr_lookup_kind LookupKind_unwrap(JNIEnv *, jobject);

jclass LookupKind_class_ref = NULL;
jmethodID LookupKind_from_c_method_id = NULL;
jmethodID LookupKind_to_c_method_id = NULL;


    

gpr_designated_env_kind DesignatedEnvKind_new_value();
jobject DesignatedEnvKind_wrap(JNIEnv *, gpr_designated_env_kind);
gpr_designated_env_kind DesignatedEnvKind_unwrap(JNIEnv *, jobject);

jclass DesignatedEnvKind_class_ref = NULL;
jmethodID DesignatedEnvKind_from_c_method_id = NULL;
jmethodID DesignatedEnvKind_to_c_method_id = NULL;


    

gpr_grammar_rule GrammarRule_new_value();
jobject GrammarRule_wrap(JNIEnv *, gpr_grammar_rule);
gpr_grammar_rule GrammarRule_unwrap(JNIEnv *, jobject);

jclass GrammarRule_class_ref = NULL;
jmethodID GrammarRule_from_c_method_id = NULL;
jmethodID GrammarRule_to_c_method_id = NULL;


uint32_t Char_new_value();
jobject Char_wrap(JNIEnv *, uint32_t);
uint32_t Char_unwrap(JNIEnv *, jobject);

jclass Char_class_ref = NULL;
jmethodID Char_constructor_id = NULL;
jfieldID Char_value_field_id = NULL;

gpr_big_integer BigInteger_new_value();
jobject BigInteger_wrap(JNIEnv *, gpr_big_integer);
gpr_big_integer BigInteger_unwrap(JNIEnv *, jobject);
void BigInteger_release(gpr_big_integer);

jclass BigInteger_class_ref = NULL;
jmethodID BigInteger_constructor_id = NULL;
jmethodID BigInteger_to_string_method_id = NULL;

gpr_symbol_type Symbol_new_value();
jobject Symbol_wrap(JNIEnv *, gpr_symbol_type);
gpr_symbol_type Symbol_unwrap(JNIEnv *, jobject, gpr_analysis_context);
jthrowable new_symbol_exception(JNIEnv *, jstring);

jclass Symbol_class_ref = NULL;
jmethodID Symbol_constructor_id = NULL;
jfieldID Symbol_text_field_id = NULL;
jclass SymbolException_class_ref = NULL;
jmethodID SymbolException_constructor_id = NULL;

gpr_string_type String_new_value();
jobject String_wrap(JNIEnv *, gpr_string_type);
gpr_string_type String_unwrap(JNIEnv *, jobject);
void String_release(gpr_string_type);

gpr_text Text_new_value();
jobject Text_wrap(JNIEnv *, gpr_text);
gpr_text Text_unwrap(JNIEnv *, jobject);
jstring get_text_content(JNIEnv *, jobject);
jobject text_from_content(JNIEnv *, jstring);

jclass Text_class_ref = NULL;
jmethodID Text_constructor_id = NULL;
jmethodID Text_extended_constructor_id = NULL;
jmethodID Text_create_method_id = NULL;
jmethodID Text_get_content_method_id = NULL;
jfieldID Text_chars_field_id = NULL;
jfieldID Text_length_field_id = NULL;
jfieldID Text_is_allocated_field_id = NULL;
jfieldID Text_is_owner_field_id = NULL;

gpr_source_location SourceLocation_new_value();
jobject SourceLocation_wrap(JNIEnv *, gpr_source_location);
gpr_source_location SourceLocation_unwrap(JNIEnv *, jobject);

jclass SourceLocation_class_ref = NULL;
jmethodID SourceLocation_constructor_id = NULL;
jfieldID SourceLocation_line_field_id = NULL;
jfieldID SourceLocation_column_field_id = NULL;

gpr_source_location_range SourceLocationRange_new_value();
jobject SourceLocationRange_wrap(JNIEnv *, gpr_source_location_range);
gpr_source_location_range SourceLocationRange_unwrap(JNIEnv *, jobject);

jclass SourceLocationRange_class_ref = NULL;
jmethodID SourceLocationRange_constructor_id = NULL;
jfieldID SourceLocationRange_start_field_id = NULL;
jfieldID SourceLocationRange_end_field_id = NULL;

gpr_diagnostic Diagnostic_new_value();
jobject Diagnostic_wrap(JNIEnv *, gpr_diagnostic);
gpr_diagnostic Diagnostic_unwrap(JNIEnv *, jobject);

jclass Diagnostic_class_ref = NULL;
jmethodID Diagnostic_constructor_id = NULL;
jfieldID Diagnostic_sloc_range_field_id = NULL;
jfieldID Diagnostic_text_field_id = NULL;

gpr_file_reader FileReader_new_value();
jobject FileReader_wrap(JNIEnv *, gpr_file_reader);
gpr_file_reader FileReader_unwrap(JNIEnv *, jobject);

jclass FileReader_class_ref = NULL;
jmethodID FileReader_constructor_id = NULL;
jfieldID FileReader_reference_field_id = NULL;

gpr_unit_provider UnitProvider_new_value();
jobject UnitProvider_wrap(JNIEnv *, gpr_unit_provider);
gpr_unit_provider UnitProvider_unwrap(JNIEnv *, jobject);

jclass UnitProvider_class_ref = NULL;
jmethodID UnitProvider_constructor_id = NULL;
jfieldID UnitProvider_reference_field_id = NULL;

gpr_event_handler EventHandler_new_value();
jobject EventHandler_wrap(JNIEnv *, gpr_event_handler);
gpr_event_handler EventHandler_unwrap(JNIEnv *, jobject);

jclass EventHandler_class_ref = NULL;
jmethodID EventHandler_from_reference_id = NULL;
jfieldID EventHandler_reference_field_id = NULL;
jclass UnitRequestedCallback_class_id = NULL;
jmethodID UnitRequestedCallback_invoke_id = NULL;
jclass UnitParsedCallback_class_id = NULL;
jmethodID UnitParsedCallback_invoke_id = NULL;

gpr_token Token_new_value();
jobject Token_wrap(JNIEnv *, gpr_token, jobject);
gpr_token Token_unwrap(JNIEnv *, jobject);
jobject Token_get_unit(JNIEnv *, jobject);
jobject NoToken_wrap(JNIEnv *, jobject);

jclass Token_class_ref = NULL;
jclass NoToken_class_ref = NULL;
jmethodID Token_constructor_id = NULL;
jmethodID Token_none_getter_method_id = NULL;
jfieldID Token_context_field_id = NULL;
jfieldID Token_tdh_field_id = NULL;
jfieldID Token_token_index_field_id = NULL;
jfieldID Token_trivia_index_field_id = NULL;
jfieldID Token_token_kind_field_id = NULL;
jfieldID Token_text_field_id = NULL;
jfieldID Token_sloc_range_field_id = NULL;
jfieldID Token_unit_field_id = NULL;

gpr_analysis_context AnalysisContext_new_value();
jobject AnalysisContext_wrap(JNIEnv *, gpr_analysis_context);
gpr_analysis_context AnalysisContext_unwrap(JNIEnv *, jobject);

jclass AnalysisContext_class_ref = NULL;
jmethodID AnalysisContext_from_reference_id = NULL;
jfieldID AnalysisContext_reference_field_id = NULL;

gpr_analysis_unit AnalysisUnit_new_value();
jobject AnalysisUnit_wrap(JNIEnv *, gpr_analysis_unit);
gpr_analysis_unit AnalysisUnit_unwrap(JNIEnv *, jobject);

jclass AnalysisUnit_class_ref = NULL;
jmethodID AnalysisUnit_constructor_id = NULL;
jfieldID AnalysisUnit_reference_field_id = NULL;


    

gpr_internal_metadata Metadata_new_value();
jobject Metadata_wrap(JNIEnv *, gpr_internal_metadata);
gpr_internal_metadata Metadata_unwrap(JNIEnv *, jobject);


jclass Metadata_class_ref = NULL;
jfieldID Metadata_none_field_id = NULL;



    

gpr_internal_entity_info EntityInfo_new_value();
jobject EntityInfo_wrap(JNIEnv *, gpr_internal_entity_info);
gpr_internal_entity_info EntityInfo_unwrap(JNIEnv *, jobject);


jclass EntityInfo_class_ref = NULL;
jmethodID EntityInfo_constructor_id = NULL;
jfieldID EntityInfo_md_field_id = NULL;
jfieldID EntityInfo_rebindings_field_id = NULL;
jfieldID EntityInfo_from_rebound_field_id = NULL;



    

gpr_base_entity Entity_new_value();
jobject Entity_wrap(JNIEnv *, gpr_base_entity);
gpr_base_entity Entity_unwrap(JNIEnv *, jobject);


jclass Entity_class_ref = NULL;
jmethodID Entity_constructor_id = NULL;
jfieldID Entity_node_field_id = NULL;
jfieldID Entity_info_field_id = NULL;




    

gpr_gpr_node_array GprNodeArray_new_value();
jobject GprNodeArray_wrap(JNIEnv *, gpr_gpr_node_array);
gpr_gpr_node_array GprNodeArray_unwrap(
    JNIEnv *,
    jobject
    );
void GprNodeArray_release(gpr_gpr_node_array);

jclass GprNodeArray_class_ref = NULL;
jmethodID GprNodeArray_create_method_id = NULL;
jmethodID GprNodeArray_content_method_id = NULL;



// ==========
// Lifecycle functions
// ==========

JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1initialize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 1;

    main_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser")
    );

    encodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "encodeUTF32",
        "(Ljava/lang/String;)[B"
    );

    decodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "decodeUTF32",
        "([B)Ljava/lang/String;"
    );

    check_exception_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "checkException",
        "()V"
    );

    PointerWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$PointerWrapper")
    );

    PointerWrapper_constructor_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "<init>",
        "(J)V"
    );

    PointerWrapper_getter_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "jni",
        "()J"
    );

    LangkitException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$LangkitException")
    );

    LangkitException_constructor_id = (*env)->GetMethodID(
        env,
        LangkitException_class_ref,
        "<init>",
        "(ILjava/lang/String;)V"
    );

    Symbol_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Symbol")
    );

    Symbol_constructor_id = (*env)->GetMethodID(
        env,
        Symbol_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Symbol_text_field_id = (*env)->GetFieldID(
        env,
        Symbol_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    SymbolException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$SymbolException")
    );

    SymbolException_constructor_id = (*env)->GetMethodID(
        env,
        SymbolException_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Text_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Text")
    );

    Text_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;JZ[B)V"
    );

    Text_extended_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;JZZ[B)V"
    );

    Text_create_method_id = (*env)->GetStaticMethodID(
        env,
        Text_class_ref,
        "create",
        "(Ljava/lang/String;)Lcom/adacore/gpr_parser/GprParser$Text;"
    );

    Text_get_content_method_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "getContent",
        "()Ljava/lang/String;"
    );

    Text_chars_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "charPointer",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    Text_length_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "length",
        "J"
    );

    Text_is_allocated_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isAllocated",
        "Z"
    );

    Text_is_owner_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isOwner",
        "Z"
    );

    SourceLocation_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$SourceLocation")
    );

    SourceLocation_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocation_class_ref,
        "<init>",
        "(IS)V"
    );

    SourceLocation_line_field_id = (*env)->GetFieldID(
        env,
        SourceLocation_class_ref,
        "line",
        "I"
    );

    SourceLocation_column_field_id = (*env)->GetFieldID(
        env,
        SourceLocation_class_ref,
        "column",
        "S"
    );

    TokenKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$TokenKind")
    );

    TokenKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        TokenKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/gpr_parser/GprParser$TokenKind;"
    );

    TokenKind_to_c_method_id = (*env)->GetMethodID(
        env,
        TokenKind_class_ref,
        "toC",
        "()I"
    );

    Char_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Char")
    );

    Char_constructor_id = (*env)->GetMethodID(
        env,
        Char_class_ref,
        "<init>",
        "(I)V"
    );

    Char_value_field_id = (*env)->GetFieldID(
        env,
        Char_class_ref,
        "value",
        "I"
    );

    BigInteger_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "java/math/BigInteger")
    );

    BigInteger_constructor_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    BigInteger_to_string_method_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "toString",
        "()Ljava/lang/String;"
    );

    SourceLocationRange_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$SourceLocationRange")
    );

    SourceLocationRange_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocationRange_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$SourceLocation;Lcom/adacore/gpr_parser/GprParser$SourceLocation;)V"
    );

    SourceLocationRange_start_field_id = (*env)->GetFieldID(
        env,
        SourceLocationRange_class_ref,
        "start",
        "Lcom/adacore/gpr_parser/GprParser$SourceLocation;"
    );

    SourceLocationRange_end_field_id = (*env)->GetFieldID(
        env,
        SourceLocationRange_class_ref,
        "end",
        "Lcom/adacore/gpr_parser/GprParser$SourceLocation;"
    );

    Diagnostic_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Diagnostic")
    );

    Diagnostic_constructor_id = (*env)->GetMethodID(
        env,
        Diagnostic_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$SourceLocationRange;Lcom/adacore/gpr_parser/GprParser$Text;)V"
    );

    Diagnostic_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/gpr_parser/GprParser$SourceLocationRange;"
    );

    Diagnostic_text_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "message",
        "Lcom/adacore/gpr_parser/GprParser$Text;"
    );

    FileReader_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$FileReader")
    );

    FileReader_constructor_id = (*env)->GetMethodID(
        env,
        FileReader_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;)V"
    );

    FileReader_reference_field_id = (*env)->GetFieldID(
        env,
        FileReader_class_ref,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    UnitProvider_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$UnitProvider")
    );

    UnitProvider_constructor_id = (*env)->GetMethodID(
        env,
        UnitProvider_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;)V"
    );

    UnitProvider_reference_field_id = (*env)->GetFieldID(
        env,
        UnitProvider_class_ref,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    EventHandler_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$EventHandler")
    );

    EventHandler_from_reference_id = (*env)->GetStaticMethodID(
        env,
        EventHandler_class_ref,
        "fromReference",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;)Lcom/adacore/gpr_parser/GprParser$EventHandler;"
    );

    EventHandler_reference_field_id = (*env)->GetFieldID(
        env,
        EventHandler_class_ref,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    UnitRequestedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/gpr_parser/GprParser$EventHandler$UnitRequestedCallback"
        )
    );

    UnitRequestedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitRequestedCallback_class_id,
        "invoke",
        "(Lcom/adacore/gpr_parser/GprParser$AnalysisContext;Ljava/lang/String;"
        "Lcom/adacore/gpr_parser/GprParser$AnalysisUnit;ZZ)V"
    );

    UnitParsedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/gpr_parser/GprParser$EventHandler$UnitParsedCallback"
        )
    );

    UnitParsedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitParsedCallback_class_id,
        "invoke",
        "(Lcom/adacore/gpr_parser/GprParser$AnalysisContext;Lcom/adacore/gpr_parser/GprParser$AnalysisUnit;Z)V"
    );

    Token_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Token")
    );

    NoToken_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$Token$NoToken")
    );

    Token_constructor_id = (*env)->GetMethodID(
        env,
        Token_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;Lcom/adacore/gpr_parser/GprParser$AnalysisUnit;Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
        "IILcom/adacore/gpr_parser/GprParser$TokenKind;Ljava/lang/String;"
        "Lcom/adacore/gpr_parser/GprParser$SourceLocationRange;)V"
    );

    Token_none_getter_method_id = (*env)->GetStaticMethodID(
        env,
        Token_class_ref,
        "NONE",
        "(Lcom/adacore/gpr_parser/GprParser$AnalysisUnit;)Lcom/adacore/gpr_parser/GprParser$Token;"
    );

    Token_context_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "contextRef",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    Token_tdh_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenDataHandler",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    Token_token_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenIndex",
        "I"
    );

    Token_trivia_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "triviaIndex",
        "I"
    );

    Token_token_kind_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "kind",
        "Lcom/adacore/gpr_parser/GprParser$TokenKind;"
    );

    Token_text_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    Token_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/gpr_parser/GprParser$SourceLocationRange;"
    );

    Token_unit_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "unit",
        "Lcom/adacore/gpr_parser/GprParser$AnalysisUnit;"
    );

    AnalysisContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$AnalysisContext")
    );

    AnalysisContext_from_reference_id = (*env)->GetStaticMethodID(
        env,
        AnalysisContext_class_ref,
        "fromReference",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;)Lcom/adacore/gpr_parser/GprParser$AnalysisContext;"
    );

    AnalysisContext_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisContext_class_ref,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );

    AnalysisUnit_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$AnalysisUnit")
    );

    AnalysisUnit_constructor_id = (*env)->GetMethodID(
        env,
        AnalysisUnit_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;)V"
    );

    AnalysisUnit_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisUnit_class_ref,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );


    

    Metadata_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/gpr_parser/GprParser$Metadata"
        )
    );

    Metadata_none_field_id = (*env)->GetStaticFieldID(
        env,
        Metadata_class_ref,
        "NONE",
        "Lcom/adacore/gpr_parser/GprParser$Metadata;"
    );



    

    EntityInfo_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/gpr_parser/GprParser$EntityInfo"
        )
    );

    EntityInfo_constructor_id = (*env)->GetMethodID(
        env,
        EntityInfo_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$Metadata;Lcom/adacore/gpr_parser/GprParser$PointerWrapper;Z)V"
    );

    EntityInfo_md_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "md",
        "Lcom/adacore/gpr_parser/GprParser$Metadata;"
    );
    EntityInfo_rebindings_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "rebindings",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );
    EntityInfo_from_rebound_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "fromRebound",
        "Z"
    );


    

    Entity_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/gpr_parser/GprParser$Entity"
        )
    );

    Entity_constructor_id = (*env)->GetMethodID(
        env,
        Entity_class_ref,
        "<init>",
        "(Lcom/adacore/gpr_parser/GprParser$PointerWrapper;Lcom/adacore/gpr_parser/GprParser$EntityInfo;)V"
    );

    Entity_node_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "node",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );
    Entity_info_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "info",
        "Lcom/adacore/gpr_parser/GprParser$EntityInfo;"
    );



    

    AnalysisUnitKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$AnalysisUnitKind")
    );

    AnalysisUnitKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/gpr_parser/GprParser$AnalysisUnitKind;"
    );

    AnalysisUnitKind_to_c_method_id = (*env)->GetMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "toC",
        "()I"
    );


    

    LookupKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$LookupKind")
    );

    LookupKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        LookupKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/gpr_parser/GprParser$LookupKind;"
    );

    LookupKind_to_c_method_id = (*env)->GetMethodID(
        env,
        LookupKind_class_ref,
        "toC",
        "()I"
    );


    

    DesignatedEnvKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$DesignatedEnvKind")
    );

    DesignatedEnvKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/gpr_parser/GprParser$DesignatedEnvKind;"
    );

    DesignatedEnvKind_to_c_method_id = (*env)->GetMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "toC",
        "()I"
    );


    

    GrammarRule_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/gpr_parser/GprParser$GrammarRule")
    );

    GrammarRule_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        GrammarRule_class_ref,
        "fromC",
        "(I)Lcom/adacore/gpr_parser/GprParser$GrammarRule;"
    );

    GrammarRule_to_c_method_id = (*env)->GetMethodID(
        env,
        GrammarRule_class_ref,
        "toC",
        "()I"
    );



    

    GprNodeArray_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/gpr_parser/GprParser$GprNodeArray;")
    );

    GprNodeArray_create_method_id = (*env)->GetStaticMethodID(
        env,
        GprNodeArray_class_ref,
        "jniCreate",
        "([Lcom/adacore/gpr_parser/GprParser$Entity;)Lcom/adacore/gpr_parser/GprParser$GprNodeArray;"
    );

    GprNodeArray_content_method_id = (*env)->GetMethodID(
        env,
        GprNodeArray_class_ref,
        "jniContent",
        "()[Lcom/adacore/gpr_parser/GprParser$Entity;"
    );


}

// Function to finalize the JNI library
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1finalize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 0;
}

// ==========
// Util functions
// ==========

// Get the native reference in a Java object
void * get_reference(
    JNIEnv *env,
    jobject object
) {
    // Get the object class
    jclass clazz = (*env)->GetObjectClass(env, object);

    // Get the reference field
    jfieldID reference_field = (*env)->GetFieldID(
        env,
        clazz,
        "reference",
        "Lcom/adacore/gpr_parser/GprParser$PointerWrapper;"
    );
    jobject reference = (*env)->GetObjectField(env, object, reference_field);

    // Unwrap the reference field to get pointer
    return PointerWrapper_unwrap(env, reference);
}

// Translate a Java string to a C char pointer with the UTF-8 encoding
const char * to_c_string(
    JNIEnv *env,
    jstring j_string
) {
    return (*env)->GetStringUTFChars(env, j_string, NULL);
}

// Release the given C string assocaited with the given Java string
void release_c_string(
    JNIEnv *env,
    jstring j_string,
    const char *c_string
) {
    (*env)->ReleaseStringUTFChars(env, j_string, c_string);
}

// Create a Java string from a C char pointer
jstring to_j_string(
    JNIEnv *env,
    const char *c_string
) {
    return (*env)->NewStringUTF(env, c_string);
}

// Decode an UTF 32 buffer in a Java string
jstring decode_utf_32(
    JNIEnv *env,
    size_t length,
    uint32_t *to_decode
) {
    // Create a byte array from the buffer to decode
    const jbyte *byte_buffer = (jbyte *) to_decode;
    jsize byte_length = (jsize) (length * 4);
    jbyteArray byte_array = (*env)->NewByteArray(
        env,
        byte_length
    );
    (*env)->SetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        byte_buffer
    );

    // Call the Java method and return the result
    return (jstring) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        decodeUTF32_method_id,
        byte_array
    );
}

// Encode a Java string in a native buffer
void encode_utf_32(
    JNIEnv *env,
    jstring string,
    size_t *length_ref,
    uint32_t **buffer_ref
) {
    // Call the Java method to get the byte array
    jbyteArray byte_array = (jbyteArray) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        encodeUTF32_method_id,
        string
    );
    size_t byte_length = (size_t) (*env)->GetArrayLength(
        env,
        byte_array
    );

    // Allocate the memory for the native buffer
    *buffer_ref = (uint32_t *) malloc(byte_length);

    // Write the native buffer and the length
    *length_ref = byte_length / 4;
    (*env)->GetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        (jbyte *) *buffer_ref
    );
}

void check_exception(JNIEnv *env) {
    // Call the Java checking exception function
    (*env)->CallStaticVoidMethod(
        env,
        main_class_ref,
        check_exception_method_id
    );
}

// ==========
// Language specific extensions
// ==========




// ==========
// Custom pointer functions
// ==========

// Create a new value for a custom pointer
void * PointerWrapper_new_value() {
    return NULL;
}

// Wrap a C pointer in a Java custom pointer
jobject PointerWrapper_wrap(
    JNIEnv *env,
    void *pointer
) {
    // Create the new custom pointer
    return (*env)->NewObject(
        env,
        PointerWrapper_class_ref,
        PointerWrapper_constructor_id,
        (jlong) pointer
    );
}

// Get the C pointer from the Java custom pointer
void * PointerWrapper_unwrap(
    JNIEnv *env,
    jobject custom_pointer
) {
    // Return the C pointer
    return (void *) (*env)->CallLongMethod(
        env,
        custom_pointer,
        PointerWrapper_getter_id
    );
}

// ==========
// Exception functions
// ==========

// Create a new value for an exception
gpr_exception LangkitException_new_value() {
    gpr_exception res = {
        0,
        NULL
    };
    return res;
}

// Wrap a native langkit exception in a Java exception
jthrowable LangkitException_wrap(
    JNIEnv *env,
    gpr_exception exception
) {
    // Return the new exception instance
    return (jthrowable) (*env)->NewObject(
        env,
        LangkitException_class_ref,
        LangkitException_constructor_id,
        (jint) exception.kind,
        to_j_string(env, exception.information)
    );
}

JNIEXPORT jthrowable Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1get_1last_1exception(
    JNIEnv *env,
    jclass jni_lib
) {
    // Call the native function
    const gpr_exception *last_exception = gpr_get_last_exception();

    // If last exception is null, return a null value, else wrap it
    if(last_exception == NULL) {
        return NULL;
    }
    return LangkitException_wrap(
        env,
        *last_exception
    );
}

// ==========
// Token kind functions
// ==========

// Create a new value for a token kind
gpr_token_kind TokenKind_new_value() {
    return 0;
}

// Wrap a native token kind in a Java class
jobject TokenKind_wrap(
    JNIEnv *env,
    gpr_token_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        TokenKind_class_ref,
        TokenKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java token kind as a native one
gpr_token_kind TokenKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (gpr_token_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        TokenKind_to_c_method_id
    );
}

// ==========
// Enumeration generated functions
// ==========


    

// Get a new value for the enumeration
gpr_analysis_unit_kind AnalysisUnitKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject AnalysisUnitKind_wrap(
    JNIEnv *env,
    gpr_analysis_unit_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitKind_class_ref,
        AnalysisUnitKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
gpr_analysis_unit_kind AnalysisUnitKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (gpr_analysis_unit_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        AnalysisUnitKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
gpr_lookup_kind LookupKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject LookupKind_wrap(
    JNIEnv *env,
    gpr_lookup_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        LookupKind_class_ref,
        LookupKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
gpr_lookup_kind LookupKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (gpr_lookup_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        LookupKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
gpr_designated_env_kind DesignatedEnvKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject DesignatedEnvKind_wrap(
    JNIEnv *env,
    gpr_designated_env_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        DesignatedEnvKind_class_ref,
        DesignatedEnvKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
gpr_designated_env_kind DesignatedEnvKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (gpr_designated_env_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        DesignatedEnvKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
gpr_grammar_rule GrammarRule_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject GrammarRule_wrap(
    JNIEnv *env,
    gpr_grammar_rule enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        GrammarRule_class_ref,
        GrammarRule_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
gpr_grammar_rule GrammarRule_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (gpr_grammar_rule) (*env)->CallIntMethod(
        env,
        enum_value,
        GrammarRule_to_c_method_id
    );
}


// ==========
// Character functions
// ==========

// Create a new value for a character
uint32_t Char_new_value() {
    return 0;
}

// Wrap a native character in the Java wrapping class
jobject Char_wrap(
    JNIEnv *env,
    uint32_t char_native
) {
    // Return the new object
    return (*env)->NewObject(
        env,
        Char_class_ref,
        Char_constructor_id,
        char_native
    );
}

// Get a native character from a Java wrapping instance
uint32_t Char_unwrap(
    JNIEnv *env,
    jobject character
) {
    // Return the result field
    return (uint32_t) (*env)->GetIntField(
        env,
        character,
        Char_value_field_id
    );
}

// ==========
// Big integer functions
// ==========

// Create a new value for a big integer
gpr_big_integer BigInteger_new_value() {
    return NULL;
}

// Wrap a native big integer in the Java class
jobject BigInteger_wrap(
    JNIEnv *env,
    gpr_big_integer big_int_native
) {
    // Get the representation of the big integer
    gpr_text representation_native = Text_new_value();
    gpr_big_integer_text(
        big_int_native,
        &representation_native
    );
    jobject representation_text = Text_wrap(env, representation_native);
    jstring representation = get_text_content(env, representation_text);

    // Destroy the representation text
    gpr_destroy_text(
        &representation_native
    );

    // Return the new big integer
    return (*env)->NewObject(
        env,
        BigInteger_class_ref,
        BigInteger_constructor_id,
        representation
    );
}

// Get the native big integer from the Java wrapping instance
gpr_big_integer BigInteger_unwrap(
    JNIEnv *env,
    jobject big_integer
) {
    // Get the representation of the big integer
    jstring representation = (*env)->CallObjectMethod(
        env,
        big_integer,
        BigInteger_to_string_method_id
    );

    // Create a text from the representations
    jobject representation_text = (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        representation
    );
    gpr_text representation_native = Text_unwrap(env, representation_text);

    // Create a bit integer from the text
    gpr_big_integer res = gpr_create_big_integer(
        &representation_native
    );

    // Destroy the text
    free(representation_native.chars);

    // Return the result
    return res;
}

// Release the given native big integer
void BigInteger_release(
    gpr_big_integer big_int_native
) {
    gpr_big_integer_decref(big_int_native);
}

// ==========
// Symbol functions
// ==========

// Create a new value for a symbol
gpr_symbol_type Symbol_new_value() {
    gpr_symbol_type res = {
        NULL,
        NULL
    };
    return res;
}

// Wrap a native symbol in the Java class
jobject Symbol_wrap(
    JNIEnv *env,
    gpr_symbol_type symbol_native
) {
    // Get the text of the symbol
    gpr_text text_native = Text_new_value();
    gpr_symbol_text(
        &symbol_native,
        &text_native
    );
    jobject text = Text_wrap(env, text_native);
    jstring symbol_text = get_text_content(env, text);

    // Destroy the text
    gpr_destroy_text(
        &text_native
    );

    // Return the new symbol
    return (*env)->NewObject(
        env,
        Symbol_class_ref,
        Symbol_constructor_id,
        symbol_text
    );
}

// Get the native symbol from the Java wrapping instance
gpr_symbol_type Symbol_unwrap(
    JNIEnv *env,
    jobject symbol,
    gpr_analysis_context context_native
) {
    // Create the result structure
    gpr_symbol_type res = Symbol_new_value();

    // Get the fields value
    jstring str = (jstring) (*env)->GetObjectField(
        env,
        symbol,
        Symbol_text_field_id
    );

    // Create a text from the symbol content
    jobject text = text_from_content(env, str);
    gpr_text text_native = Text_unwrap(env, text);

    // Call the symbol creation
    int ret_code = gpr_context_symbol(
        context_native,
        &text_native,
        &res
    );

    if(ret_code == 0) {
        // Throw a new exception
        jthrowable exception = new_symbol_exception(env, str);
        (*env)->Throw(env, exception);
    }

    // Return the result
    return res;
}

// Create a new symbol exception
jthrowable new_symbol_exception(
    JNIEnv *env,
    jstring symbol_str
) {
    // Return the exception
    return (*env)->NewObject(
        env,
        SymbolException_class_ref,
        SymbolException_constructor_id,
        symbol_str
    );
}

// ==========
// String functions
// ==========

// Create a new value for a langkit string
gpr_string_type String_new_value() {
    return NULL;
}

// Wrap a native langkit string in the Java class
jstring String_wrap(
    JNIEnv *env,
    gpr_string_type string_native
) {
    return decode_utf_32(
        env,
        (size_t) string_native->length,
        string_native->content
    );
}

// Get the native langkit string from a Java wrapping instance
gpr_string_type String_unwrap(
    JNIEnv *env,
    jstring string
) {
    // Encode the Java string
    size_t length;
    uint32_t *buffer;
    encode_utf_32(
        env,
        string,
        &length,
        &buffer
    );

    // Create a new native string
    gpr_string_type res = gpr_create_string(
        buffer,
        (int) length
    );

    // Free the buffer
    free(buffer);

    // Return the result
    return res;
}

// Release the given native string
void String_release(
    gpr_string_type string_native
) {
    gpr_string_dec_ref(string_native);
}

// ==========
// Text functions
// ==========

// Create a new value for a langkit text
gpr_text Text_new_value() {
    gpr_text res = {
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a langkit text in the Java wrapping class
jobject Text_wrap(
    JNIEnv *env,
    gpr_text text_native
) {
    // Get the int array from the structure and translate it into Java array
    jbyteArray content = (*env)->NewByteArray(
        env,
        (jsize) text_native.length * 4
    );
    (*env)->SetByteArrayRegion(
        env,
        content,
        0,
        (jsize) text_native.length * 4,
        (jbyte *) text_native.chars
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_constructor_id,
        PointerWrapper_wrap(env, text_native.chars),
        (jlong) text_native.length,
        (jboolean) text_native.is_allocated,
        content
    );
}

// Unwrap a langit text from a Java wrapping instance
gpr_text Text_unwrap(
    JNIEnv *env,
    jobject text
) {
    // Create the result structure
    gpr_text res = Text_new_value();

    // Get the values
    jobject chars = (*env)->GetObjectField(
        env,
        text,
        Text_chars_field_id
    );
    jlong length = (*env)->GetLongField(
        env,
        text,
        Text_length_field_id
    );
    jboolean is_allocated = (*env)->GetBooleanField(
        env,
        text,
        Text_is_allocated_field_id
    );

    // Fill the structure with the object fields
    res.chars = (uint32_t *) PointerWrapper_unwrap(env, chars);
    res.length = (size_t) length;
    res.is_allocated = (int) is_allocated;

    // Return the result
    return res;
}

// Get the string from a text object
jstring get_text_content(
    JNIEnv *env,
    jobject text
) {
    return (jstring) (*env)->CallObjectMethod(
        env,
        text,
        Text_get_content_method_id
    );
}

// Create a text object from its string content
jobject text_from_content(
    JNIEnv *env,
    jstring content
) {
    // Call the creating method
    return (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        content
    );
}

// Create a text Java object from its content
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1create_1text (
    JNIEnv *env,
    jclass jni_lib,
    jbyteArray content_utf32
) {
    // Get the content in a memory buffer
    size_t length = ((size_t) (*env)->GetArrayLength(env, content_utf32)) / 4;
    uint32_t *content_native = (uint32_t *) malloc(length * sizeof(uint32_t));
    (*env)->GetByteArrayRegion(
        env,
        content_utf32,
        0,
        length * 4,
        (jbyte *) content_native
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_extended_constructor_id,
        PointerWrapper_wrap(env, content_native),
        (jlong) length,
        (jboolean) 0,
        (jboolean) 1,
        content_utf32
    );
}

// Destroy a text object
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1destroy_1text (
    JNIEnv *env,
    jclass jni_lib,
    jobject text
) {
    // Get if the text is the owner of its buffer
    jboolean is_owner = (*env)->GetBooleanField(
        env,
        text,
        Text_is_owner_field_id
    );

    // Unwrap the text
    gpr_text text_native = Text_unwrap(env, text);

    // If the object is the buffer owner just free the chars
    if(is_owner) {
        free((void *) text_native.chars);
    } else {
        gpr_destroy_text(&text_native);
    }
}

// ==========
// Source location functions
// ==========

// Create a new value for a source location
gpr_source_location SourceLocation_new_value() {
    gpr_source_location res = {
        0,
        0
    };
    return res;
}

// Wrap a native source location in the Java wrapping class
jobject SourceLocation_wrap(
    JNIEnv *env,
    gpr_source_location sloc_native
) {
    // Return the new source location
    return (*env)->NewObject(
        env,
        SourceLocation_class_ref,
        SourceLocation_constructor_id,
        (jint) sloc_native.line,
        (jshort) sloc_native.column
    );
}

// Get a native source location from a Java wrapping instance
gpr_source_location SourceLocation_unwrap(
    JNIEnv *env,
    jobject sloc
) {
    // Create the result structure
    gpr_source_location res = SourceLocation_new_value();

    // Get the fields value
    jint line = (*env)->GetIntField(
        env,
        sloc,
        SourceLocation_line_field_id
    );
    jshort column = (*env)->GetShortField(
        env,
        sloc,
        SourceLocation_column_field_id
    );

    // Fill the result structure
    res.line = (uint32_t) line;
    res.column = (uint16_t) column;

    // Return the result
    return res;
}

// ==========
// Source location range functions
// ==========

// Create a new value for a source location range
gpr_source_location_range SourceLocationRange_new_value() {
    gpr_source_location_range res = {
        SourceLocation_new_value(),
        SourceLocation_new_value()
    };
    return res;
}

// Wrap a native source location range in the Java wrapping class
jobject SourceLocationRange_wrap(
    JNIEnv *env,
    gpr_source_location_range slocr_native
) {
    // Return the new source location range
    return (*env)->NewObject(
        env,
        SourceLocationRange_class_ref,
        SourceLocationRange_constructor_id,
        SourceLocation_wrap(env, slocr_native.start),
        SourceLocation_wrap(env, slocr_native.end)
    );
}

// Get a native source location range from a Java wrapping instance
gpr_source_location_range SourceLocationRange_unwrap(
    JNIEnv *env,
    jobject slocr
) {
    // Create the result structure
    gpr_source_location_range res = SourceLocationRange_new_value();

    // Get the fields value
    jobject start = (*env)->GetObjectField(
        env,
        slocr,
        SourceLocationRange_start_field_id
    );
    jobject end = (*env)->GetObjectField(
        env,
        slocr,
        SourceLocationRange_end_field_id
    );

    // Fill the result structure
    res.start = SourceLocation_unwrap(env, start);
    res.end = SourceLocation_unwrap(env, end);

    // Return the result
    return res;
}

// ==========
// Diagnostic functions
// ==========

// Create a new value for a diagnostic
gpr_diagnostic Diagnostic_new_value() {
    gpr_diagnostic res = {
        SourceLocationRange_new_value(),
        Text_new_value()
    };
    return res;
}

// Wrap a native diagnostic in the Java wrapping class
jobject Diagnostic_wrap(
    JNIEnv *env,
    gpr_diagnostic diag_native
) {
    // Return the new diagnostic
    return (*env)->NewObject(
        env,
        Diagnostic_class_ref,
        Diagnostic_constructor_id,
        SourceLocationRange_wrap(env, diag_native.sloc_range),
        Text_wrap(env, diag_native.message)
    );
}

// Get a native diagnostic from a Java wrapping instance
gpr_diagnostic Diagnostic_unwrap(
    JNIEnv *env,
    jobject diagnostic
) {
    // Create the result structure
    gpr_diagnostic res = Diagnostic_new_value();

    // Get the fields value
    jobject slocr = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_sloc_range_field_id
    );
    jobject text = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_text_field_id
    );

    // Fill the result structure
    res.sloc_range = SourceLocationRange_unwrap(env, slocr);
    res.message = Text_unwrap(env, text);

    // Return the result
    return res;
}

// ==========
// File reader functions
// ==========

// Create a new value for a file reader
gpr_file_reader FileReader_new_value() {
    return NULL;
}

// Wrap a native file reader in the Java wrapping class
jobject FileReader_wrap(
    JNIEnv *env,
    gpr_file_reader file_reader_native
) {
    // Return the new file reader
    return (*env)->NewObject(
        env,
        FileReader_class_ref,
        FileReader_constructor_id,
        PointerWrapper_wrap(env, (void *) file_reader_native)
    );
}

// Get a native file reader from a Java wrapping instance
gpr_file_reader FileReader_unwrap(
    JNIEnv *env,
    jobject file_reader
) {
    return (gpr_file_reader) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            file_reader,
            FileReader_reference_field_id
        )
    );
}

// Decrease the reference counter of the given file reader
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1dec_1ref_1file_1reader(
    JNIEnv *env,
    jclass jni_lib,
    jobject file_reader
) {
    gpr_dec_ref_file_reader(FileReader_unwrap(env, file_reader));
}

// ==========
// Unit provider functions
// ==========

// Create a new value for a unit provider
gpr_unit_provider UnitProvider_new_value() {
    return NULL;
}

// Wrap a native unit provider in the Java wrapping class
jobject UnitProvider_wrap(
    JNIEnv *env,
    gpr_unit_provider unit_prov_native
) {
    // Return the new unit provider
    return (*env)->NewObject(
        env,
        UnitProvider_class_ref,
        UnitProvider_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_prov_native)
    );
}

// Get a native unit provider from a Java wrapping instance
gpr_unit_provider UnitProvider_unwrap(
    JNIEnv *env,
    jobject unit_provider
) {
    return (gpr_unit_provider) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            unit_provider,
            UnitProvider_reference_field_id
        )
    );
}

JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1dec_1ref_1unit_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_provider
) {
    gpr_dec_ref_unit_provider(UnitProvider_unwrap(env, unit_provider));
}

// ==========
// Event handler functions
// ==========

// Create a new value for a event handler
gpr_event_handler EventHandler_new_value() {
    return NULL;
}

// Wrap a native event handler in the Java wrapping class
jobject EventHandler_wrap(
    JNIEnv *env,
    gpr_event_handler event_handler_native
) {
    // Return the new event handler
    return (*env)->CallStaticObjectMethod(
        env,
        EventHandler_class_ref,
        EventHandler_from_reference_id,
        PointerWrapper_wrap(env, (void *) event_handler_native)
    );
}

// Get the native event handler from a Java wrapping instance
gpr_event_handler EventHandler_unwrap(
    JNIEnv *env,
    jobject event_handler
) {
    return (gpr_event_handler) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            event_handler,
            EventHandler_reference_field_id
        )
    );
}

// Util function to destroy the native event handler
void event_handler_destroy(
    void *data
) {
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;
    if(jvm_running) {
        (*env)->DeleteGlobalRef(env, eh_data->unit_requested_callback);
        (*env)->DeleteGlobalRef(env, eh_data->unit_parsed_callback);
    }
    free(data);
}

// Util function called when a unit is requested
void event_handler_unit_requested(
    void *data,
    gpr_analysis_context context,
    gpr_text *name,
    gpr_analysis_unit from,
    gpr_bool found,
    gpr_bool is_not_found_error
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_requested_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject text = Text_wrap(env, *name);
        jobject analysis_unit = AnalysisUnit_wrap(env, from);

        // Call the unit requested callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_requested_callback,
            UnitRequestedCallback_invoke_id,
            analysis_context,
            get_text_content(env, text),
            analysis_unit,
            (jboolean) found,
            (jboolean) is_not_found_error
        );

        // Remove the intermediary values
        gpr_context_decref(context);
        gpr_destroy_text(name);
    }
}

// Util function called when a unit is parsed
void event_handler_unit_parsed(
    void *data,
    gpr_analysis_context context,
    gpr_analysis_unit unit,
    gpr_bool reparsed
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_parsed_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject analysis_unit = AnalysisUnit_wrap(env, unit);

        // Call the unit parsed callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_parsed_callback,
            UnitParsedCallback_invoke_id,
            analysis_context,
            analysis_unit,
            (jboolean) reparsed
        );

        // Remove the intermediary values
        gpr_context_decref(context);
    }
}

// Create a new event handler
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1create_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_requested_callback,
    jobject unit_parsed_callback
) {
    // Create the structure to store the event handler information
    event_handler_data *data = (event_handler_data *) malloc(
        sizeof(event_handler_data)
    );
    data->env = env;
    data->unit_requested_callback = (*env)->NewGlobalRef(
        env,
        unit_requested_callback
    );
    data->unit_parsed_callback = (*env)->NewGlobalRef(
        env,
        unit_parsed_callback
    );

    // Call the native function
    gpr_event_handler res_native = gpr_create_event_handler(
        (void *) data,
        &event_handler_destroy,
        &event_handler_unit_requested,
        &event_handler_unit_parsed
    );

    // Return the wrapped pointer
    return PointerWrapper_wrap(env, (void *) res_native);
}

// Decrease the reference counter of an event handler
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1dec_1ref_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject event_handler
) {
    gpr_dec_ref_event_handler(EventHandler_unwrap(env, event_handler));
}

// ==========
// Token functions
// ==========

// Create a new value for a token
gpr_token Token_new_value() {
    gpr_token res = {
        NULL,
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a native token in the Java wrapping class
jobject Token_wrap(
    JNIEnv *env,
    gpr_token token_native,
    jobject analysis_unit
) {
    gpr_token_kind tok_kind;
    gpr_text tok_text;
    gpr_source_location_range tok_sloc_range;
    jobject text;
    jstring text_string;

    // Handle the no tokens
    if(token_native.token_data == NULL) {
        return NoToken_wrap(env, analysis_unit);
    }

    // Fetch extra token data requires to build a Token instance, but not
    // present in the C-level token data type: kind, text and sloc_range.
    tok_kind = gpr_token_get_kind (&token_native);
    gpr_token_sloc_range (&token_native, &tok_sloc_range);

    gpr_token_range_text (&token_native, &token_native, &tok_text);
    text = Text_wrap(env, tok_text);
    text_string = get_text_content(env, text);
    gpr_destroy_text (&tok_text);

    return (*env)->NewObject(
        env,
        Token_class_ref,
        Token_constructor_id,
        PointerWrapper_wrap(env, token_native.context),
        analysis_unit,
        PointerWrapper_wrap(env, token_native.token_data),
        (jint) token_native.token_index,
        (jint) token_native.trivia_index,
        TokenKind_wrap(env, tok_kind),
        text_string,
        SourceLocationRange_wrap(env, tok_sloc_range)
    );
}

// Get a native token from the Java wrapping instance
gpr_token Token_unwrap(
    JNIEnv *env,
    jobject token
) {
    // Prepare the result structure
    gpr_token res = Token_new_value();

    // Check if the token is instance of no token
    if((*env)->IsInstanceOf(env, token, NoToken_class_ref)) {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );

        // Fill the result structure
        res.context = (gpr_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (gpr_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = 0;
        res.trivia_index = 0;

        // Return the result
        return res;

    } else {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );
        jint token_index_value = (*env)->GetIntField(
            env,
            token,
            Token_token_index_field_id
        );
        jint trivia_index_value = (*env)->GetIntField(
            env,
            token,
            Token_trivia_index_field_id
        );

        // Fill the result structure
        res.context = (gpr_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (gpr_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = (int) token_index_value;
        res.trivia_index = (int) trivia_index_value;

        // Return the result
        return res;

    }
}

// Get the analysis unit from a token
jobject Token_get_unit(
    JNIEnv *env,
    jobject token
) {
    // Return the field
    return (*env)->GetObjectField(
        env,
        token,
        Token_unit_field_id
    );
}

// Get the no token instance for the given analysis unit
jobject NoToken_wrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    // Call the instance getter and return the result
    return (*env)->CallStaticObjectMethod(
        env,
        Token_class_ref,
        Token_none_getter_method_id,
        analysis_unit
    );
}

// Get the next token from the given token
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1token_1next(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    gpr_token token_native = Token_unwrap(env, token);

    // Prepare the result
    gpr_token res = Token_new_value();

    // Call the native function
    gpr_token_next(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get the previous token from the given token
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1token_1previous(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    gpr_token token_native = Token_unwrap(env, token);

    // Prepare the result
    gpr_token res = Token_new_value();

    // Call the native function
    gpr_token_previous(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get if the given token are equivalents
JNIEXPORT jboolean Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1token_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject left,
    jobject right
) {
    // Get the token native values
    gpr_token left_native = Token_unwrap(env, left);
    gpr_token right_native = Token_unwrap(env, right);

    // Return the result of the native call
    return (jboolean) gpr_token_is_equivalent(
        &left_native,
        &right_native
    );
}

// Get the text in the token interval
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1token_1range_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject start,
    jobject end
) {
    // Get the token native values
    gpr_token start_native = Token_unwrap(env, start);
    gpr_token end_native = Token_unwrap(env, end);

    // Prepare the result
    gpr_text res = Text_new_value();

    // Call the native function
    gpr_token_range_text(
        &start_native,
        &end_native,
        &res
    );

    // Return the result text
    return Text_wrap(env, res);
}

// ==========
// Analysis context functions
// ==========

// Create a new value for an analysis context
gpr_analysis_context AnalysisContext_new_value() {
    return NULL;
}

// Wrap a native analysis context in the Java wrapping class
jobject AnalysisContext_wrap(
    JNIEnv *env,
    gpr_analysis_context context_native
) {
    // Return the new analysis context
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisContext_class_ref,
        AnalysisContext_from_reference_id,
        PointerWrapper_wrap(env, (void *) context_native)
    );
}

// Get a native analysis context from a Java wrapping instance
gpr_analysis_context AnalysisContext_unwrap(
    JNIEnv *env,
    jobject analysis_context
) {
    return (gpr_analysis_context) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_context,
            AnalysisContext_reference_field_id
        )
    );
}

// Create a new analysis context
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1create_1analysis_1context(
    JNIEnv *env,
    jclass jni_lib,
    jstring charset,
    jobject file_reader,
    jobject unit_provider,
    jobject event_handler,
    jboolean with_trivia,
    jint tab_stop
) {
    // Translate the charset string
    const char* charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Allocate the analysis context
    gpr_analysis_context res = gpr_allocate_analysis_context();

    // Call the native function
    gpr_initialize_analysis_context(
        res,
        charset_native,
        FileReader_unwrap(env, file_reader),
        UnitProvider_unwrap(env, unit_provider),
        EventHandler_unwrap(env, event_handler),
        (int) with_trivia,
        (int) tab_stop
    );

    // Release the allocated string
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new custom pointer to the analysis context
    return PointerWrapper_wrap(env, res);
}

// Increase the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1context_1incref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native function
    gpr_context_incref(
        (gpr_analysis_context) analysis_context
    );
}

// Decrease the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1context_1decref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native funtion
    gpr_context_decref(
        (gpr_analysis_context) analysis_context
    );
}

// ==========
// Analysis unit functions
// ==========

// Create a new value for an analysis unit
gpr_analysis_unit AnalysisUnit_new_value() {
    return NULL;
}

// Wrap a native analysis unit in the Java wrapping class
jobject AnalysisUnit_wrap(
    JNIEnv *env,
    gpr_analysis_unit unit_native
) {
    // Return the new analysis unit
    return (*env)->NewObject(
        env,
        AnalysisUnit_class_ref,
        AnalysisUnit_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_native)
    );
}

// Get a native analysis unit from a Java wrapping instance
gpr_analysis_unit AnalysisUnit_unwrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    return (gpr_analysis_unit) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_unit,
            AnalysisUnit_reference_field_id
        )
    );
}

// Create an analysis unit from a file
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1get_1analysis_1unit_1from_1file(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jboolean reparse,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    gpr_analysis_unit res = gpr_get_analysis_unit_from_file(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        (int) reparse,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new Analysis unit
    return AnalysisUnit_wrap(env, res);
}

// Create an analysis unit from a buffer
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1get_1analysis_1unit_1from_1buffer(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jstring buffer,
    jlong buffer_size,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *buffer_native = to_c_string(env, buffer);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    gpr_analysis_unit res = gpr_get_analysis_unit_from_buffer(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        buffer_native,
        (long) buffer_size,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    release_c_string(env, buffer, buffer_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new analysis unit
    return AnalysisUnit_wrap(env, res);
}


// Get the root entity from an analysis unit
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    gpr_base_entity res = Entity_new_value();

    // Call the native function
    gpr_unit_root(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the new entity
    return Entity_wrap(env, res);
}

// Get the name of the file related to the analysis unit
JNIEXPORT jstring Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1filename(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native function
    char *res_native = gpr_unit_filename(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the new java string
    jstring res = to_j_string(env, res_native);

    // Free the native allocated string
    gpr_free((void *) res_native);

    // Return the result
    return res;
}

// Get the token count of the analysis unit
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1token_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) gpr_unit_token_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1trivia_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) gpr_unit_trivia_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the first token of the analysis unit
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1first_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    gpr_token res = Token_new_value();

    // Call the native function
    gpr_unit_first_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the last token of the analysis unit
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1last_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    gpr_token res = Token_new_value();

    // Call the native function
    gpr_unit_last_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the analysis context for an analysis unit
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native result
    gpr_analysis_context res = gpr_unit_context(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the result context
    return AnalysisContext_wrap(env, res);
}

// Get the count of the diagnostic in the analysis unit
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1diagnostic_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Return the casted native call
    return (jint) gpr_unit_diagnostic_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the nth diagnostic in the analysis unit
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1unit_1diagnostic(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit,
    jint n
) {
    // Prepare the result
    gpr_diagnostic res = Diagnostic_new_value();

    // Call the native function
    gpr_unit_diagnostic(
        AnalysisUnit_unwrap(env, analysis_unit),
        (unsigned) n,
        &res
    );

    // Return the diagnostic
    return Diagnostic_wrap(env, res);
}

// ==========
// Generated structure functions
// ==========


    

// Create a new value for a langkit gpr_internal_metadata
gpr_internal_metadata Metadata_new_value() {
    gpr_internal_metadata res = {
        0,
    };
    return res;
}

// Wrap a native gpr_internal_metadata in the Java wrapping class
jobject Metadata_wrap(
    JNIEnv *env,
    gpr_internal_metadata native_struct
) {
    // Return the None instance because there is no need of new one
    return (*env)->GetStaticObjectField(
        env,
        Metadata_class_ref,
        Metadata_none_field_id
    );
}

// Get a native gpr_internal_metadata from a Java wrapping instance
gpr_internal_metadata Metadata_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    gpr_internal_metadata res = Metadata_new_value();

    // Get the field values

    // Fill the result structure

    // Return the native result
    return res;
}



    

// Create a new value for a langkit gpr_internal_entity_info
gpr_internal_entity_info EntityInfo_new_value() {
    gpr_internal_entity_info res = {
        Metadata_new_value(),
        PointerWrapper_new_value(),
        0,
    };
    return res;
}

// Wrap a native gpr_internal_entity_info in the Java wrapping class
jobject EntityInfo_wrap(
    JNIEnv *env,
    gpr_internal_entity_info native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        EntityInfo_class_ref,
        EntityInfo_constructor_id,
        Metadata_wrap(env, native_struct.md), PointerWrapper_wrap(env, (void*) native_struct.rebindings), (jboolean) native_struct.from_rebound
    );
}

// Get a native gpr_internal_entity_info from a Java wrapping instance
gpr_internal_entity_info EntityInfo_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    gpr_internal_entity_info res = EntityInfo_new_value();

    // Get the field values
    jobject md_value =
        (*env)->GetObjectField(
        env,
        object,
        EntityInfo_md_field_id
    );
    jobject rebindings_value =
        (*env)->GetObjectField(
        env,
        object,
        EntityInfo_rebindings_field_id
    );
    jboolean from_rebound_value =
        (*env)->GetBooleanField(
        env,
        object,
        EntityInfo_from_rebound_field_id
    );

    // Fill the result structure
    gpr_internal_metadata md_native = Metadata_unwrap(env, md_value);
    res.md = md_native;
    gpr_env_rebindings_type rebindings_native = PointerWrapper_unwrap(env, rebindings_value);
    res.rebindings = rebindings_native;
    gpr_bool from_rebound_native = (gpr_bool) from_rebound_value;
    res.from_rebound = from_rebound_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit gpr_base_entity
gpr_base_entity Entity_new_value() {
    gpr_base_entity res = {
        PointerWrapper_new_value(),
        EntityInfo_new_value(),
    };
    return res;
}

// Wrap a native gpr_base_entity in the Java wrapping class
jobject Entity_wrap(
    JNIEnv *env,
    gpr_base_entity native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Entity_class_ref,
        Entity_constructor_id,
        PointerWrapper_wrap(env, (void*) native_struct.node), EntityInfo_wrap(env, native_struct.info)
    );
}

// Get a native gpr_base_entity from a Java wrapping instance
gpr_base_entity Entity_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    gpr_base_entity res = Entity_new_value();

    // Get the field values
    jobject node_value =
        (*env)->GetObjectField(
        env,
        object,
        Entity_node_field_id
    );
    jobject info_value =
        (*env)->GetObjectField(
        env,
        object,
        Entity_info_field_id
    );

    // Fill the result structure
    gpr_base_node node_native = PointerWrapper_unwrap(env, node_value);
    res.node = node_native;
    gpr_internal_entity_info info_native = EntityInfo_unwrap(env, info_value);
    res.info = info_native;

    // Return the native result
    return res;
}



// ==========
// Generated array functions
// ==========


    

// Create a new value for a gpr_gpr_node_array
gpr_gpr_node_array GprNodeArray_new_value() {
    return NULL;
}

// Wrap a native gpr_gpr_node_array in the Java wrapping class
jobject GprNodeArray_wrap(
    JNIEnv *env,
    gpr_gpr_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jobjectArray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put the elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        gpr_base_entity elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        GprNodeArray_class_ref,
        GprNodeArray_create_method_id,
        array_content
    );
}

// Get a native gpr_gpr_node_array from a Java wrapping instance
gpr_gpr_node_array GprNodeArray_unwrap(
    JNIEnv *env,
    jobject array
    
) {

    //  Retrieve the array's content
    jobjectArray content = (jobjectArray) (*env)->CallObjectMethod(
        env,
        array,
        GprNodeArray_content_method_id
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    gpr_gpr_node_array res = gpr_gpr_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        gpr_base_entity elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void GprNodeArray_release(
    gpr_gpr_node_array array_native
) {
    gpr_gpr_node_array_dec_ref(array_native);
}


// ==========
// Generated iterator functions
// ==========


// ==========
// AST node functions
// ==========

// Return whether the two given entities are equal
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity_left,
    jobject entity_right
) {
    // Unwrap the nodes
    gpr_base_entity entity_left_native = Entity_unwrap(env, entity_left);
    gpr_base_entity entity_right_native = Entity_unwrap(env, entity_right);

    // Call the native function
    return (jint) gpr_node_is_equivalent(
        &entity_left_native,
        &entity_right_native
    );
}

// Get the hash of a node
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1hash(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) gpr_node_hash(
        &entity_native
    );
}

// Get the kind of a node
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) gpr_node_kind(
        &entity_native
    );
}

// Get the text of a node
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    gpr_text res = Text_new_value();

    // Call the native function
    gpr_node_text(
        &entity_native,
        &res
    );

    // Return the node text
    return Text_wrap(env, res);
}

// Get the source location range of a node
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1sloc_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    gpr_source_location_range res = SourceLocationRange_new_value();

    // Call the native function
    gpr_node_sloc_range(
        &entity_native,
        &res
    );

    // Return the source location range
    return SourceLocationRange_wrap(env, res);
}

// Get the children count of a node
JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1children_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) gpr_node_children_count(
        &entity_native
    );
}

// Get the nth child of a node
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity,
    jint n
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Preapre the result
    gpr_base_entity res = Entity_new_value();

    // Call the native function
    gpr_node_child(
        &entity_native,
        (unsigned) n,
        &res
    );

    // Return the child entity
    return Entity_wrap(env, res);
}

// Get if a node is a token node
JNIEXPORT jboolean Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1is_1token_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jboolean) gpr_node_is_token_node(
        &entity_native
    );
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Call the native function
    gpr_analysis_unit res_native = gpr_node_unit(
        &entity_native
    );

    // Return the result
    return AnalysisUnit_wrap(env, res_native);
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1node_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    gpr_text res = Text_new_value();

    // Call the native function
    gpr_node_image(
        &entity_native,
        &res
    );

    // Return the image text
    return Text_wrap(env, res);
}

// ==========
// AST node field accessors
// ==========


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_gpr_node_parent(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1parents(
    JNIEnv *env,
    jclass jni_lib,
    jboolean with_self_java,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    gpr_bool with_self_native = (gpr_bool) with_self_java;

    // Prepare the result structure
    gpr_gpr_node_array res_native = GprNodeArray_new_value();

    // Call the native function
    gpr_gpr_node_parents(
        &entity_native,
        with_self_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = GprNodeArray_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
          GprNodeArray_release(
              res_native
          );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1children(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_gpr_node_array res_native = GprNodeArray_new_value();

    // Call the native function
    gpr_gpr_node_children(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = GprNodeArray_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
          GprNodeArray_release(
              res_native
          );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1token_1start(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    gpr_analysis_unit unit_native = gpr_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    gpr_token res_native = Token_new_value();

    // Call the native function
    gpr_gpr_node_token_start(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1token_1end(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    gpr_analysis_unit unit_native = gpr_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    gpr_token res_native = Token_new_value();

    // Call the native function
    gpr_gpr_node_token_end(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1child_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    gpr_gpr_node_child_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1previous_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_gpr_node_previous_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1next_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_gpr_node_next_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    gpr_gpr_node_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1is_1ghost(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_bool res_native = 0;

    // Call the native function
    gpr_gpr_node_is_ghost(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1gpr_1node_1full_1sloc_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_string_type res_native = String_new_value();

    // Call the native function
    gpr_gpr_node_full_sloc_image(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = String_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
          String_release(
              res_native
          );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1all_1qualifier_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_bool res_native = 0;

    // Call the native function
    gpr_all_qualifier_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1attribute_1decl_1f_1attr_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_attribute_decl_f_attr_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1attribute_1decl_1f_1attr_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_attribute_decl_f_attr_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1attribute_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_attribute_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1attribute_1reference_1f_1attribute_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_attribute_reference_f_attribute_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1attribute_1reference_1f_1attribute_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_attribute_reference_f_attribute_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1builtin_1function_1call_1f_1function_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_builtin_function_call_f_function_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1builtin_1function_1call_1f_1parameters(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_builtin_function_call_f_parameters(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1case_1construction_1f_1var_1ref(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_case_construction_f_var_ref(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1case_1construction_1f_1items(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_case_construction_f_items(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1case_1item_1f_1choice(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_case_item_f_choice(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1case_1item_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_case_item_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1compilation_1unit_1f_1project(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_compilation_unit_f_project(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1prefix_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_prefix_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1prefix_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_prefix_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1limited_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_bool res_native = 0;

    // Call the native function
    gpr_limited_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1decl_1f_1pkg_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_decl_f_pkg_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1decl_1f_1pkg_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_decl_f_pkg_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1extension_1f_1extended_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_extension_f_extended_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1renaming_1f_1renamed_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_renaming_f_renamed_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1spec_1f_1extension(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_spec_f_extension(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1spec_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_spec_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1package_1spec_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_package_spec_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1f_1context_1clauses(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_f_context_clauses(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1f_1project_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_f_project_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1declaration_1f_1qualifier(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_declaration_f_qualifier(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1declaration_1f_1project_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_declaration_f_project_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1declaration_1f_1extension(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_declaration_f_extension(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1declaration_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_declaration_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1declaration_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_declaration_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1extension_1f_1is_1all(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_extension_f_is_all(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1project_1extension_1f_1path_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_project_extension_f_path_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1string_1literal_1at_1f_1str_1lit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_string_literal_at_f_str_lit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1string_1literal_1at_1f_1at_1lit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_string_literal_at_f_at_lit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1terms_1f_1terms(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_terms_f_terms(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1type_1reference_1f_1var_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_type_reference_f_var_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1typed_1string_1decl_1f_1type_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_typed_string_decl_f_type_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1typed_1string_1decl_1f_1string_1literals(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_typed_string_decl_f_string_literals(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1variable_1decl_1f_1var_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_variable_decl_f_var_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1variable_1decl_1f_1var_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_variable_decl_f_var_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1variable_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_variable_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1variable_1reference_1f_1variable_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_variable_reference_f_variable_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1variable_1reference_1f_1attribute_1ref(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_variable_reference_f_attribute_ref(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1with_1decl_1f_1is_1limited(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_with_decl_f_is_limited(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_gpr_parser_GprParser_00024JNI_1LIB_gpr_1with_1decl_1f_1path_1names(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    gpr_base_entity entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    gpr_base_entity res_native = Entity_new_value();

    // Call the native function
    gpr_with_decl_f_path_names(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const gpr_exception *exc_c = gpr_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}

