/*
**  ClanLib SDK
**  Copyright (c) 1997-2020 The ClanLib Team
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
**  Note: Some of the libraries ClanLib may link to may have additional
**  requirements or restrictions.
**
**  File Author(s):
**
**    Magnus Norddahl
**    Mark Page
*/


#pragma once

#include "../Core/System/cl_platform.h"

#if defined(__IOS__)
#include <OpenGLES/ES2/gl.h>
#include <OpenGLES/ES2/glext.h>
#elif defined(__APPLE__)
#include <OpenGL/gl.h>
#include <OpenGL/glext.h>
#elif defined(__ANDROID__)
#include <GLES/gl.h>
#else
#include <GL/gl.h>
#endif

#include <cstddef>

namespace clan
{
/// \addtogroup clanGL_Display clanGL Display
/// \{

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef signed char GLbyte;
typedef short GLshort;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned int GLuint;
typedef int64_t CLint64;
typedef uint64_t CLuint64;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef void GLvoid;
typedef char GLchar;
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
typedef struct __CLsync *CLsync;

typedef void * CLDEBUGPROCARB;
typedef void * CLDEBUGPROC;

/// \brief Display Defines
enum DisplayDefines
{

#ifdef __ANDROID__	// OpenGL ES3.2
#define	CLANLIB_OPENGL_ES3
#endif

#ifdef CLANLIB_OPENGL_ES3

// Undefine windows GL.h defines to assist in initial clanlib development. These can be removed once ES3.2 conversion is complete
#undef GL_ACCUM
#undef GL_LOAD
#undef GL_RETURN
#undef GL_MULT
#undef GL_ADD
#undef GL_NEVER
#undef GL_LESS
#undef GL_EQUAL
#undef GL_LEQUAL
#undef GL_GREATER
#undef GL_NOTEQUAL
#undef GL_GEQUAL
#undef GL_ALWAYS
#undef GL_CURRENT_BIT
#undef GL_POINT_BIT
#undef GL_LINE_BIT
#undef GL_POLYGON_BIT
#undef GL_POLYGON_STIPPLE_BIT
#undef GL_PIXEL_MODE_BIT
#undef GL_LIGHTING_BIT
#undef GL_FOG_BIT
#undef GL_DEPTH_BUFFER_BIT
#undef GL_ACCUM_BUFFER_BIT
#undef GL_STENCIL_BUFFER_BIT
#undef GL_VIEWPORT_BIT
#undef GL_TRANSFORM_BIT
#undef GL_ENABLE_BIT
#undef GL_COLOR_BUFFER_BIT
#undef GL_HINT_BIT
#undef GL_EVAL_BIT
#undef GL_LIST_BIT
#undef GL_TEXTURE_BIT
#undef GL_SCISSOR_BIT
#undef GL_ALL_ATTRIB_BITS
#undef GL_POINTS
#undef GL_LINES
#undef GL_LINE_LOOP
#undef GL_LINE_STRIP
#undef GL_TRIANGLES
#undef GL_TRIANGLE_STRIP
#undef GL_TRIANGLE_FAN
#undef GL_QUADS
#undef GL_QUAD_STRIP
#undef GL_POLYGON
#undef GL_ZERO
#undef GL_ONE
#undef GL_SRC_COLOR
#undef GL_ONE_MINUS_SRC_COLOR
#undef GL_SRC_ALPHA
#undef GL_ONE_MINUS_SRC_ALPHA
#undef GL_DST_ALPHA
#undef GL_ONE_MINUS_DST_ALPHA
#undef GL_DST_COLOR
#undef GL_ONE_MINUS_DST_COLOR
#undef GL_SRC_ALPHA_SATURATE
#undef GL_TRUE
#undef GL_FALSE
#undef GL_CLIP_PLANE0
#undef GL_CLIP_PLANE1
#undef GL_CLIP_PLANE2
#undef GL_CLIP_PLANE3
#undef GL_CLIP_PLANE4
#undef GL_CLIP_PLANE5
#undef GL_BYTE
#undef GL_UNSIGNED_BYTE
#undef GL_SHORT
#undef GL_UNSIGNED_SHORT
#undef GL_INT
#undef GL_UNSIGNED_INT
#undef GL_FLOAT
#undef GL_2_BYTES
#undef GL_3_BYTES
#undef GL_4_BYTES
#undef GL_DOUBLE
#undef GL_NONE
#undef GL_FRONT_LEFT
#undef GL_FRONT_RIGHT
#undef GL_BACK_LEFT
#undef GL_BACK_RIGHT
#undef GL_FRONT
#undef GL_BACK
#undef GL_LEFT
#undef GL_RIGHT
#undef GL_FRONT_AND_BACK
#undef GL_AUX0
#undef GL_AUX1
#undef GL_AUX2
#undef GL_AUX3
#undef GL_NO_ERROR
#undef GL_INVALID_ENUM
#undef GL_INVALID_VALUE
#undef GL_INVALID_OPERATION
#undef GL_STACK_OVERFLOW
#undef GL_STACK_UNDERFLOW
#undef GL_OUT_OF_MEMORY
#undef GL_2D
#undef GL_3D
#undef GL_3D_COLOR
#undef GL_3D_COLOR_TEXTURE
#undef GL_4D_COLOR_TEXTURE
#undef GL_PASS_THROUGH_TOKEN
#undef GL_POINT_TOKEN
#undef GL_LINE_TOKEN
#undef GL_POLYGON_TOKEN
#undef GL_BITMAP_TOKEN
#undef GL_DRAW_PIXEL_TOKEN
#undef GL_COPY_PIXEL_TOKEN
#undef GL_LINE_RESET_TOKEN
#undef GL_EXP
#undef GL_EXP2
#undef GL_CW
#undef GL_CCW
#undef GL_COEFF
#undef GL_ORDER
#undef GL_DOMAIN
#undef GL_CURRENT_COLOR
#undef GL_CURRENT_INDEX
#undef GL_CURRENT_NORMAL
#undef GL_CURRENT_TEXTURE_COORDS
#undef GL_CURRENT_RASTER_COLOR
#undef GL_CURRENT_RASTER_INDEX
#undef GL_CURRENT_RASTER_TEXTURE_COORDS
#undef GL_CURRENT_RASTER_POSITION
#undef GL_CURRENT_RASTER_POSITION_VALID
#undef GL_CURRENT_RASTER_DISTANCE
#undef GL_POINT_SMOOTH
#undef GL_POINT_SIZE
#undef GL_POINT_SIZE_RANGE
#undef GL_POINT_SIZE_GRANULARITY
#undef GL_LINE_SMOOTH
#undef GL_LINE_WIDTH
#undef GL_LINE_WIDTH_RANGE
#undef GL_LINE_WIDTH_GRANULARITY
#undef GL_LINE_STIPPLE
#undef GL_LINE_STIPPLE_PATTERN
#undef GL_LINE_STIPPLE_REPEAT
#undef GL_LIST_MODE
#undef GL_MAX_LIST_NESTING
#undef GL_LIST_BASE
#undef GL_LIST_INDEX
#undef GL_POLYGON_MODE
#undef GL_POLYGON_SMOOTH
#undef GL_POLYGON_STIPPLE
#undef GL_EDGE_FLAG
#undef GL_CULL_FACE
#undef GL_CULL_FACE_MODE
#undef GL_FRONT_FACE
#undef GL_LIGHTING
#undef GL_LIGHT_MODEL_LOCAL_VIEWER
#undef GL_LIGHT_MODEL_TWO_SIDE
#undef GL_LIGHT_MODEL_AMBIENT
#undef GL_SHADE_MODEL
#undef GL_COLOR_MATERIAL_FACE
#undef GL_COLOR_MATERIAL_PARAMETER
#undef GL_COLOR_MATERIAL
#undef GL_FOG
#undef GL_FOG_INDEX
#undef GL_FOG_DENSITY
#undef GL_FOG_START
#undef GL_FOG_END
#undef GL_FOG_MODE
#undef GL_FOG_COLOR
#undef GL_DEPTH_RANGE
#undef GL_DEPTH_TEST
#undef GL_DEPTH_WRITEMASK
#undef GL_DEPTH_CLEAR_VALUE
#undef GL_DEPTH_FUNC
#undef GL_ACCUM_CLEAR_VALUE
#undef GL_STENCIL_TEST
#undef GL_STENCIL_CLEAR_VALUE
#undef GL_STENCIL_FUNC
#undef GL_STENCIL_VALUE_MASK
#undef GL_STENCIL_FAIL
#undef GL_STENCIL_PASS_DEPTH_FAIL
#undef GL_STENCIL_PASS_DEPTH_PASS
#undef GL_STENCIL_REF
#undef GL_STENCIL_WRITEMASK
#undef GL_MATRIX_MODE
#undef GL_NORMALIZE
#undef GL_VIEWPORT
#undef GL_MODELVIEW_STACK_DEPTH
#undef GL_PROJECTION_STACK_DEPTH
#undef GL_TEXTURE_STACK_DEPTH
#undef GL_MODELVIEW_MATRIX
#undef GL_PROJECTION_MATRIX
#undef GL_TEXTURE_MATRIX
#undef GL_ATTRIB_STACK_DEPTH
#undef GL_CLIENT_ATTRIB_STACK_DEPTH
#undef GL_ALPHA_TEST
#undef GL_ALPHA_TEST_FUNC
#undef GL_ALPHA_TEST_REF
#undef GL_DITHER
#undef GL_BLEND_DST
#undef GL_BLEND_SRC
#undef GL_BLEND
#undef GL_LOGIC_OP_MODE
#undef GL_INDEX_LOGIC_OP
#undef GL_COLOR_LOGIC_OP
#undef GL_AUX_BUFFERS
#undef GL_DRAW_BUFFER
#undef GL_READ_BUFFER
#undef GL_SCISSOR_BOX
#undef GL_SCISSOR_TEST
#undef GL_INDEX_CLEAR_VALUE
#undef GL_INDEX_WRITEMASK
#undef GL_COLOR_CLEAR_VALUE
#undef GL_COLOR_WRITEMASK
#undef GL_INDEX_MODE
#undef GL_RGBA_MODE
#undef GL_DOUBLEBUFFER
#undef GL_STEREO
#undef GL_RENDER_MODE
#undef GL_PERSPECTIVE_CORRECTION_HINT
#undef GL_POINT_SMOOTH_HINT
#undef GL_LINE_SMOOTH_HINT
#undef GL_POLYGON_SMOOTH_HINT
#undef GL_FOG_HINT
#undef GL_TEXTURE_GEN_S
#undef GL_TEXTURE_GEN_T
#undef GL_TEXTURE_GEN_R
#undef GL_TEXTURE_GEN_Q
#undef GL_PIXEL_MAP_I_TO_I
#undef GL_PIXEL_MAP_S_TO_S
#undef GL_PIXEL_MAP_I_TO_R
#undef GL_PIXEL_MAP_I_TO_G
#undef GL_PIXEL_MAP_I_TO_B
#undef GL_PIXEL_MAP_I_TO_A
#undef GL_PIXEL_MAP_R_TO_R
#undef GL_PIXEL_MAP_G_TO_G
#undef GL_PIXEL_MAP_B_TO_B
#undef GL_PIXEL_MAP_A_TO_A
#undef GL_PIXEL_MAP_I_TO_I_SIZE
#undef GL_PIXEL_MAP_S_TO_S_SIZE
#undef GL_PIXEL_MAP_I_TO_R_SIZE
#undef GL_PIXEL_MAP_I_TO_G_SIZE
#undef GL_PIXEL_MAP_I_TO_B_SIZE
#undef GL_PIXEL_MAP_I_TO_A_SIZE
#undef GL_PIXEL_MAP_R_TO_R_SIZE
#undef GL_PIXEL_MAP_G_TO_G_SIZE
#undef GL_PIXEL_MAP_B_TO_B_SIZE
#undef GL_PIXEL_MAP_A_TO_A_SIZE
#undef GL_UNPACK_SWAP_BYTES
#undef GL_UNPACK_LSB_FIRST
#undef GL_UNPACK_ROW_LENGTH
#undef GL_UNPACK_SKIP_ROWS
#undef GL_UNPACK_SKIP_PIXELS
#undef GL_UNPACK_ALIGNMENT
#undef GL_PACK_SWAP_BYTES
#undef GL_PACK_LSB_FIRST
#undef GL_PACK_ROW_LENGTH
#undef GL_PACK_SKIP_ROWS
#undef GL_PACK_SKIP_PIXELS
#undef GL_PACK_ALIGNMENT
#undef GL_MAP_COLOR
#undef GL_MAP_STENCIL
#undef GL_INDEX_SHIFT
#undef GL_INDEX_OFFSET
#undef GL_RED_SCALE
#undef GL_RED_BIAS
#undef GL_ZOOM_X
#undef GL_ZOOM_Y
#undef GL_GREEN_SCALE
#undef GL_GREEN_BIAS
#undef GL_BLUE_SCALE
#undef GL_BLUE_BIAS
#undef GL_ALPHA_SCALE
#undef GL_ALPHA_BIAS
#undef GL_DEPTH_SCALE
#undef GL_DEPTH_BIAS
#undef GL_MAX_EVAL_ORDER
#undef GL_MAX_LIGHTS
#undef GL_MAX_CLIP_PLANES
#undef GL_MAX_TEXTURE_SIZE
#undef GL_MAX_PIXEL_MAP_TABLE
#undef GL_MAX_ATTRIB_STACK_DEPTH
#undef GL_MAX_MODELVIEW_STACK_DEPTH
#undef GL_MAX_NAME_STACK_DEPTH
#undef GL_MAX_PROJECTION_STACK_DEPTH
#undef GL_MAX_TEXTURE_STACK_DEPTH
#undef GL_MAX_VIEWPORT_DIMS
#undef GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
#undef GL_SUBPIXEL_BITS
#undef GL_INDEX_BITS
#undef GL_RED_BITS
#undef GL_GREEN_BITS
#undef GL_BLUE_BITS
#undef GL_ALPHA_BITS
#undef GL_DEPTH_BITS
#undef GL_STENCIL_BITS
#undef GL_ACCUM_RED_BITS
#undef GL_ACCUM_GREEN_BITS
#undef GL_ACCUM_BLUE_BITS
#undef GL_ACCUM_ALPHA_BITS
#undef GL_NAME_STACK_DEPTH
#undef GL_AUTO_NORMAL
#undef GL_MAP1_COLOR_4
#undef GL_MAP1_INDEX
#undef GL_MAP1_NORMAL
#undef GL_MAP1_TEXTURE_COORD_1
#undef GL_MAP1_TEXTURE_COORD_2
#undef GL_MAP1_TEXTURE_COORD_3
#undef GL_MAP1_TEXTURE_COORD_4
#undef GL_MAP1_VERTEX_3
#undef GL_MAP1_VERTEX_4
#undef GL_MAP2_COLOR_4
#undef GL_MAP2_INDEX
#undef GL_MAP2_NORMAL
#undef GL_MAP2_TEXTURE_COORD_1
#undef GL_MAP2_TEXTURE_COORD_2
#undef GL_MAP2_TEXTURE_COORD_3
#undef GL_MAP2_TEXTURE_COORD_4
#undef GL_MAP2_VERTEX_3
#undef GL_MAP2_VERTEX_4
#undef GL_MAP1_GRID_DOMAIN
#undef GL_MAP1_GRID_SEGMENTS
#undef GL_MAP2_GRID_DOMAIN
#undef GL_MAP2_GRID_SEGMENTS
#undef GL_TEXTURE_1D
#undef GL_TEXTURE_2D
#undef GL_FEEDBACK_BUFFER_POINTER
#undef GL_FEEDBACK_BUFFER_SIZE
#undef GL_FEEDBACK_BUFFER_TYPE
#undef GL_SELECTION_BUFFER_POINTER
#undef GL_SELECTION_BUFFER_SIZE
#undef GL_TEXTURE_WIDTH
#undef GL_TEXTURE_HEIGHT
#undef GL_TEXTURE_INTERNAL_FORMAT
#undef GL_TEXTURE_BORDER_COLOR
#undef GL_TEXTURE_BORDER
#undef GL_DONT_CARE
#undef GL_FASTEST
#undef GL_NICEST
#undef GL_LIGHT0
#undef GL_LIGHT1
#undef GL_LIGHT2
#undef GL_LIGHT3
#undef GL_LIGHT4
#undef GL_LIGHT5
#undef GL_LIGHT6
#undef GL_LIGHT7
#undef GL_AMBIENT
#undef GL_DIFFUSE
#undef GL_SPECULAR
#undef GL_POSITION
#undef GL_SPOT_DIRECTION
#undef GL_SPOT_EXPONENT
#undef GL_SPOT_CUTOFF
#undef GL_CONSTANT_ATTENUATION
#undef GL_LINEAR_ATTENUATION
#undef GL_QUADRATIC_ATTENUATION
#undef GL_COMPILE
#undef GL_COMPILE_AND_EXECUTE
#undef GL_CLEAR
#undef GL_AND
#undef GL_AND_REVERSE
#undef GL_COPY
#undef GL_AND_INVERTED
#undef GL_NOOP
#undef GL_XOR
#undef GL_OR
#undef GL_NOR
#undef GL_EQUIV
#undef GL_INVERT
#undef GL_OR_REVERSE
#undef GL_COPY_INVERTED
#undef GL_OR_INVERTED
#undef GL_NAND
#undef GL_SET
#undef GL_EMISSION
#undef GL_SHININESS
#undef GL_AMBIENT_AND_DIFFUSE
#undef GL_COLOR_INDEXES
#undef GL_MODELVIEW
#undef GL_PROJECTION
#undef GL_TEXTURE
#undef GL_COLOR
#undef GL_DEPTH
#undef GL_STENCIL
#undef GL_COLOR_INDEX
#undef GL_STENCIL_INDEX
#undef GL_DEPTH_COMPONENT
#undef GL_RED
#undef GL_GREEN
#undef GL_BLUE
#undef GL_ALPHA
#undef GL_RGB
#undef GL_RGBA
#undef GL_LUMINANCE
#undef GL_LUMINANCE_ALPHA
#undef GL_BITMAP
#undef GL_POINT
#undef GL_LINE
#undef GL_FILL
#undef GL_RENDER
#undef GL_FEEDBACK
#undef GL_SELECT
#undef GL_FLAT
#undef GL_SMOOTH
#undef GL_KEEP
#undef GL_REPLACE
#undef GL_INCR
#undef GL_DECR
#undef GL_VENDOR
#undef GL_RENDERER
#undef GL_VERSION
#undef GL_EXTENSIONS
#undef GL_S
#undef GL_T
#undef GL_R
#undef GL_Q
#undef GL_MODULATE
#undef GL_DECAL
#undef GL_TEXTURE_ENV_MODE
#undef GL_TEXTURE_ENV_COLOR
#undef GL_TEXTURE_ENV
#undef GL_NEAREST
#undef GL_LINEAR
#undef GL_NEAREST_MIPMAP_NEAREST
#undef GL_LINEAR_MIPMAP_NEAREST
#undef GL_NEAREST_MIPMAP_LINEAR
#undef GL_LINEAR_MIPMAP_LINEAR
#undef GL_TEXTURE_MAG_FILTER
#undef GL_TEXTURE_MIN_FILTER
#undef GL_TEXTURE_WRAP_S
#undef GL_TEXTURE_WRAP_T
#undef GL_CLAMP
#undef GL_REPEAT
#undef GL_CLIENT_PIXEL_STORE_BIT
#undef GL_CLIENT_VERTEX_ARRAY_BIT
#undef GL_CLIENT_ALL_ATTRIB_BITS
#undef GL_POLYGON_OFFSET_FACTOR
#undef GL_POLYGON_OFFSET_UNITS
#undef GL_POLYGON_OFFSET_POINT
#undef GL_POLYGON_OFFSET_LINE
#undef GL_POLYGON_OFFSET_FILL
#undef GL_ALPHA4
#undef GL_ALPHA8
#undef GL_ALPHA12
#undef GL_ALPHA16
#undef GL_LUMINANCE4
#undef GL_LUMINANCE8
#undef GL_LUMINANCE12
#undef GL_LUMINANCE16
#undef GL_LUMINANCE4_ALPHA4
#undef GL_LUMINANCE6_ALPHA2
#undef GL_LUMINANCE8_ALPHA8
#undef GL_LUMINANCE12_ALPHA4
#undef GL_LUMINANCE12_ALPHA12
#undef GL_LUMINANCE16_ALPHA16
#undef GL_INTENSITY
#undef GL_INTENSITY4
#undef GL_INTENSITY8
#undef GL_INTENSITY12
#undef GL_INTENSITY16
#undef GL_R3_G3_B2
#undef GL_RGB4
#undef GL_RGB5
#undef GL_RGB8
#undef GL_RGB10
#undef GL_RGB12
#undef GL_RGB16
#undef GL_RGBA2
#undef GL_RGBA4
#undef GL_RGB5_A1
#undef GL_RGBA8
#undef GL_RGB10_A2
#undef GL_RGBA12
#undef GL_RGBA16
#undef GL_TEXTURE_RED_SIZE
#undef GL_TEXTURE_GREEN_SIZE
#undef GL_TEXTURE_BLUE_SIZE
#undef GL_TEXTURE_ALPHA_SIZE
#undef GL_TEXTURE_LUMINANCE_SIZE
#undef GL_TEXTURE_INTENSITY_SIZE
#undef GL_PROXY_TEXTURE_1D
#undef GL_PROXY_TEXTURE_2D
#undef GL_TEXTURE_PRIORITY
#undef GL_TEXTURE_RESIDENT
#undef GL_TEXTURE_BINDING_1D
#undef GL_TEXTURE_BINDING_2D
#undef GL_VERTEX_ARRAY
#undef GL_NORMAL_ARRAY
#undef GL_COLOR_ARRAY
#undef GL_INDEX_ARRAY
#undef GL_TEXTURE_COORD_ARRAY
#undef GL_EDGE_FLAG_ARRAY
#undef GL_VERTEX_ARRAY_SIZE
#undef GL_VERTEX_ARRAY_TYPE
#undef GL_VERTEX_ARRAY_STRIDE
#undef GL_NORMAL_ARRAY_TYPE
#undef GL_NORMAL_ARRAY_STRIDE
#undef GL_COLOR_ARRAY_SIZE
#undef GL_COLOR_ARRAY_TYPE
#undef GL_COLOR_ARRAY_STRIDE
#undef GL_INDEX_ARRAY_TYPE
#undef GL_INDEX_ARRAY_STRIDE
#undef GL_TEXTURE_COORD_ARRAY_SIZE
#undef GL_TEXTURE_COORD_ARRAY_TYPE
#undef GL_TEXTURE_COORD_ARRAY_STRIDE
#undef GL_EDGE_FLAG_ARRAY_STRIDE
#undef GL_VERTEX_ARRAY_POINTER
#undef GL_NORMAL_ARRAY_POINTER
#undef GL_COLOR_ARRAY_POINTER
#undef GL_INDEX_ARRAY_POINTER
#undef GL_TEXTURE_COORD_ARRAY_POINTER
#undef GL_EDGE_FLAG_ARRAY_POINTER
#undef GL_V2F
#undef GL_V3F
#undef GL_C4UB_V2F
#undef GL_C4UB_V3F
#undef GL_C3F_V3F
#undef GL_N3F_V3F
#undef GL_C4F_N3F_V3F
#undef GL_T2F_V3F
#undef GL_T4F_V4F
#undef GL_T2F_C4UB_V3F
#undef GL_T2F_C3F_V3F
#undef GL_T2F_N3F_V3F
#undef GL_T2F_C4F_N3F_V3F
#undef GL_T4F_C4F_N3F_V4F


	GL_DEPTH_BUFFER_BIT = 0x00000100,
	GL_STENCIL_BUFFER_BIT = 0x00000400,
	GL_COLOR_BUFFER_BIT = 0x00004000,
	GL_FALSE = 0,
	GL_TRUE = 1,
	GL_POINTS = 0x0000,
	GL_LINES = 0x0001,
	GL_LINE_LOOP = 0x0002,
	GL_LINE_STRIP = 0x0003,
	GL_TRIANGLES = 0x0004,
	GL_TRIANGLE_STRIP = 0x0005,
	GL_TRIANGLE_FAN = 0x0006,
	GL_ZERO = 0,
	GL_ONE = 1,
	GL_SRC_COLOR = 0x0300,
	GL_ONE_MINUS_SRC_COLOR = 0x0301,
	GL_SRC_ALPHA = 0x0302,
	GL_ONE_MINUS_SRC_ALPHA = 0x0303,
	GL_DST_ALPHA = 0x0304,
	GL_ONE_MINUS_DST_ALPHA = 0x0305,
	GL_DST_COLOR = 0x0306,
	GL_ONE_MINUS_DST_COLOR = 0x0307,
	GL_SRC_ALPHA_SATURATE = 0x0308,
	GL_FUNC_ADD = 0x8006,
	GL_BLEND_EQUATION = 0x8009,
	GL_BLEND_EQUATION_RGB = 0x8009,
	GL_BLEND_EQUATION_ALPHA = 0x883D,
	GL_FUNC_SUBTRACT = 0x800A,
	GL_FUNC_REVERSE_SUBTRACT = 0x800B,
	GL_BLEND_DST_RGB = 0x80C8,
	GL_BLEND_SRC_RGB = 0x80C9,
	GL_BLEND_DST_ALPHA = 0x80CA,
	GL_BLEND_SRC_ALPHA = 0x80CB,
	GL_CONSTANT_COLOR = 0x8001,
	GL_ONE_MINUS_CONSTANT_COLOR = 0x8002,
	GL_CONSTANT_ALPHA = 0x8003,
	GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004,
	GL_BLEND_COLOR = 0x8005,
#ifndef GL_ARRAY_BUFFER
	GL_ARRAY_BUFFER = 0x8892,
	GL_ELEMENT_ARRAY_BUFFER = 0x8893,
	GL_ARRAY_BUFFER_BINDING = 0x8894,
	GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895,
#endif
	GL_STREAM_DRAW = 0x88E0,
#ifndef GL_STATIC_DRAW
	GL_STATIC_DRAW = 0x88E4,
	GL_DYNAMIC_DRAW = 0x88E8,
	GL_BUFFER_SIZE = 0x8764,
	GL_BUFFER_USAGE = 0x8765,
#endif
		GL_CURRENT_VERTEX_ATTRIB = 0x8626,
	GL_FRONT = 0x0404,
	GL_BACK = 0x0405,
	GL_FRONT_AND_BACK = 0x0408,
	GL_TEXTURE_2D = 0x0DE1,
	GL_CULL_FACE = 0x0B44,
	GL_BLEND = 0x0BE2,
	GL_DITHER = 0x0BD0,
	GL_STENCIL_TEST = 0x0B90,
	GL_DEPTH_TEST = 0x0B71,
	GL_SCISSOR_TEST = 0x0C11,
	GL_POLYGON_OFFSET_FILL = 0x8037,
#ifndef GL_SAMPLE_ALPHA_TO_COVERAGE
	GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E,
	GL_SAMPLE_COVERAGE = 0x80A0,
#endif
	GL_NO_ERROR = 0,
	GL_INVALID_ENUM = 0x0500,
	GL_INVALID_VALUE = 0x0501,
	GL_INVALID_OPERATION = 0x0502,
	GL_OUT_OF_MEMORY = 0x0505,
	GL_CW = 0x0900,
	GL_CCW = 0x0901,
	GL_LINE_WIDTH = 0x0B21,
#ifndef GL_ALIASED_POINT_SIZE_RANGE
	GL_ALIASED_POINT_SIZE_RANGE = 0x846D,
	GL_ALIASED_LINE_WIDTH_RANGE = 0x846E,
#endif
	GL_CULL_FACE_MODE = 0x0B45,
	GL_FRONT_FACE = 0x0B46,
	GL_DEPTH_RANGE = 0x0B70,
	GL_DEPTH_WRITEMASK = 0x0B72,
	GL_DEPTH_CLEAR_VALUE = 0x0B73,
	GL_DEPTH_FUNC = 0x0B74,
	GL_STENCIL_CLEAR_VALUE = 0x0B91,
	GL_STENCIL_FUNC = 0x0B92,
	GL_STENCIL_FAIL = 0x0B94,
	GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95,
	GL_STENCIL_PASS_DEPTH_PASS = 0x0B96,
	GL_STENCIL_REF = 0x0B97,
	GL_STENCIL_VALUE_MASK = 0x0B93,
	GL_STENCIL_WRITEMASK = 0x0B98,
	GL_STENCIL_BACK_FUNC = 0x8800,
	GL_STENCIL_BACK_FAIL = 0x8801,
	GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802,
	GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803,
	GL_STENCIL_BACK_REF = 0x8CA3,
	GL_STENCIL_BACK_VALUE_MASK = 0x8CA4,
	GL_STENCIL_BACK_WRITEMASK = 0x8CA5,
	GL_VIEWPORT = 0x0BA2,
	GL_SCISSOR_BOX = 0x0C10,
	GL_COLOR_CLEAR_VALUE = 0x0C22,
	GL_COLOR_WRITEMASK = 0x0C23,
	GL_UNPACK_ALIGNMENT = 0x0CF5,
	GL_PACK_ALIGNMENT = 0x0D05,
	GL_MAX_TEXTURE_SIZE = 0x0D33,
	GL_MAX_VIEWPORT_DIMS = 0x0D3A,
	GL_SUBPIXEL_BITS = 0x0D50,
	GL_RED_BITS = 0x0D52,
	GL_GREEN_BITS = 0x0D53,
	GL_BLUE_BITS = 0x0D54,
	GL_ALPHA_BITS = 0x0D55,
	GL_DEPTH_BITS = 0x0D56,
	GL_STENCIL_BITS = 0x0D57,
	GL_POLYGON_OFFSET_UNITS = 0x2A00,
	GL_POLYGON_OFFSET_FACTOR = 0x8038,
	GL_TEXTURE_BINDING_2D = 0x8069,
#ifndef GL_SAMPLE_BUFFERS
	GL_SAMPLE_BUFFERS = 0x80A8,
	GL_SAMPLES = 0x80A9,
	GL_SAMPLE_COVERAGE_VALUE = 0x80AA,
	GL_SAMPLE_COVERAGE_INVERT = 0x80AB,
	GL_NUM_COMPRESSED_TEXTURE_FORMATS =0x86A2,
	GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3,
#endif
	GL_DONT_CARE = 0x1100,
	GL_FASTEST = 0x1101,
	GL_NICEST = 0x1102,
#ifndef GL_GENERATE_MIPMAP_HINT
	GL_GENERATE_MIPMAP_HINT = 0x8192,
#endif
	GL_BYTE = 0x1400,
	GL_UNSIGNED_BYTE = 0x1401,
	GL_SHORT = 0x1402,
	GL_UNSIGNED_SHORT = 0x1403,
	GL_INT = 0x1404,
	GL_UNSIGNED_INT = 0x1405,
	GL_FLOAT = 0x1406,
#ifndef GL_FIXED
		GL_FIXED = 0x140C,
#endif
	GL_DEPTH_COMPONENT = 0x1902,
	GL_ALPHA = 0x1906,
	GL_RGB = 0x1907,
	GL_RGBA = 0x1908,
	GL_LUMINANCE = 0x1909,
	GL_LUMINANCE_ALPHA = 0x190A,
#ifndef GL_UNSIGNED_SHORT_4_4_4_4
	GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033,
	GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034,
	GL_UNSIGNED_SHORT_5_6_5 = 0x8363,
#endif
	GL_FRAGMENT_SHADER = 0x8B30,
	GL_VERTEX_SHADER = 0x8B31,
	GL_MAX_VERTEX_ATTRIBS = 0x8869,
	GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB,
	GL_MAX_VARYING_VECTORS = 0x8DFC,
	GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS =0x8B4D,
	GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS =0x8B4C,
	GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872,
	GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD,
	GL_SHADER_TYPE = 0x8B4F,
	GL_DELETE_STATUS = 0x8B80,
	GL_LINK_STATUS = 0x8B82,
	GL_VALIDATE_STATUS = 0x8B83,
	GL_ATTACHED_SHADERS = 0x8B85,
	GL_ACTIVE_UNIFORMS = 0x8B86,
	GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87,
	GL_ACTIVE_ATTRIBUTES = 0x8B89,
	GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A,
	GL_SHADING_LANGUAGE_VERSION = 0x8B8C,
	GL_CURRENT_PROGRAM = 0x8B8D,
	GL_NEVER = 0x0200,
	GL_LESS = 0x0201,
	GL_EQUAL = 0x0202,
	GL_LEQUAL = 0x0203,
	GL_GREATER = 0x0204,
	GL_NOTEQUAL = 0x0205,
	GL_GEQUAL = 0x0206,
	GL_ALWAYS = 0x0207,
	GL_KEEP = 0x1E00,
	GL_REPLACE = 0x1E01,
	GL_INCR = 0x1E02,
	GL_DECR = 0x1E03,
	GL_INVERT = 0x150A,
	GL_INCR_WRAP = 0x8507,
	GL_DECR_WRAP = 0x8508,
	GL_VENDOR = 0x1F00,
	GL_RENDERER = 0x1F01,
	GL_VERSION = 0x1F02,
	GL_EXTENSIONS = 0x1F03,
	GL_NEAREST = 0x2600,
	GL_LINEAR = 0x2601,
	GL_NEAREST_MIPMAP_NEAREST = 0x2700,
	GL_LINEAR_MIPMAP_NEAREST = 0x2701,
	GL_NEAREST_MIPMAP_LINEAR = 0x2702,
	GL_LINEAR_MIPMAP_LINEAR = 0x2703,
	GL_TEXTURE_MAG_FILTER = 0x2800,
	GL_TEXTURE_MIN_FILTER = 0x2801,
	GL_TEXTURE_WRAP_S = 0x2802,
	GL_TEXTURE_WRAP_T = 0x2803,
	GL_TEXTURE = 0x1702,
	GL_TEXTURE_CUBE_MAP = 0x8513,
	GL_TEXTURE_BINDING_CUBE_MAP = 0x8514,
	GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516,
	GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518,
	GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A,
	GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C,
#ifndef GL_TEXTURE0
	GL_TEXTURE0 = 0x84C0,
	GL_TEXTURE1 = 0x84C1,
	GL_TEXTURE2 = 0x84C2,
	GL_TEXTURE3 = 0x84C3,
	GL_TEXTURE4 = 0x84C4,
	GL_TEXTURE5 = 0x84C5,
	GL_TEXTURE6 = 0x84C6,
	GL_TEXTURE7 = 0x84C7,
	GL_TEXTURE8 = 0x84C8,
	GL_TEXTURE9 = 0x84C9,
	GL_TEXTURE10 = 0x84CA,
	GL_TEXTURE11 = 0x84CB,
	GL_TEXTURE12 = 0x84CC,
	GL_TEXTURE13 = 0x84CD,
	GL_TEXTURE14 = 0x84CE,
	GL_TEXTURE15 = 0x84CF,
	GL_TEXTURE16 = 0x84D0,
	GL_TEXTURE17 = 0x84D1,
	GL_TEXTURE18 = 0x84D2,
	GL_TEXTURE19 = 0x84D3,
	GL_TEXTURE20 = 0x84D4,
	GL_TEXTURE21 = 0x84D5,
	GL_TEXTURE22 = 0x84D6,
	GL_TEXTURE23 = 0x84D7,
	GL_TEXTURE24 = 0x84D8,
	GL_TEXTURE25 = 0x84D9,
	GL_TEXTURE26 = 0x84DA,
	GL_TEXTURE27 = 0x84DB,
	GL_TEXTURE28 = 0x84DC,
	GL_TEXTURE29 = 0x84DD,
	GL_TEXTURE30 = 0x84DE,
	GL_TEXTURE31 = 0x84DF,
	GL_ACTIVE_TEXTURE = 0x84E0,
#endif
	GL_REPEAT = 0x2901,
#ifndef GL_CLAMP_TO_EDGE
	GL_CLAMP_TO_EDGE = 0x812F,
#endif
	GL_MIRRORED_REPEAT = 0x8370,
	GL_FLOAT_VEC2 = 0x8B50,
	GL_FLOAT_VEC3 = 0x8B51,
	GL_FLOAT_VEC4 = 0x8B52,
	GL_INT_VEC2 = 0x8B53,
	GL_INT_VEC3 = 0x8B54,
	GL_INT_VEC4 = 0x8B55,
	GL_BOOL = 0x8B56,
	GL_BOOL_VEC2 = 0x8B57,
	GL_BOOL_VEC3 = 0x8B58,
	GL_BOOL_VEC4 = 0x8B59,
	GL_FLOAT_MAT2 = 0x8B5A,
	GL_FLOAT_MAT3 = 0x8B5B,
	GL_FLOAT_MAT4 = 0x8B5C,
	GL_SAMPLER_2D = 0x8B5E,
	GL_SAMPLER_CUBE = 0x8B60,
	GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622,
	GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623,
	GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624,
	GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625,
	GL_VERTEX_ATTRIB_ARRAY_NORMALIZED =0x886A,
	GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645,
	GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING =0x889F,
	GL_IMPLEMENTATION_COLOR_READ_TYPE =0x8B9A,
	GL_IMPLEMENTATION_COLOR_READ_FORMAT =0x8B9B,
	GL_COMPILE_STATUS = 0x8B81,
	GL_INFO_LOG_LENGTH = 0x8B84,
	GL_SHADER_SOURCE_LENGTH = 0x8B88,
	GL_SHADER_COMPILER = 0x8DFA,
	GL_SHADER_BINARY_FORMATS = 0x8DF8,
	GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9,
	GL_LOW_FLOAT = 0x8DF0,
	GL_MEDIUM_FLOAT = 0x8DF1,
	GL_HIGH_FLOAT = 0x8DF2,
	GL_LOW_INT = 0x8DF3,
	GL_MEDIUM_INT = 0x8DF4,
	GL_HIGH_INT = 0x8DF5,
	GL_FRAMEBUFFER = 0x8D40,
	GL_RENDERBUFFER = 0x8D41,
	GL_RGBA4 = 0x8056,
	GL_RGB5_A1 = 0x8057,
	GL_RGB565 = 0x8D62,
	GL_DEPTH_COMPONENT16 = 0x81A5,
	GL_STENCIL_INDEX8 = 0x8D48,
	GL_RENDERBUFFER_WIDTH = 0x8D42,
	GL_RENDERBUFFER_HEIGHT = 0x8D43,
	GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44,
	GL_RENDERBUFFER_RED_SIZE = 0x8D50,
	GL_RENDERBUFFER_GREEN_SIZE = 0x8D51,
	GL_RENDERBUFFER_BLUE_SIZE = 0x8D52,
	GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53,
	GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54,
	GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55,
	GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE =0x8CD0,
	GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME =0x8CD1,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL =0x8CD2,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE =0x8CD3,
	GL_COLOR_ATTACHMENT0 = 0x8CE0,
	GL_DEPTH_ATTACHMENT = 0x8D00,
	GL_STENCIL_ATTACHMENT = 0x8D20,
	GL_NONE = 0,
	GL_FRAMEBUFFER_COMPLETE = 0x8CD5,
	GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT =0x8CD6,
	GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT =0x8CD7,
	GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS =0x8CD9,
	GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD,
	GL_FRAMEBUFFER_BINDING = 0x8CA6,
	GL_RENDERBUFFER_BINDING = 0x8CA7,
	GL_MAX_RENDERBUFFER_SIZE = 0x84E8,
	GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506,
	GL_READ_BUFFER = 0x0C02,
	GL_UNPACK_ROW_LENGTH = 0x0CF2,
	GL_UNPACK_SKIP_ROWS = 0x0CF3,
	GL_UNPACK_SKIP_PIXELS = 0x0CF4,
	GL_PACK_ROW_LENGTH = 0x0D02,
	GL_PACK_SKIP_ROWS = 0x0D03,
	GL_PACK_SKIP_PIXELS = 0x0D04,
	GL_COLOR = 0x1800,
	GL_DEPTH = 0x1801,
	GL_STENCIL = 0x1802,
	GL_RED = 0x1903,
	GL_RGB8 = 0x8051,
	GL_RGBA8 = 0x8058,
	GL_RGB10_A2 = 0x8059,
	GL_TEXTURE_BINDING_3D = 0x806A,
	GL_UNPACK_SKIP_IMAGES = 0x806D,
	GL_UNPACK_IMAGE_HEIGHT = 0x806E,
	GL_TEXTURE_3D = 0x806F,
	GL_TEXTURE_WRAP_R = 0x8072,
	GL_MAX_3D_TEXTURE_SIZE = 0x8073,
	GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368,
	GL_MAX_ELEMENTS_VERTICES = 0x80E8,
	GL_MAX_ELEMENTS_INDICES = 0x80E9,
	GL_TEXTURE_MIN_LOD = 0x813A,
	GL_TEXTURE_MAX_LOD = 0x813B,
	GL_TEXTURE_BASE_LEVEL = 0x813C,
	GL_TEXTURE_MAX_LEVEL = 0x813D,
	GL_MIN = 0x8007,
	GL_MAX = 0x8008,
	GL_DEPTH_COMPONENT24 = 0x81A6,
	GL_MAX_TEXTURE_LOD_BIAS = 0x84FD,
	GL_TEXTURE_COMPARE_MODE = 0x884C,
	GL_TEXTURE_COMPARE_FUNC = 0x884D,
	GL_CURRENT_QUERY = 0x8865,
	GL_QUERY_RESULT = 0x8866,
	GL_QUERY_RESULT_AVAILABLE = 0x8867,
	GL_BUFFER_MAPPED = 0x88BC,
	GL_BUFFER_MAP_POINTER = 0x88BD,
	GL_STREAM_READ = 0x88E1,
	GL_STREAM_COPY = 0x88E2,
	GL_STATIC_READ = 0x88E5,
	GL_STATIC_COPY = 0x88E6,
	GL_DYNAMIC_READ = 0x88E9,
	GL_DYNAMIC_COPY = 0x88EA,
	GL_MAX_DRAW_BUFFERS = 0x8824,
	GL_DRAW_BUFFER0 = 0x8825,
	GL_DRAW_BUFFER1 = 0x8826,
	GL_DRAW_BUFFER2 = 0x8827,
	GL_DRAW_BUFFER3 = 0x8828,
	GL_DRAW_BUFFER4 = 0x8829,
	GL_DRAW_BUFFER5 = 0x882A,
	GL_DRAW_BUFFER6 = 0x882B,
	GL_DRAW_BUFFER7 = 0x882C,
	GL_DRAW_BUFFER8 = 0x882D,
	GL_DRAW_BUFFER9 = 0x882E,
	GL_DRAW_BUFFER10 = 0x882F,
	GL_DRAW_BUFFER11 = 0x8830,
	GL_DRAW_BUFFER12 = 0x8831,
	GL_DRAW_BUFFER13 = 0x8832,
	GL_DRAW_BUFFER14 = 0x8833,
	GL_DRAW_BUFFER15 = 0x8834,
	GL_MAX_FRAGMENT_UNIFORM_COMPONENTS =0x8B49,
	GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A,
	GL_SAMPLER_3D = 0x8B5F,
	GL_SAMPLER_2D_SHADOW = 0x8B62,
	GL_FRAGMENT_SHADER_DERIVATIVE_HINT =0x8B8B,
	GL_PIXEL_PACK_BUFFER = 0x88EB,
	GL_PIXEL_UNPACK_BUFFER = 0x88EC,
	GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED,
	GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF,
	GL_FLOAT_MAT2x3 = 0x8B65,
	GL_FLOAT_MAT2x4 = 0x8B66,
	GL_FLOAT_MAT3x2 = 0x8B67,
	GL_FLOAT_MAT3x4 = 0x8B68,
	GL_FLOAT_MAT4x2 = 0x8B69,
	GL_FLOAT_MAT4x3 = 0x8B6A,
	GL_SRGB = 0x8C40,
	GL_SRGB8 = 0x8C41,
	GL_SRGB8_ALPHA8 = 0x8C43,
	GL_COMPARE_REF_TO_TEXTURE = 0x884E,
	GL_MAJOR_VERSION = 0x821B,
	GL_MINOR_VERSION = 0x821C,
	GL_NUM_EXTENSIONS = 0x821D,
	GL_RGBA32F = 0x8814,
	GL_RGB32F = 0x8815,
	GL_RGBA16F = 0x881A,
	GL_RGB16F = 0x881B,
	GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD,
	GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF,
	GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904,
	GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905,
	GL_MAX_VARYING_COMPONENTS = 0x8B4B,
	GL_TEXTURE_2D_ARRAY = 0x8C1A,
	GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D,
	GL_R11F_G11F_B10F = 0x8C3A,
	GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B,
	GL_RGB9_E5 = 0x8C3D,
	GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E,
	GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH =0x8C76,
	GL_TRANSFORM_FEEDBACK_BUFFER_MODE =0x8C7F,
	GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS =0x8C80,
	GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83,
	GL_TRANSFORM_FEEDBACK_BUFFER_START =0x8C84,
	GL_TRANSFORM_FEEDBACK_BUFFER_SIZE =0x8C85,
	GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN =0x8C88,
	GL_RASTERIZER_DISCARD = 0x8C89,
	GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS =0x8C8A,
	GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS =0x8C8B,
	GL_INTERLEAVED_ATTRIBS = 0x8C8C,
	GL_SEPARATE_ATTRIBS = 0x8C8D,
	GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E,
	GL_TRANSFORM_FEEDBACK_BUFFER_BINDING =0x8C8F,
	GL_RGBA32UI = 0x8D70,
	GL_RGB32UI = 0x8D71,
	GL_RGBA16UI = 0x8D76,
	GL_RGB16UI = 0x8D77,
	GL_RGBA8UI = 0x8D7C,
	GL_RGB8UI = 0x8D7D,
	GL_RGBA32I = 0x8D82,
	GL_RGB32I = 0x8D83,
	GL_RGBA16I = 0x8D88,
	GL_RGB16I = 0x8D89,
	GL_RGBA8I = 0x8D8E,
	GL_RGB8I = 0x8D8F,
	GL_RED_INTEGER = 0x8D94,
	GL_RGB_INTEGER = 0x8D98,
	GL_RGBA_INTEGER = 0x8D99,
	GL_SAMPLER_2D_ARRAY = 0x8DC1,
	GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4,
	GL_SAMPLER_CUBE_SHADOW = 0x8DC5,
	GL_UNSIGNED_INT_VEC2 = 0x8DC6,
	GL_UNSIGNED_INT_VEC3 = 0x8DC7,
	GL_UNSIGNED_INT_VEC4 = 0x8DC8,
	GL_INT_SAMPLER_2D = 0x8DCA,
	GL_INT_SAMPLER_3D = 0x8DCB,
	GL_INT_SAMPLER_CUBE = 0x8DCC,
	GL_INT_SAMPLER_2D_ARRAY = 0x8DCF,
	GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2,
	GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3,
	GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4,
	GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7,
	GL_BUFFER_ACCESS_FLAGS = 0x911F,
	GL_BUFFER_MAP_LENGTH = 0x9120,
	GL_BUFFER_MAP_OFFSET = 0x9121,
	GL_DEPTH_COMPONENT32F = 0x8CAC,
	GL_DEPTH32F_STENCIL8 = 0x8CAD,
	GL_FLOAT_32_UNSIGNED_INT_24_8_REV =0x8DAD,
	GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING =0x8210,
	GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE =0x8211,
	GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE =0x8212,
	GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE =0x8213,
	GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE =0x8214,
	GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE =0x8215,
	GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE =0x8216,
	GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE =0x8217,
	GL_FRAMEBUFFER_DEFAULT = 0x8218,
	GL_FRAMEBUFFER_UNDEFINED = 0x8219,
	GL_DEPTH_STENCIL_ATTACHMENT = 0x821A,
	GL_DEPTH_STENCIL = 0x84F9,
	GL_UNSIGNED_INT_24_8 = 0x84FA,
	GL_DEPTH24_STENCIL8 = 0x88F0,
	GL_UNSIGNED_NORMALIZED = 0x8C17,
	GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6,
	GL_READ_FRAMEBUFFER = 0x8CA8,
	GL_DRAW_FRAMEBUFFER = 0x8CA9,
	GL_READ_FRAMEBUFFER_BINDING = 0x8CAA,
	GL_RENDERBUFFER_SAMPLES = 0x8CAB,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER =0x8CD4,
	GL_MAX_COLOR_ATTACHMENTS = 0x8CDF,
	GL_COLOR_ATTACHMENT1 = 0x8CE1,
	GL_COLOR_ATTACHMENT2 = 0x8CE2,
	GL_COLOR_ATTACHMENT3 = 0x8CE3,
	GL_COLOR_ATTACHMENT4 = 0x8CE4,
	GL_COLOR_ATTACHMENT5 = 0x8CE5,
	GL_COLOR_ATTACHMENT6 = 0x8CE6,
	GL_COLOR_ATTACHMENT7 = 0x8CE7,
	GL_COLOR_ATTACHMENT8 = 0x8CE8,
	GL_COLOR_ATTACHMENT9 = 0x8CE9,
	GL_COLOR_ATTACHMENT10 = 0x8CEA,
	GL_COLOR_ATTACHMENT11 = 0x8CEB,
	GL_COLOR_ATTACHMENT12 = 0x8CEC,
	GL_COLOR_ATTACHMENT13 = 0x8CED,
	GL_COLOR_ATTACHMENT14 = 0x8CEE,
	GL_COLOR_ATTACHMENT15 = 0x8CEF,
	GL_COLOR_ATTACHMENT16 = 0x8CF0,
	GL_COLOR_ATTACHMENT17 = 0x8CF1,
	GL_COLOR_ATTACHMENT18 = 0x8CF2,
	GL_COLOR_ATTACHMENT19 = 0x8CF3,
	GL_COLOR_ATTACHMENT20 = 0x8CF4,
	GL_COLOR_ATTACHMENT21 = 0x8CF5,
	GL_COLOR_ATTACHMENT22 = 0x8CF6,
	GL_COLOR_ATTACHMENT23 = 0x8CF7,
	GL_COLOR_ATTACHMENT24 = 0x8CF8,
	GL_COLOR_ATTACHMENT25 = 0x8CF9,
	GL_COLOR_ATTACHMENT26 = 0x8CFA,
	GL_COLOR_ATTACHMENT27 = 0x8CFB,
	GL_COLOR_ATTACHMENT28 = 0x8CFC,
	GL_COLOR_ATTACHMENT29 = 0x8CFD,
	GL_COLOR_ATTACHMENT30 = 0x8CFE,
	GL_COLOR_ATTACHMENT31 = 0x8CFF,
	GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE =0x8D56,
	GL_MAX_SAMPLES = 0x8D57,
	GL_HALF_FLOAT = 0x140B,
	GL_MAP_READ_BIT = 0x0001,
	GL_MAP_WRITE_BIT = 0x0002,
	GL_MAP_INVALIDATE_RANGE_BIT = 0x0004,
	GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008,
	GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010,
	GL_MAP_UNSYNCHRONIZED_BIT = 0x0020,
	GL_RG = 0x8227,
	GL_RG_INTEGER = 0x8228,
	GL_R8 = 0x8229,
	GL_RG8 = 0x822B,
	GL_R16F = 0x822D,
	GL_R32F = 0x822E,
	GL_RG16F = 0x822F,
	GL_RG32F = 0x8230,
	GL_R8I = 0x8231,
	GL_R8UI = 0x8232,
	GL_R16I = 0x8233,
	GL_R16UI = 0x8234,
	GL_R32I = 0x8235,
	GL_R32UI = 0x8236,
	GL_RG8I = 0x8237,
	GL_RG8UI = 0x8238,
	GL_RG16I = 0x8239,
	GL_RG16UI = 0x823A,
	GL_RG32I = 0x823B,
	GL_RG32UI = 0x823C,
	GL_VERTEX_ARRAY_BINDING = 0x85B5,
	GL_R8_SNORM = 0x8F94,
	GL_RG8_SNORM = 0x8F95,
	GL_RGB8_SNORM = 0x8F96,
	GL_RGBA8_SNORM = 0x8F97,
	GL_SIGNED_NORMALIZED = 0x8F9C,
	GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69,
	GL_COPY_READ_BUFFER = 0x8F36,
	GL_COPY_WRITE_BUFFER = 0x8F37,
	GL_COPY_READ_BUFFER_BINDING = 0x8F36,
	GL_COPY_WRITE_BUFFER_BINDING = 0x8F37,
	GL_UNIFORM_BUFFER = 0x8A11,
	GL_UNIFORM_BUFFER_BINDING = 0x8A28,
	GL_UNIFORM_BUFFER_START = 0x8A29,
	GL_UNIFORM_BUFFER_SIZE = 0x8A2A,
	GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B,
	GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D,
	GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E,
	GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F,
	GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30,
	GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS =0x8A31,
	GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS =0x8A33,
	GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT =0x8A34,
	GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH =0x8A35,
	GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36,
	GL_UNIFORM_TYPE = 0x8A37,
	GL_UNIFORM_SIZE = 0x8A38,
	GL_UNIFORM_NAME_LENGTH = 0x8A39,
	GL_UNIFORM_BLOCK_INDEX = 0x8A3A,
	GL_UNIFORM_OFFSET = 0x8A3B,
	GL_UNIFORM_ARRAY_STRIDE = 0x8A3C,
	GL_UNIFORM_MATRIX_STRIDE = 0x8A3D,
	GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E,
	GL_UNIFORM_BLOCK_BINDING = 0x8A3F,
	GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40,
	GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41,
	GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42,
	GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES =0x8A43,
	GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER =0x8A44,
	GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER =0x8A46,
	GL_INVALID_INDEX = 0xFFFFFFFFu,
	GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122,
	GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125,
	GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111,
	GL_OBJECT_TYPE = 0x9112,
	GL_SYNC_CONDITION = 0x9113,
	GL_SYNC_STATUS = 0x9114,
	GL_SYNC_FLAGS = 0x9115,
	GL_SYNC_FENCE = 0x9116,
	GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117,
	GL_UNSIGNALED = 0x9118,
	GL_SIGNALED = 0x9119,
	GL_ALREADY_SIGNALED = 0x911A,
	GL_TIMEOUT_EXPIRED = 0x911B,
	GL_CONDITION_SATISFIED = 0x911C,
	GL_WAIT_FAILED = 0x911D,
	GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001,
	GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFFull,
	GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE,
	GL_ANY_SAMPLES_PASSED = 0x8C2F,
	GL_ANY_SAMPLES_PASSED_CONSERVATIVE =0x8D6A,
	GL_SAMPLER_BINDING = 0x8919,
	GL_RGB10_A2UI = 0x906F,
	GL_TEXTURE_SWIZZLE_R = 0x8E42,
	GL_TEXTURE_SWIZZLE_G = 0x8E43,
	GL_TEXTURE_SWIZZLE_B = 0x8E44,
	GL_TEXTURE_SWIZZLE_A = 0x8E45,
	GL_GREEN = 0x1904,
	GL_BLUE = 0x1905,
	GL_INT_2_10_10_10_REV = 0x8D9F,
	GL_TRANSFORM_FEEDBACK = 0x8E22,
	GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23,
	GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24,
	GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25,
	GL_PROGRAM_BINARY_RETRIEVABLE_HINT =0x8257,
	GL_PROGRAM_BINARY_LENGTH = 0x8741,
	GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE,
	GL_PROGRAM_BINARY_FORMATS = 0x87FF,
	GL_COMPRESSED_R11_EAC = 0x9270,
	GL_COMPRESSED_SIGNED_R11_EAC = 0x9271,
	GL_COMPRESSED_RG11_EAC = 0x9272,
	GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273,
	GL_COMPRESSED_RGB8_ETC2 = 0x9274,
	GL_COMPRESSED_SRGB8_ETC2 = 0x9275,
	GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 =0x9276,
	GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 =0x9277,
	GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278,
	GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC =0x9279,
	GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F,
	GL_MAX_ELEMENT_INDEX = 0x8D6B,
	GL_NUM_SAMPLE_COUNTS = 0x9380,
	GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF,
	GL_COMPUTE_SHADER = 0x91B9,
	GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB,
	GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS =0x91BC,
	GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD,
	GL_MAX_COMPUTE_SHARED_MEMORY_SIZE =0x8262,
	GL_MAX_COMPUTE_UNIFORM_COMPONENTS =0x8263,
	GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS =0x8264,
	GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265,
	GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS =0x8266,
	GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS =0x90EB,
	GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE,
	GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF,
	GL_COMPUTE_WORK_GROUP_SIZE = 0x8267,
	GL_DISPATCH_INDIRECT_BUFFER = 0x90EE,
	GL_DISPATCH_INDIRECT_BUFFER_BINDING =0x90EF,
	GL_COMPUTE_SHADER_BIT = 0x00000020,
	GL_DRAW_INDIRECT_BUFFER = 0x8F3F,
	GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43,
	GL_MAX_UNIFORM_LOCATIONS = 0x826E,
	GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310,
	GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311,
	GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313,
	GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS =0x9314,
	GL_MAX_FRAMEBUFFER_WIDTH = 0x9315,
	GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316,
	GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318,
	GL_UNIFORM = 0x92E1,
	GL_UNIFORM_BLOCK = 0x92E2,
	GL_PROGRAM_INPUT = 0x92E3,
	GL_PROGRAM_OUTPUT = 0x92E4,
	GL_BUFFER_VARIABLE = 0x92E5,
	GL_SHADER_STORAGE_BLOCK = 0x92E6,
	GL_ATOMIC_COUNTER_BUFFER = 0x92C0,
	GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4,
	GL_ACTIVE_RESOURCES = 0x92F5,
	GL_MAX_NAME_LENGTH = 0x92F6,
	GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7,
	GL_NAME_LENGTH = 0x92F9,
	GL_TYPE = 0x92FA,
	GL_ARRAY_SIZE = 0x92FB,
	GL_OFFSET = 0x92FC,
	GL_BLOCK_INDEX = 0x92FD,
	GL_ARRAY_STRIDE = 0x92FE,
	GL_MATRIX_STRIDE = 0x92FF,
	GL_IS_ROW_MAJOR = 0x9300,
	GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301,
	GL_BUFFER_BINDING = 0x9302,
	GL_BUFFER_DATA_SIZE = 0x9303,
	GL_NUM_ACTIVE_VARIABLES = 0x9304,
	GL_ACTIVE_VARIABLES = 0x9305,
	GL_REFERENCED_BY_VERTEX_SHADER = 0x9306,
	GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A,
	GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B,
	GL_TOP_LEVEL_ARRAY_SIZE = 0x930C,
	GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D,
	GL_LOCATION = 0x930E,
	GL_VERTEX_SHADER_BIT = 0x00000001,
	GL_FRAGMENT_SHADER_BIT = 0x00000002,
	GL_ALL_SHADER_BITS = 0xFFFFFFFF,
	GL_PROGRAM_SEPARABLE = 0x8258,
	GL_ACTIVE_PROGRAM = 0x8259,
	GL_PROGRAM_PIPELINE_BINDING = 0x825A,
	GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1,
	GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2,
	GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3,
	GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS =0x92CC,
	GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS =0x92D0,
	GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS =0x92D1,
	GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2,
	GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6,
	GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7,
	GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE =0x92D8,
	GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS =0x92DC,
	GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9,
	GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB,
	GL_MAX_IMAGE_UNITS = 0x8F38,
	GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA,
	GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE,
	GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF,
	GL_IMAGE_BINDING_NAME = 0x8F3A,
	GL_IMAGE_BINDING_LEVEL = 0x8F3B,
	GL_IMAGE_BINDING_LAYERED = 0x8F3C,
	GL_IMAGE_BINDING_LAYER = 0x8F3D,
	GL_IMAGE_BINDING_ACCESS = 0x8F3E,
	GL_IMAGE_BINDING_FORMAT = 0x906E,
	GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT =0x00000001,
	GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002,
	GL_UNIFORM_BARRIER_BIT = 0x00000004,
	GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008,
	GL_SHADER_IMAGE_ACCESS_BARRIER_BIT =0x00000020,
	GL_COMMAND_BARRIER_BIT = 0x00000040,
	GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080,
	GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100,
	GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200,
	GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400,
	GL_TRANSFORM_FEEDBACK_BARRIER_BIT =0x00000800,
	GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000,
	GL_ALL_BARRIER_BITS = 0xFFFFFFFF,
	GL_IMAGE_2D = 0x904D,
	GL_IMAGE_3D = 0x904E,
	GL_IMAGE_CUBE = 0x9050,
	GL_IMAGE_2D_ARRAY = 0x9053,
	GL_INT_IMAGE_2D = 0x9058,
	GL_INT_IMAGE_3D = 0x9059,
	GL_INT_IMAGE_CUBE = 0x905B,
	GL_INT_IMAGE_2D_ARRAY = 0x905E,
	GL_UNSIGNED_INT_IMAGE_2D = 0x9063,
	GL_UNSIGNED_INT_IMAGE_3D = 0x9064,
	GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066,
	GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069,
	GL_IMAGE_FORMAT_COMPATIBILITY_TYPE =0x90C7,
	GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE =0x90C8,
	GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS =0x90C9,
	GL_READ_ONLY = 0x88B8,
	GL_WRITE_ONLY = 0x88B9,
	GL_READ_WRITE = 0x88BA,
	GL_SHADER_STORAGE_BUFFER = 0x90D2,
	GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3,
	GL_SHADER_STORAGE_BUFFER_START = 0x90D4,
	GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5,
	GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS =0x90D6,
	GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS =0x90DA,
	GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS =0x90DB,
	GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS =0x90DC,
	GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS =0x90DD,
	GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE,
	GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT =0x90DF,
	GL_SHADER_STORAGE_BARRIER_BIT = 0x00002000,
	GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES =0x8F39,
	GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA,
	GL_STENCIL_INDEX = 0x1901,
	GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET =0x8E5E,
	GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET =0x8E5F,
	GL_SAMPLE_POSITION = 0x8E50,
	GL_SAMPLE_MASK = 0x8E51,
	GL_SAMPLE_MASK_VALUE = 0x8E52,
	GL_TEXTURE_2D_MULTISAMPLE = 0x9100,
	GL_MAX_SAMPLE_MASK_WORDS = 0x8E59,
	GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E,
	GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F,
	GL_MAX_INTEGER_SAMPLES = 0x9110,
	GL_TEXTURE_BINDING_2D_MULTISAMPLE =0x9104,
	GL_TEXTURE_SAMPLES = 0x9106,
	GL_TEXTURE_FIXED_SAMPLE_LOCATIONS =0x9107,
	GL_TEXTURE_WIDTH = 0x1000,
	GL_TEXTURE_HEIGHT = 0x1001,
	GL_TEXTURE_DEPTH = 0x8071,
	GL_TEXTURE_INTERNAL_FORMAT = 0x1003,
	GL_TEXTURE_RED_SIZE = 0x805C,
	GL_TEXTURE_GREEN_SIZE = 0x805D,
	GL_TEXTURE_BLUE_SIZE = 0x805E,
	GL_TEXTURE_ALPHA_SIZE = 0x805F,
	GL_TEXTURE_DEPTH_SIZE = 0x884A,
	GL_TEXTURE_STENCIL_SIZE = 0x88F1,
	GL_TEXTURE_SHARED_SIZE = 0x8C3F,
	GL_TEXTURE_RED_TYPE = 0x8C10,
	GL_TEXTURE_GREEN_TYPE = 0x8C11,
	GL_TEXTURE_BLUE_TYPE = 0x8C12,
	GL_TEXTURE_ALPHA_TYPE = 0x8C13,
	GL_TEXTURE_DEPTH_TYPE = 0x8C16,
	GL_TEXTURE_COMPRESSED = 0x86A1,
	GL_SAMPLER_2D_MULTISAMPLE = 0x9108,
	GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109,
	GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE =0x910A,
	GL_VERTEX_ATTRIB_BINDING = 0x82D4,
	GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5,
	GL_VERTEX_BINDING_DIVISOR = 0x82D6,
	GL_VERTEX_BINDING_OFFSET = 0x82D7,
	GL_VERTEX_BINDING_STRIDE = 0x82D8,
	GL_VERTEX_BINDING_BUFFER = 0x8F4F,
	GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET =0x82D9,
	GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA,
	GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5,
	GL_MULTISAMPLE_LINE_WIDTH_RANGE = 0x9381,
	GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY =0x9382,
	GL_MULTIPLY = 0x9294,
	GL_SCREEN = 0x9295,
	GL_OVERLAY = 0x9296,
	GL_DARKEN = 0x9297,
	GL_LIGHTEN = 0x9298,
	GL_COLORDODGE = 0x9299,
	GL_COLORBURN = 0x929A,
	GL_HARDLIGHT = 0x929B,
	GL_SOFTLIGHT = 0x929C,
	GL_DIFFERENCE = 0x929E,
	GL_EXCLUSION = 0x92A0,
	GL_HSL_HUE = 0x92AD,
	GL_HSL_SATURATION = 0x92AE,
	GL_HSL_COLOR = 0x92AF,
	GL_HSL_LUMINOSITY = 0x92B0,
	GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242,
	GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH =0x8243,
	GL_DEBUG_CALLBACK_FUNCTION = 0x8244,
	GL_DEBUG_CALLBACK_USER_PARAM = 0x8245,
	GL_DEBUG_SOURCE_API = 0x8246,
	GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247,
	GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248,
	GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249,
	GL_DEBUG_SOURCE_APPLICATION = 0x824A,
	GL_DEBUG_SOURCE_OTHER = 0x824B,
	GL_DEBUG_TYPE_ERROR = 0x824C,
	GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR =0x824D,
	GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E,
	GL_DEBUG_TYPE_PORTABILITY = 0x824F,
	GL_DEBUG_TYPE_PERFORMANCE = 0x8250,
	GL_DEBUG_TYPE_OTHER = 0x8251,
	GL_DEBUG_TYPE_MARKER = 0x8268,
	GL_DEBUG_TYPE_PUSH_GROUP = 0x8269,
	GL_DEBUG_TYPE_POP_GROUP = 0x826A,
	GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B,
	GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C,
	GL_DEBUG_GROUP_STACK_DEPTH = 0x826D,
	GL_BUFFER = 0x82E0,
	GL_SHADER = 0x82E1,
	GL_PROGRAM = 0x82E2,
	GL_VERTEX_ARRAY = 0x8074,
	GL_QUERY = 0x82E3,
	GL_PROGRAM_PIPELINE = 0x82E4,
	GL_SAMPLER = 0x82E6,
	GL_MAX_LABEL_LENGTH = 0x82E8,
	GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143,
	GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144,
	GL_DEBUG_LOGGED_MESSAGES = 0x9145,
	GL_DEBUG_SEVERITY_HIGH = 0x9146,
	GL_DEBUG_SEVERITY_MEDIUM = 0x9147,
	GL_DEBUG_SEVERITY_LOW = 0x9148,
	GL_DEBUG_OUTPUT = 0x92E0,
	GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002,
	GL_STACK_OVERFLOW = 0x0503,
	GL_STACK_UNDERFLOW = 0x0504,
	GL_GEOMETRY_SHADER = 0x8DD9,
	GL_GEOMETRY_SHADER_BIT = 0x00000004,
	GL_GEOMETRY_VERTICES_OUT = 0x8916,
	GL_GEOMETRY_INPUT_TYPE = 0x8917,
	GL_GEOMETRY_OUTPUT_TYPE = 0x8918,
	GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F,
	GL_LAYER_PROVOKING_VERTEX = 0x825E,
	GL_LINES_ADJACENCY = 0x000A,
	GL_LINE_STRIP_ADJACENCY = 0x000B,
	GL_TRIANGLES_ADJACENCY = 0x000C,
	GL_TRIANGLE_STRIP_ADJACENCY = 0x000D,
	GL_MAX_GEOMETRY_UNIFORM_COMPONENTS =0x8DDF,
	GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C,
	GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS =0x8A32,
	GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123,
	GL_MAX_GEOMETRY_OUTPUT_COMPONENTS =0x9124,
	GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0,
	GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS =0x8DE1,
	GL_MAX_GEOMETRY_SHADER_INVOCATIONS =0x8E5A,
	GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS =0x8C29,
	GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS =0x92CF,
	GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5,
	GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD,
	GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS =0x90D7,
	GL_FIRST_VERTEX_CONVENTION = 0x8E4D,
	GL_LAST_VERTEX_CONVENTION = 0x8E4E,
	GL_UNDEFINED_VERTEX = 0x8260,
	GL_PRIMITIVES_GENERATED = 0x8C87,
	GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312,
	GL_MAX_FRAMEBUFFER_LAYERS = 0x9317,
	GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS =0x8DA8,
	GL_FRAMEBUFFER_ATTACHMENT_LAYERED =0x8DA7,
	GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309,
	GL_PRIMITIVE_BOUNDING_BOX = 0x92BE,
	GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT =0x00000004,
	GL_CONTEXT_FLAGS = 0x821E,
	GL_LOSE_CONTEXT_ON_RESET = 0x8252,
	GL_GUILTY_CONTEXT_RESET = 0x8253,
	GL_INNOCENT_CONTEXT_RESET = 0x8254,
	GL_UNKNOWN_CONTEXT_RESET = 0x8255,
	GL_RESET_NOTIFICATION_STRATEGY = 0x8256,
	GL_NO_RESET_NOTIFICATION = 0x8261,
	GL_CONTEXT_LOST = 0x0507,
	GL_SAMPLE_SHADING = 0x8C36,
	GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37,
	GL_MIN_FRAGMENT_INTERPOLATION_OFFSET =0x8E5B,
	GL_MAX_FRAGMENT_INTERPOLATION_OFFSET =0x8E5C,
	GL_FRAGMENT_INTERPOLATION_OFFSET_BITS =0x8E5D,
	GL_PATCHES = 0x000E,
	GL_PATCH_VERTICES = 0x8E72,
	GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75,
	GL_TESS_GEN_MODE = 0x8E76,
	GL_TESS_GEN_SPACING = 0x8E77,
	GL_TESS_GEN_VERTEX_ORDER = 0x8E78,
	GL_TESS_GEN_POINT_MODE = 0x8E79,
	GL_ISOLINES = 0x8E7A,
	GL_QUADS = 0x0007,
	GL_FRACTIONAL_ODD = 0x8E7B,
	GL_FRACTIONAL_EVEN = 0x8E7C,
	GL_MAX_PATCH_VERTICES = 0x8E7D,
	GL_MAX_TESS_GEN_LEVEL = 0x8E7E,
	GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS =0x8E7F,
	GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS =0x8E80,
	GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS =0x8E81,
	GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS =0x8E82,
	GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS =0x8E83,
	GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84,
	GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS =0x8E85,
	GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS =0x8E86,
	GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS =0x8E89,
	GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS =0x8E8A,
	GL_MAX_TESS_CONTROL_INPUT_COMPONENTS =0x886C,
	GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS =0x886D,
	GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS =0x8E1E,
	GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS =0x8E1F,
	GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS =0x92CD,
	GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS =0x92CE,
	GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS =0x92D3,
	GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS =0x92D4,
	GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS =0x90CB,
	GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS =0x90CC,
	GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS =0x90D8,
	GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS =0x90D9,
	GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED =0x8221,
	GL_IS_PER_PATCH = 0x92E7,
	GL_REFERENCED_BY_TESS_CONTROL_SHADER =0x9307,
	GL_REFERENCED_BY_TESS_EVALUATION_SHADER =0x9308,
	GL_TESS_CONTROL_SHADER = 0x8E88,
	GL_TESS_EVALUATION_SHADER = 0x8E87,
	GL_TESS_CONTROL_SHADER_BIT = 0x00000008,
	GL_TESS_EVALUATION_SHADER_BIT = 0x00000010,
	GL_TEXTURE_BORDER_COLOR = 0x1004,
	GL_CLAMP_TO_BORDER = 0x812D,
	GL_TEXTURE_BUFFER = 0x8C2A,
	GL_TEXTURE_BUFFER_BINDING = 0x8C2A,
	GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B,
	GL_TEXTURE_BINDING_BUFFER = 0x8C2C,
	GL_TEXTURE_BUFFER_DATA_STORE_BINDING =0x8C2D,
	GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT =0x919F,
	GL_SAMPLER_BUFFER = 0x8DC2,
	GL_INT_SAMPLER_BUFFER = 0x8DD0,
	GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8,
	GL_IMAGE_BUFFER = 0x9051,
	GL_INT_IMAGE_BUFFER = 0x905C,
	GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067,
	GL_TEXTURE_BUFFER_OFFSET = 0x919D,
	GL_TEXTURE_BUFFER_SIZE = 0x919E,
	GL_COMPRESSED_RGBA_ASTC_4x4 = 0x93B0,
	GL_COMPRESSED_RGBA_ASTC_5x4 = 0x93B1,
	GL_COMPRESSED_RGBA_ASTC_5x5 = 0x93B2,
	GL_COMPRESSED_RGBA_ASTC_6x5 = 0x93B3,
	GL_COMPRESSED_RGBA_ASTC_6x6 = 0x93B4,
	GL_COMPRESSED_RGBA_ASTC_8x5 = 0x93B5,
	GL_COMPRESSED_RGBA_ASTC_8x6 = 0x93B6,
	GL_COMPRESSED_RGBA_ASTC_8x8 = 0x93B7,
	GL_COMPRESSED_RGBA_ASTC_10x5 = 0x93B8,
	GL_COMPRESSED_RGBA_ASTC_10x6 = 0x93B9,
	GL_COMPRESSED_RGBA_ASTC_10x8 = 0x93BA,
	GL_COMPRESSED_RGBA_ASTC_10x10 = 0x93BB,
	GL_COMPRESSED_RGBA_ASTC_12x10 = 0x93BC,
	GL_COMPRESSED_RGBA_ASTC_12x12 = 0x93BD,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 =0x93D0,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 =0x93D1,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 =0x93D2,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 =0x93D3,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 =0x93D4,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 =0x93D5,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 =0x93D6,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 =0x93D7,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 =0x93D8,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 =0x93D9,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 =0x93DA,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 =0x93DB,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 =0x93DC,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 =0x93DD,
	GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009,
	GL_TEXTURE_BINDING_CUBE_MAP_ARRAY =0x900A,
	GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C,
	GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D,
	GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E,
	GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY =0x900F,
	GL_IMAGE_CUBE_MAP_ARRAY = 0x9054,
	GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F,
	GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY =0x906A,
	GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102,
	GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY =0x9105,
	GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B,
	GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY =0x910C,
	GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY =0x910D,


#else


	// GL_VERSION_1_1
	// AttribMask
#ifndef GL_DEPTH_BUFFER_BIT
	GL_DEPTH_BUFFER_BIT = 0x00000100,
	GL_STENCIL_BUFFER_BIT = 0x00000400,
	GL_COLOR_BUFFER_BIT = 0x00004000,
#endif
	// Boolean
#ifndef GL_FALSE
	GL_FALSE = 0,
	GL_TRUE = 1,
#endif
	// BeginMode
#ifndef GL_POINTS
	GL_POINTS = 0x0000,
	GL_LINES = 0x0001,
	GL_LINE_LOOP = 0x0002,
	GL_LINE_STRIP = 0x0003,
	GL_TRIANGLES = 0x0004,
	GL_TRIANGLE_STRIP = 0x0005,
	GL_TRIANGLE_FAN = 0x0006,
#endif
	// AlphaFunction
#ifndef GL_NEVER
	GL_NEVER = 0x0200,
	GL_LESS = 0x0201,
	GL_EQUAL = 0x0202,
	GL_LEQUAL = 0x0203,
	GL_GREATER = 0x0204,
	GL_NOTEQUAL = 0x0205,
	GL_GEQUAL = 0x0206,
	GL_ALWAYS = 0x0207,
#endif
	// BlendingFactorDest
#ifndef GL_ZERO
	GL_ZERO = 0,
	GL_ONE = 1,
	GL_SRC_COLOR = 0x0300,
	GL_ONE_MINUS_SRC_COLOR = 0x0301,
	GL_SRC_ALPHA = 0x0302,
	GL_ONE_MINUS_SRC_ALPHA = 0x0303,
	GL_DST_ALPHA = 0x0304,
	GL_ONE_MINUS_DST_ALPHA = 0x0305,
#endif
	// BlendingFactorSrc
#ifndef GL_DST_COLOR
	GL_DST_COLOR = 0x0306,
	GL_ONE_MINUS_DST_COLOR = 0x0307,
	GL_SRC_ALPHA_SATURATE = 0x0308,
#endif
	// DrawBufferMode
#ifndef GL_NONE
	GL_NONE = 0,
	GL_FRONT_LEFT = 0x0400,
	GL_FRONT_RIGHT = 0x0401,
	GL_BACK_LEFT = 0x0402,
	GL_BACK_RIGHT = 0x0403,
#endif
#ifndef GL_FRONT
	GL_FRONT = 0x0404,
	GL_BACK = 0x0405,
#endif
#ifndef GL_LEFT
	GL_LEFT = 0x0406,
	GL_RIGHT = 0x0407,
#endif
#ifndef GL_FRONT_AND_BACK
	GL_FRONT_AND_BACK = 0x0408,
#endif
	// ErrorCode
#ifndef GL_NO_ERROR
	GL_NO_ERROR = 0,
	GL_INVALID_ENUM = 0x0500,
	GL_INVALID_VALUE = 0x0501,
	GL_INVALID_OPERATION = 0x0502,
	GL_OUT_OF_MEMORY = 0x0505,
#endif
	// FrontFaceDirection
#ifndef GL_CW
	GL_CW = 0x0900,
	GL_CCW = 0x0901,
#endif
	// GetPName
#ifndef GL_POINT_SIZE
	GL_POINT_SIZE = 0x0B11,
	GL_POINT_SIZE_RANGE = 0x0B12,
	GL_POINT_SIZE_GRANULARITY = 0x0B13,
	GL_LINE_SMOOTH = 0x0B20,
	GL_LINE_WIDTH = 0x0B21,
	GL_LINE_WIDTH_RANGE = 0x0B22,
	GL_LINE_WIDTH_GRANULARITY = 0x0B23,
	GL_POLYGON_SMOOTH = 0x0B41,
	GL_CULL_FACE = 0x0B44,
	GL_CULL_FACE_MODE = 0x0B45,
	GL_FRONT_FACE = 0x0B46,
	GL_DEPTH_RANGE = 0x0B70,
	GL_DEPTH_TEST = 0x0B71,
	GL_DEPTH_WRITEMASK = 0x0B72,
	GL_DEPTH_CLEAR_VALUE = 0x0B73,
	GL_DEPTH_FUNC = 0x0B74,
	GL_STENCIL_TEST = 0x0B90,
	GL_STENCIL_CLEAR_VALUE = 0x0B91,
	GL_STENCIL_FUNC = 0x0B92,
	GL_STENCIL_VALUE_MASK = 0x0B93,
	GL_STENCIL_FAIL = 0x0B94,
	GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95,
	GL_STENCIL_PASS_DEPTH_PASS = 0x0B96,
	GL_STENCIL_REF = 0x0B97,
	GL_STENCIL_WRITEMASK = 0x0B98,
	GL_VIEWPORT = 0x0BA2,
	GL_DITHER = 0x0BD0,
	GL_BLEND_DST = 0x0BE0,
	GL_BLEND_SRC = 0x0BE1,
	GL_BLEND = 0x0BE2,
	GL_LOGIC_OP_MODE = 0x0BF0,
	GL_COLOR_LOGIC_OP = 0x0BF2,
	GL_DRAW_BUFFER = 0x0C01,
	GL_READ_BUFFER = 0x0C02,
	GL_SCISSOR_BOX = 0x0C10,
	GL_SCISSOR_TEST = 0x0C11,
	GL_COLOR_CLEAR_VALUE = 0x0C22,
	GL_COLOR_WRITEMASK = 0x0C23,
	GL_DOUBLEBUFFER = 0x0C32,
	GL_STEREO = 0x0C33,
	GL_LINE_SMOOTH_HINT = 0x0C52,
	GL_POLYGON_SMOOTH_HINT = 0x0C53,
#endif
#ifndef GL_UNPACK_SWAP_BYTES
	GL_UNPACK_SWAP_BYTES = 0x0CF0,
	GL_UNPACK_LSB_FIRST = 0x0CF1,
	GL_UNPACK_ROW_LENGTH = 0x0CF2,
	GL_UNPACK_SKIP_ROWS = 0x0CF3,
	GL_UNPACK_SKIP_PIXELS = 0x0CF4,
#endif
#ifndef GL_UNPACK_ALIGNMENT
	GL_UNPACK_ALIGNMENT = 0x0CF5,
#endif

#ifndef GL_PACK_SWAP_BYTES
	GL_PACK_SWAP_BYTES = 0x0D00,
	GL_PACK_LSB_FIRST = 0x0D01,
#endif
#ifndef GL_PACK_ROW_LENGTH
	GL_PACK_ROW_LENGTH = 0x0D02,
	GL_PACK_SKIP_ROWS = 0x0D03,
	GL_PACK_SKIP_PIXELS = 0x0D04,

#endif
#ifndef GL_PACK_ALIGNMENT
	GL_PACK_ALIGNMENT = 0x0D05,
	GL_MAX_TEXTURE_SIZE = 0x0D33,
	GL_MAX_VIEWPORT_DIMS = 0x0D3A,
#endif

#ifndef GL_SUBCL_PIXEL_BITS
	GL_SUBCL_PIXEL_BITS = 0x0D50,
#endif

#ifndef GL_TEXTURE_1D
	GL_TEXTURE_1D = 0x0DE0,
#endif
#ifndef GL_TEXTURE_2D
	GL_TEXTURE_2D = 0x0DE1,
	GL_POLYGON_OFFSET_UNITS = 0x2A00,
	GL_POLYGON_OFFSET_POINT = 0x2A01,
	GL_POLYGON_OFFSET_LINE = 0x2A02,
	GL_POLYGON_OFFSET_FILL = 0x8037,
	GL_POLYGON_OFFSET_FACTOR = 0x8038,
#endif
#ifndef GL_TEXTURE_BINDING_1D
	GL_TEXTURE_BINDING_1D = 0x8068,
#endif
#ifndef GL_TEXTURE_BINDING_2D
	GL_TEXTURE_BINDING_2D = 0x8069,
#endif
	// GetTextureParameter
#ifndef GL_TEXTURE_WIDTH
	GL_TEXTURE_WIDTH = 0x1000,
	GL_TEXTURE_HEIGHT = 0x1001,
	GL_TEXTURE_INTERNAL_FORMAT = 0x1003,
	GL_TEXTURE_BORDER_COLOR = 0x1004,
	GL_TEXTURE_RED_SIZE = 0x805C,
	GL_TEXTURE_GREEN_SIZE = 0x805D,
	GL_TEXTURE_BLUE_SIZE = 0x805E,
	GL_TEXTURE_ALPHA_SIZE = 0x805F,
#endif
	// HintMode
#ifndef GL_DONT_CARE
	GL_DONT_CARE = 0x1100,
	GL_FASTEST = 0x1101,
	GL_NICEST = 0x1102,
#endif
	// DataType
#ifndef GL_BYTE
	GL_BYTE = 0x1400,
	GL_UNSIGNED_BYTE = 0x1401,
	GL_SHORT = 0x1402,
	GL_UNSIGNED_SHORT = 0x1403,
#endif
#ifndef GL_INT
	GL_INT = 0x1404,
	GL_UNSIGNED_INT = 0x1405,
#endif
#ifndef GL_FLOAT
	GL_FLOAT = 0x1406,
#endif
#ifndef GL_DOUBLE
	GL_DOUBLE = 0x140A,
#endif
	// ErrorCode
#ifndef GL_STACK_OVERFLOW
	GL_STACK_OVERFLOW = 0x0503,
	GL_STACK_UNDERFLOW = 0x0504,
#endif
	// LogicOp
#ifndef GL_CLEAR
	GL_CLEAR = 0x1500,
	GL_AND = 0x1501,
	GL_AND_REVERSE = 0x1502,
	GL_COPY = 0x1503,
	GL_AND_INVERTED = 0x1504,
	GL_NOOP = 0x1505,
	GL_XOR = 0x1506,
	GL_OR = 0x1507,
	GL_NOR = 0x1508,
	GL_EQUIV = 0x1509,
	GL_INVERT = 0x150A,
	GL_OR_REVERSE = 0x150B,
	GL_COPY_INVERTED = 0x150C,
	GL_OR_INVERTED = 0x150D,
	GL_NAND = 0x150E,
	GL_SET = 0x150F,
#endif
	// MatrixMode (for gl3.h, FBO attachment = type)
#ifndef GL_TEXTURE
	GL_TEXTURE = 0x1702,
#endif
	// PixelCopyType
#ifndef GL_COLOR
	GL_COLOR = 0x1800,
	GL_DEPTH = 0x1801,
	GL_STENCIL = 0x1802,
#endif
	// PixelFormat
#ifndef GL_STENCIL_INDEX
	GL_STENCIL_INDEX = 0x1901,
	GL_DEPTH_COMPONENT = 0x1902,
	GL_RED = 0x1903,
	GL_GREEN = 0x1904,
	GL_BLUE = 0x1905,
#endif

#ifndef GL_ALPHA
	GL_ALPHA = 0x1906,
	GL_RGB = 0x1907,
	GL_RGBA = 0x1908,
#endif
	// PolygonMode
#ifndef GL_POINT
	GL_POINT = 0x1B00,
	GL_LINE = 0x1B01,
	GL_FILL = 0x1B02,
#endif
	// StencilOp
#ifndef GL_KEEP
	GL_KEEP = 0x1E00,
	GL_REPLACE = 0x1E01,
	GL_INCR = 0x1E02,
	GL_DECR = 0x1E03,
#endif
	// StringName
#ifndef GL_VENDOR
	GL_VENDOR = 0x1F00,
	GL_RENDERER = 0x1F01,
	GL_VERSION = 0x1F02,
	GL_EXTENSIONS = 0x1F03,
#endif
	// TextureMagFilter
#ifndef GL_NEAREST
	GL_NEAREST = 0x2600,
	GL_LINEAR = 0x2601,
#endif
	// TextureMinFilter
#ifndef GL_NEAREST_MIPMAP_NEAREST
	GL_NEAREST_MIPMAP_NEAREST = 0x2700,
	GL_LINEAR_MIPMAP_NEAREST = 0x2701,
	GL_NEAREST_MIPMAP_LINEAR = 0x2702,
	GL_LINEAR_MIPMAP_LINEAR = 0x2703,
#endif
	// TextureParameterName
#ifndef GL_TEXTURE_MAG_FILTER
	GL_TEXTURE_MAG_FILTER = 0x2800,
	GL_TEXTURE_MIN_FILTER = 0x2801,
	GL_TEXTURE_WRAP_S = 0x2802,
	GL_TEXTURE_WRAP_T = 0x2803,
#endif
	// TextureTarget
#ifndef GL_PROXY_TEXTURE_1D
	GL_PROXY_TEXTURE_1D = 0x8063,
	GL_PROXY_TEXTURE_2D = 0x8064,
#endif
	// TextureWrapMode
#ifndef GL_REPEAT
	GL_REPEAT = 0x2901,
#endif
	// PixelInternalFormat
#ifndef GL_R3_G3_B2
	GL_R3_G3_B2 = 0x2A10,
	GL_RGB4 = 0x804F,
	GL_RGB5 = 0x8050,
	GL_RGB8 = 0x8051,
	GL_RGB10 = 0x8052,
	GL_RGB12 = 0x8053,
	GL_RGB16 = 0x8054,
	GL_RGBA2 = 0x8055,
	GL_RGBA4 = 0x8056,
	GL_RGB5_A1 = 0x8057,
	GL_RGBA8 = 0x8058,
	GL_RGB10_A2 = 0x8059,
	GL_RGBA12 = 0x805A,
	GL_RGBA16 = 0x805B,
#endif
	// GL_VERSION_1_2
#ifndef GL_UNSIGNED_BYTE_3_3_2
	GL_UNSIGNED_BYTE_3_3_2 = 0x8032,
#endif
#ifndef GL_UNSIGNED_SHORT_4_4_4_4
	GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033,
	GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034,
#endif
#ifndef GL_UNSIGNED_INT_8_8_8_8
	GL_UNSIGNED_INT_8_8_8_8 = 0x8035,
	GL_UNSIGNED_INT_10_10_10_2 = 0x8036,
	GL_TEXTURE_BINDING_3D = 0x806A,
	GL_PACK_SKIP_IMAGES = 0x806B,
	GL_PACK_IMAGE_HEIGHT = 0x806C,
	GL_UNPACK_SKIP_IMAGES = 0x806D,
	GL_UNPACK_IMAGE_HEIGHT = 0x806E,
	GL_TEXTURE_3D = 0x806F,
	GL_PROXY_TEXTURE_3D = 0x8070,
	GL_TEXTURE_DEPTH = 0x8071,
	GL_TEXTURE_WRAP_R = 0x8072,
	GL_MAX_3D_TEXTURE_SIZE = 0x8073,
	GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362,
#endif
#ifndef GL_UNSIGNED_SHORT_5_6_5
	GL_UNSIGNED_SHORT_5_6_5 = 0x8363,
	GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364,
	GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365,
	GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366,
	GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367,
	GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368,
#endif
#ifndef GL_BGR
	GL_BGR = 0x80E0,
	GL_BGRA = 0x80E1,
	GL_MAX_ELEMENTS_VERTICES = 0x80E8,
	GL_MAX_ELEMENTS_INDICES = 0x80E9,

#endif
#ifndef GL_CLAMP_TO_EDGE
	GL_CLAMP_TO_EDGE = 0x812F,
#endif
#ifndef GL_TEXTURE_MIN_LOD
	GL_TEXTURE_MIN_LOD = 0x813A,
	GL_TEXTURE_MAX_LOD = 0x813B,
	GL_TEXTURE_BASE_LEVEL = 0x813C,
	GL_TEXTURE_MAX_LEVEL = 0x813D,
#endif
#ifndef GL_SMOOTH_POINT_SIZE_RANGE
	GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12,
	GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13,
	GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22,
	GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23,
	GL_ALIASED_LINE_WIDTH_RANGE = 0x846E,
#endif
	// GL_ARB_imaging
#ifndef GL_CONSTANT_COLOR
	GL_CONSTANT_COLOR = 0x8001,
	GL_ONE_MINUS_CONSTANT_COLOR = 0x8002,
	GL_CONSTANT_ALPHA = 0x8003,
	GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004,
	GL_BLEND_COLOR = 0x8005,
	GL_FUNC_ADD = 0x8006,
	GL_MIN = 0x8007,
	GL_MAX = 0x8008,
	GL_BLEND_EQUATION = 0x8009,
	GL_FUNC_SUBTRACT = 0x800A,
	GL_FUNC_REVERSE_SUBTRACT = 0x800B,
#endif
	// GL_VERSION_1_3
#ifndef GL_TEXTURE0
	GL_TEXTURE0 = 0x84C0,
	GL_TEXTURE1 = 0x84C1,
	GL_TEXTURE2 = 0x84C2,
	GL_TEXTURE3 = 0x84C3,
	GL_TEXTURE4 = 0x84C4,
	GL_TEXTURE5 = 0x84C5,
	GL_TEXTURE6 = 0x84C6,
	GL_TEXTURE7 = 0x84C7,
	GL_TEXTURE8 = 0x84C8,
	GL_TEXTURE9 = 0x84C9,
	GL_TEXTURE10 = 0x84CA,
	GL_TEXTURE11 = 0x84CB,
	GL_TEXTURE12 = 0x84CC,
	GL_TEXTURE13 = 0x84CD,
	GL_TEXTURE14 = 0x84CE,
	GL_TEXTURE15 = 0x84CF,
	GL_TEXTURE16 = 0x84D0,
	GL_TEXTURE17 = 0x84D1,
	GL_TEXTURE18 = 0x84D2,
	GL_TEXTURE19 = 0x84D3,
	GL_TEXTURE20 = 0x84D4,
	GL_TEXTURE21 = 0x84D5,
	GL_TEXTURE22 = 0x84D6,
	GL_TEXTURE23 = 0x84D7,
	GL_TEXTURE24 = 0x84D8,
	GL_TEXTURE25 = 0x84D9,
	GL_TEXTURE26 = 0x84DA,
	GL_TEXTURE27 = 0x84DB,
	GL_TEXTURE28 = 0x84DC,
	GL_TEXTURE29 = 0x84DD,
	GL_TEXTURE30 = 0x84DE,
	GL_TEXTURE31 = 0x84DF,
	GL_ACTIVE_TEXTURE = 0x84E0,
	GL_MULTISAMPLE = 0x809D,
	GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E,
	GL_SAMPLE_ALPHA_TO_ONE = 0x809F,
	GL_SAMPLE_COVERAGE = 0x80A0,
	GL_SAMPLE_BUFFERS = 0x80A8,
	GL_SAMPLES = 0x80A9,
	GL_SAMPLE_COVERAGE_VALUE = 0x80AA,
	GL_SAMPLE_COVERAGE_INVERT = 0x80AB,
#endif
#ifndef GL_TEXTURE_CUBE_MAP
	GL_TEXTURE_CUBE_MAP = 0x8513,
	GL_TEXTURE_BINDING_CUBE_MAP = 0x8514,
#endif
#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_X
	GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516,
	GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518,
	GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519,
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A,
	GL_PROXY_TEXTURE_CUBE_MAP = 0x851B,
	GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C,
	GL_COMPRESSED_RGB = 0x84ED,
	GL_COMPRESSED_RGBA = 0x84EE,
	GL_TEXTURE_COMPRESSION_HINT = 0x84EF,
	GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0,
	GL_TEXTURE_COMPRESSED = 0x86A1,

#endif
#ifndef GL_NUM_COMPRESSED_TEXTURE_FORMATS
	GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2,
	GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3,
#endif
#ifndef GL_CLAMP_TO_BORDER
	GL_CLAMP_TO_BORDER = 0x812D,
#endif
	// GL_VERSION_1_4
#ifndef GL_BLEND_DST_RGB
	GL_BLEND_DST_RGB = 0x80C8,
	GL_BLEND_SRC_RGB = 0x80C9,
	GL_BLEND_DST_ALPHA = 0x80CA,
	GL_BLEND_SRC_ALPHA = 0x80CB,

#endif
#ifndef GL_POINT_FADE_THRESHOLD_SIZE
	GL_POINT_FADE_THRESHOLD_SIZE = 0x8128,
#endif
#ifndef GL_DEPTH_COMPONENT16
	GL_DEPTH_COMPONENT16 = 0x81A5,
	GL_DEPTH_COMPONENT24 = 0x81A6,
	GL_DEPTH_COMPONENT32 = 0x81A7,
	GL_MIRRORED_REPEAT = 0x8370,
	GL_MAX_TEXTURE_LOD_BIAS = 0x84FD,
	GL_TEXTURE_LOD_BIAS = 0x8501,
	GL_INCR_WRAP = 0x8507,
	GL_DECR_WRAP = 0x8508,
	GL_TEXTURE_DEPTH_SIZE = 0x884A,
	GL_TEXTURE_COMPARE_MODE = 0x884C,
	GL_TEXTURE_COMPARE_FUNC = 0x884D,
#endif
	// GL_VERSION_1_5
#ifndef GL_BUFFER_SIZE
	GL_BUFFER_SIZE = 0x8764,
	GL_BUFFER_USAGE = 0x8765,
	GL_QUERY_COUNTER_BITS = 0x8864,
	GL_CURRENT_QUERY = 0x8865,
#endif
#ifndef GL_QUERY_RESULT
	GL_QUERY_RESULT = 0x8866,
	GL_QUERY_RESULT_AVAILABLE = 0x8867,
#endif

#ifndef GL_ARRAY_BUFFER
	GL_ARRAY_BUFFER = 0x8892,
	GL_ELEMENT_ARRAY_BUFFER = 0x8893,
	GL_ARRAY_BUFFER_BINDING = 0x8894,
	GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895,
	GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F,
#endif
#ifndef GL_READ_ONLY
	GL_READ_ONLY = 0x88B8,
	GL_WRITE_ONLY = 0x88B9,
	GL_READ_WRITE = 0x88BA,
	GL_BUFFER_ACCESS = 0x88BB,
	GL_BUFFER_MAPPED = 0x88BC,
	GL_BUFFER_MAP_POINTER = 0x88BD,
#endif
#ifndef GL_STREAM_DRAW
	GL_STREAM_DRAW = 0x88E0,
	GL_STREAM_READ = 0x88E1,
	GL_STREAM_COPY = 0x88E2,
#endif
#ifndef GL_STATIC_DRAW
	GL_STATIC_DRAW = 0x88E4,
#endif
#ifndef GL_STATIC_READ
	GL_STATIC_READ = 0x88E5,
	GL_STATIC_COPY = 0x88E6,
#endif
#ifndef GL_DYNAMIC_DRAW
	GL_DYNAMIC_DRAW = 0x88E8,
#endif
#ifndef GL_DYNAMIC_READ
	GL_DYNAMIC_READ = 0x88E9,
	GL_DYNAMIC_COPY = 0x88EA,
	GL_SAMPLES_PASSED = 0x8914,
#endif
	// GL_VERSION_2_0
#ifndef GL_BLEND_EQUATION_RGB
	GL_BLEND_EQUATION_RGB = 0x8009,
	GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622,
	GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623,
	GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624,
	GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625,
	GL_CURRENT_VERTEX_ATTRIB = 0x8626,
	GL_VERTEX_PROGRAM_POINT_SIZE = 0x8642,
	GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645,
	GL_STENCIL_BACK_FUNC = 0x8800,
	GL_STENCIL_BACK_FAIL = 0x8801,
	GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802,
	GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803,
	GL_MAX_DRAW_BUFFERS = 0x8824,
	GL_DRAW_BUFFER0 = 0x8825,
	GL_DRAW_BUFFER1 = 0x8826,
	GL_DRAW_BUFFER2 = 0x8827,
	GL_DRAW_BUFFER3 = 0x8828,
	GL_DRAW_BUFFER4 = 0x8829,
	GL_DRAW_BUFFER5 = 0x882A,
	GL_DRAW_BUFFER6 = 0x882B,
	GL_DRAW_BUFFER7 = 0x882C,
	GL_DRAW_BUFFER8 = 0x882D,
	GL_DRAW_BUFFER9 = 0x882E,
	GL_DRAW_BUFFER10 = 0x882F,
	GL_DRAW_BUFFER11 = 0x8830,
	GL_DRAW_BUFFER12 = 0x8831,
	GL_DRAW_BUFFER13 = 0x8832,
	GL_DRAW_BUFFER14 = 0x8833,
	GL_DRAW_BUFFER15 = 0x8834,
	GL_BLEND_EQUATION_ALPHA = 0x883D,
	GL_MAX_VERTEX_ATTRIBS = 0x8869,
	GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A,
	GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872,
	GL_FRAGMENT_SHADER = 0x8B30,
	GL_VERTEX_SHADER = 0x8B31,
	GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49,
	GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A,
	GL_MAX_VARYING_FLOATS = 0x8B4B,
	GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C,
	GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D,
	GL_SHADER_TYPE = 0x8B4F,
	GL_FLOAT_VEC2 = 0x8B50,
	GL_FLOAT_VEC3 = 0x8B51,
	GL_FLOAT_VEC4 = 0x8B52,
	GL_INT_VEC2 = 0x8B53,
	GL_INT_VEC3 = 0x8B54,
	GL_INT_VEC4 = 0x8B55,
	GL_BOOL = 0x8B56,
	GL_BOOL_VEC2 = 0x8B57,
	GL_BOOL_VEC3 = 0x8B58,
	GL_BOOL_VEC4 = 0x8B59,
	GL_FLOAT_MAT2 = 0x8B5A,
	GL_FLOAT_MAT3 = 0x8B5B,
	GL_FLOAT_MAT4 = 0x8B5C,
	GL_SAMPLER_1D = 0x8B5D,
	GL_SAMPLER_2D = 0x8B5E,
	GL_SAMPLER_3D = 0x8B5F,
	GL_SAMPLER_CUBE = 0x8B60,
	GL_SAMPLER_1D_SHADOW = 0x8B61,
	GL_SAMPLER_2D_SHADOW = 0x8B62,
	GL_DELETE_STATUS = 0x8B80,
	GL_COMPILE_STATUS = 0x8B81,
	GL_LINK_STATUS = 0x8B82,
	GL_VALIDATE_STATUS = 0x8B83,
	GL_INFO_LOG_LENGTH = 0x8B84,
	GL_ATTACHED_SHADERS = 0x8B85,
	GL_ACTIVE_UNIFORMS = 0x8B86,
	GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87,
	GL_SHADER_SOURCE_LENGTH = 0x8B88,
	GL_ACTIVE_ATTRIBUTES = 0x8B89,
	GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A,
	GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B,
	GL_SHADING_LANGUAGE_VERSION = 0x8B8C,
	GL_CURRENT_PROGRAM = 0x8B8D,
	GL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0,
	GL_LOWER_LEFT = 0x8CA1,
	GL_UPPER_LEFT = 0x8CA2,
	GL_STENCIL_BACK_REF = 0x8CA3,
	GL_STENCIL_BACK_VALUE_MASK = 0x8CA4,
	GL_STENCIL_BACK_WRITEMASK = 0x8CA5,
#endif
	// GL_VERSION_2_1
#ifndef GL_PIXEL_PACK_BUFFER
	GL_PIXEL_PACK_BUFFER = 0x88EB,
	GL_PIXEL_UNPACK_BUFFER = 0x88EC,
	GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED,
	GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF,
#endif

#ifndef GL_FLOAT_MAT2x3
	GL_FLOAT_MAT2x3 = 0x8B65,
	GL_FLOAT_MAT2x4 = 0x8B66,
	GL_FLOAT_MAT3x2 = 0x8B67,
	GL_FLOAT_MAT3x4 = 0x8B68,
	GL_FLOAT_MAT4x2 = 0x8B69,
	GL_FLOAT_MAT4x3 = 0x8B6A,

	GL_SRGB = 0x8C40,
	GL_SRGB8 = 0x8C41,
	GL_SRGB_ALPHA = 0x8C42,
	GL_SRGB8_ALPHA8 = 0x8C43,
	GL_COMPRESSED_SRGB = 0x8C48,
	GL_COMPRESSED_SRGB_ALPHA = 0x8C49,
#endif

	// GL_VERSION_3_0
#ifndef GL_COMPARE_REF_TO_TEXTURE
	GL_COMPARE_REF_TO_TEXTURE = 0x884E,
	GL_CLIP_DISTANCE0 = 0x3000,
	GL_CLIP_DISTANCE1 = 0x3001,
	GL_CLIP_DISTANCE2 = 0x3002,
	GL_CLIP_DISTANCE3 = 0x3003,
	GL_CLIP_DISTANCE4 = 0x3004,
	GL_CLIP_DISTANCE5 = 0x3005,
	GL_CLIP_DISTANCE6 = 0x3006,
	GL_CLIP_DISTANCE7 = 0x3007,
	GL_MAX_CLIP_DISTANCES = 0x0D32,
	GL_MAJOR_VERSION = 0x821B,
	GL_MINOR_VERSION = 0x821C,
	GL_NUM_EXTENSIONS = 0x821D,
	GL_CONTEXT_FLAGS = 0x821E,
#if !defined(GL_ARB_texture_rg)
	GL_COMPRESSED_RED = 0x8225,
	GL_COMPRESSED_RG = 0x8226,
#endif
	GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x0001,
	GL_RGBA32F = 0x8814,
	GL_RGB32F = 0x8815,
	GL_RGBA16F = 0x881A,
	GL_RGB16F = 0x881B,
	GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD,
	GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF,
	GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904,
	GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905,
	GL_CLAMP_READ_COLOR = 0x891C,
	GL_FIXED_ONLY = 0x891D,
	GL_MAX_VARYING_COMPONENTS = 0x8B4B,
	GL_TEXTURE_1D_ARRAY = 0x8C18,
	GL_PROXY_TEXTURE_1D_ARRAY = 0x8C19,
	GL_TEXTURE_2D_ARRAY = 0x8C1A,
	GL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B,
	GL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C,
	GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D,
	GL_R11F_G11F_B10F = 0x8C3A,
	GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B,
	GL_RGB9_E5 = 0x8C3D,
	GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E,
	GL_TEXTURE_SHARED_SIZE = 0x8C3F,
	GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76,
	GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F,
	GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80,
	GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83,
	GL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84,
	GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85,
	GL_PRIMITIVES_GENERATED = 0x8C87,
	GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88,
	GL_RASTERIZER_DISCARD = 0x8C89,
	GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A,
	GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B,
	GL_INTERLEAVED_ATTRIBS = 0x8C8C,
	GL_SEPARATE_ATTRIBS = 0x8C8D,
	GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E,
	GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F,
	GL_RGBA32UI = 0x8D70,
	GL_RGB32UI = 0x8D71,
	GL_RGBA16UI = 0x8D76,
	GL_RGB16UI = 0x8D77,
	GL_RGBA8UI = 0x8D7C,
	GL_RGB8UI = 0x8D7D,
	GL_RGBA32I = 0x8D82,
	GL_RGB32I = 0x8D83,
	GL_RGBA16I = 0x8D88,
	GL_RGB16I = 0x8D89,
	GL_RGBA8I = 0x8D8E,
	GL_RGB8I = 0x8D8F,
	GL_RED_INTEGER = 0x8D94,
	GL_GREEN_INTEGER = 0x8D95,
	GL_BLUE_INTEGER = 0x8D96,
	GL_RGB_INTEGER = 0x8D98,
	GL_RGBA_INTEGER = 0x8D99,
	GL_BGR_INTEGER = 0x8D9A,
	GL_BGRA_INTEGER = 0x8D9B,
	GL_SAMPLER_1D_ARRAY = 0x8DC0,
	GL_SAMPLER_2D_ARRAY = 0x8DC1,
	GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3,
	GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4,
	GL_SAMPLER_CUBE_SHADOW = 0x8DC5,
	GL_UNSIGNED_INT_VEC2 = 0x8DC6,
	GL_UNSIGNED_INT_VEC3 = 0x8DC7,
	GL_UNSIGNED_INT_VEC4 = 0x8DC8,
	GL_INT_SAMPLER_1D = 0x8DC9,
	GL_INT_SAMPLER_2D = 0x8DCA,
	GL_INT_SAMPLER_3D = 0x8DCB,
	GL_INT_SAMPLER_CUBE = 0x8DCC,
	GL_INT_SAMPLER_1D_ARRAY = 0x8DCE,
	GL_INT_SAMPLER_2D_ARRAY = 0x8DCF,
	GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1,
	GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2,
	GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3,
	GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4,
	GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6,
	GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7,
	GL_QUERY_WAIT = 0x8E13,
	GL_QUERY_NO_WAIT = 0x8E14,
	GL_QUERY_BY_REGION_WAIT = 0x8E15,
	GL_QUERY_BY_REGION_NO_WAIT = 0x8E16,
	GL_BUFFER_ACCESS_FLAGS = 0x911F,
	GL_BUFFER_MAP_LENGTH = 0x9120,
	GL_BUFFER_MAP_OFFSET = 0x9121,
#endif
	// GL_VERSION_3_1
#ifndef GL_SAMPLER_2D_RECT
	GL_SAMPLER_2D_RECT = 0x8B63,
	GL_SAMPLER_2D_RECT_SHADOW = 0x8B64,
	GL_SAMPLER_BUFFER = 0x8DC2,
	GL_INT_SAMPLER_2D_RECT = 0x8DCD,
	GL_INT_SAMPLER_BUFFER = 0x8DD0,
	GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5,
	GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8,
	GL_TEXTURE_BUFFER = 0x8C2A,
	GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B,
	GL_TEXTURE_BINDING_BUFFER = 0x8C2C,
	GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D,
	GL_TEXTURE_BUFFER_FORMAT = 0x8C2E,
	GL_TEXTURE_RECTANGLE = 0x84F5,
	GL_TEXTURE_BINDING_RECTANGLE = 0x84F6,
	GL_PROXY_TEXTURE_RECTANGLE = 0x84F7,
	GL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8,
	GL_RED_SNORM = 0x8F90,
	GL_RG_SNORM = 0x8F91,
	GL_RGB_SNORM = 0x8F92,
	GL_RGBA_SNORM = 0x8F93,
	GL_R8_SNORM = 0x8F94,
	GL_RG8_SNORM = 0x8F95,
	GL_RGB8_SNORM = 0x8F96,
	GL_RGBA8_SNORM = 0x8F97,
	GL_R16_SNORM = 0x8F98,
	GL_RG16_SNORM = 0x8F99,
	GL_RGB16_SNORM = 0x8F9A,
	GL_RGBA16_SNORM = 0x8F9B,
	GL_SIGNED_NORMALIZED = 0x8F9C,
	GL_PRIMITIVE_RESTART = 0x8F9D,
	GL_PRIMITIVE_RESTART_INDEX = 0x8F9E,
#endif
	// GL_VERSION_3_2
#ifndef GL_CONTEXT_CORE_PROFILE_BIT
	GL_CONTEXT_CORE_PROFILE_BIT = 0x00000001,
	GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002,
	GL_LINES_ADJACENCY = 0x000A,
	GL_LINE_STRIP_ADJACENCY = 0x000B,
	GL_TRIANGLES_ADJACENCY = 0x000C,
	GL_TRIANGLE_STRIP_ADJACENCY = 0x000D,
	GL_PROGRAM_POINT_SIZE = 0x8642,
	GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29,
	GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7,
	GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8,
	GL_GEOMETRY_SHADER = 0x8DD9,
	GL_GEOMETRY_VERTICES_OUT = 0x8916,
	GL_GEOMETRY_INPUT_TYPE = 0x8917,
	GL_GEOMETRY_OUTPUT_TYPE = 0x8918,
	GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF,
	GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0,
	GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1,
	GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122,
	GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123,
	GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124,
	GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125,
	GL_CONTEXT_PROFILE_MASK = 0x9126,
	GL_TIMEOUT_EXPIRED = 0x911B,
#endif
	// GL_VERSION_3_3
#ifndef GL_VERTEX_ATTRIB_ARRAY_DIVISOR
	GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE,
#endif
	// GL_VERSION_4_0
#ifndef GL_SAMPLE_SHADING
	GL_SAMPLE_SHADING = 0x8C36,
	GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37,
	GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E,
	GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F,
	GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009,
	GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A,
	GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B,
	GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C,
	GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D,
	GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E,
	GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F,
#endif
	// GL_VERSION_4_3
#ifndef GL_NUM_SHADING_LANGUAGE_VERSIONS
	GL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9,
	GL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E,
#endif
	// GL_ARB_depth_buffer_float
#ifndef GL_DEPTH_COMPONENT32F
	GL_DEPTH_COMPONENT32F = 0x8CAC,
	GL_DEPTH32F_STENCIL8 = 0x8CAD,
	GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD,
#endif
	// GL_ARB_framebuffer_object
#ifndef GL_INVALID_FRAMEBUFFER_OPERATION
	GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506,
	GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210,
	GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211,
	GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212,
	GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213,
	GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214,
	GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215,
	GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216,
	GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217,
	GL_FRAMEBUFFER_DEFAULT = 0x8218,
	GL_FRAMEBUFFER_UNDEFINED = 0x8219,
	GL_DEPTH_STENCIL_ATTACHMENT = 0x821A,
	GL_MAX_RENDERBUFFER_SIZE = 0x84E8,
	GL_DEPTH_STENCIL = 0x84F9,
	GL_UNSIGNED_INT_24_8 = 0x84FA,
	GL_DEPTH24_STENCIL8 = 0x88F0,
	GL_TEXTURE_STENCIL_SIZE = 0x88F1,
	GL_TEXTURE_RED_TYPE = 0x8C10,
	GL_TEXTURE_GREEN_TYPE = 0x8C11,
	GL_TEXTURE_BLUE_TYPE = 0x8C12,
	GL_TEXTURE_ALPHA_TYPE = 0x8C13,
	GL_TEXTURE_DEPTH_TYPE = 0x8C16,
	GL_UNSIGNED_NORMALIZED = 0x8C17,
	GL_FRAMEBUFFER_BINDING = 0x8CA6,
	GL_DRAW_FRAMEBUFFER_BINDING = GL_FRAMEBUFFER_BINDING,
	GL_RENDERBUFFER_BINDING = 0x8CA7,
	GL_READ_FRAMEBUFFER = 0x8CA8,
	GL_DRAW_FRAMEBUFFER = 0x8CA9,
	GL_READ_FRAMEBUFFER_BINDING = 0x8CAA,
	GL_RENDERBUFFER_SAMPLES = 0x8CAB,
	GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0,
	GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3,
	GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4,
	GL_FRAMEBUFFER_COMPLETE = 0x8CD5,
	GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6,
	GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7,
	GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB,
	GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC,
	GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD,
	GL_MAX_COLOR_ATTACHMENTS = 0x8CDF,
	GL_COLOR_ATTACHMENT0 = 0x8CE0,
	GL_COLOR_ATTACHMENT1 = 0x8CE1,
	GL_COLOR_ATTACHMENT2 = 0x8CE2,
	GL_COLOR_ATTACHMENT3 = 0x8CE3,
	GL_COLOR_ATTACHMENT4 = 0x8CE4,
	GL_COLOR_ATTACHMENT5 = 0x8CE5,
	GL_COLOR_ATTACHMENT6 = 0x8CE6,
	GL_COLOR_ATTACHMENT7 = 0x8CE7,
	GL_COLOR_ATTACHMENT8 = 0x8CE8,
	GL_COLOR_ATTACHMENT9 = 0x8CE9,
	GL_COLOR_ATTACHMENT10 = 0x8CEA,
	GL_COLOR_ATTACHMENT11 = 0x8CEB,
	GL_COLOR_ATTACHMENT12 = 0x8CEC,
	GL_COLOR_ATTACHMENT13 = 0x8CED,
	GL_COLOR_ATTACHMENT14 = 0x8CEE,
	GL_COLOR_ATTACHMENT15 = 0x8CEF,
	GL_DEPTH_ATTACHMENT = 0x8D00,
	GL_STENCIL_ATTACHMENT = 0x8D20,
	GL_FRAMEBUFFER = 0x8D40,
	GL_RENDERBUFFER = 0x8D41,
	GL_RENDERBUFFER_WIDTH = 0x8D42,
	GL_RENDERBUFFER_HEIGHT = 0x8D43,
	GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44,
	GL_STENCIL_INDEX1 = 0x8D46,
	GL_STENCIL_INDEX4 = 0x8D47,
	GL_STENCIL_INDEX8 = 0x8D48,
	GL_STENCIL_INDEX16 = 0x8D49,
	GL_RENDERBUFFER_RED_SIZE = 0x8D50,
	GL_RENDERBUFFER_GREEN_SIZE = 0x8D51,
	GL_RENDERBUFFER_BLUE_SIZE = 0x8D52,
	GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53,
	GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54,
	GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55,
	GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56,
	GL_MAX_SAMPLES = 0x8D57,
#endif
	// GL_ARB_framebuffer_sRGB
#ifndef GL_FRAMEBUFFER_SRGB
	GL_FRAMEBUFFER_SRGB = 0x8DB9,
#endif
	// GL_ARB_half_float_vertex
#ifndef GL_HALF_FLOAT
	GL_HALF_FLOAT = 0x140B,
#endif
	// GL_ARB_map_buffer_range
#ifndef GL_MAP_READ_BIT
	GL_MAP_READ_BIT = 0x0001,
	GL_MAP_WRITE_BIT = 0x0002,
	GL_MAP_INVALIDATE_RANGE_BIT = 0x0004,
	GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008,
	GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010,
	GL_MAP_UNSYNCHRONIZED_BIT = 0x0020,
#endif
	// GL_ARB_texture_compression_rgtc
#ifndef GL_COMPRESSED_RED_RGTC1
	GL_COMPRESSED_RED_RGTC1 = 0x8DBB,
	GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC,
	GL_COMPRESSED_RG_RGTC2 = 0x8DBD,
	GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE,
#endif
	// GL_ARB_texture_rg
#ifndef GL_RG
	GL_RG = 0x8227,
	GL_RG_INTEGER = 0x8228,
	GL_R8 = 0x8229,
	GL_R16 = 0x822A,
	GL_RG8 = 0x822B,
	GL_RG16 = 0x822C,
	GL_R16F = 0x822D,
	GL_R32F = 0x822E,
	GL_RG16F = 0x822F,
	GL_RG32F = 0x8230,
	GL_R8I = 0x8231,
	GL_R8UI = 0x8232,
	GL_R16I = 0x8233,
	GL_R16UI = 0x8234,
	GL_R32I = 0x8235,
	GL_R32UI = 0x8236,
	GL_RG8I = 0x8237,
	GL_RG8UI = 0x8238,
	GL_RG16I = 0x8239,
	GL_RG16UI = 0x823A,
	GL_RG32I = 0x823B,
	GL_RG32UI = 0x823C,
#endif
	// GL_ARB_vertex_array_object
#ifndef GL_VERTEX_ARRAY_BINDING
	GL_VERTEX_ARRAY_BINDING = 0x85B5,
#endif
	// GL_ARB_uniform_buffer_object
#ifndef GL_UNIFORM_BUFFER
	GL_UNIFORM_BUFFER = 0x8A11,
	GL_UNIFORM_BUFFER_BINDING = 0x8A28,
	GL_UNIFORM_BUFFER_START = 0x8A29,
	GL_UNIFORM_BUFFER_SIZE = 0x8A2A,
	GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B,
	GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C,
	GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D,
	GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E,
	GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F,
	GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30,
	GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31,
	GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32,
	GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33,
	GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34,
	GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35,
	GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36,
	GL_UNIFORM_TYPE = 0x8A37,
	GL_UNIFORM_SIZE = 0x8A38,
	GL_UNIFORM_NAME_LENGTH = 0x8A39,
	GL_UNIFORM_BLOCK_INDEX = 0x8A3A,
	GL_UNIFORM_OFFSET = 0x8A3B,
	GL_UNIFORM_ARRAY_STRIDE = 0x8A3C,
	GL_UNIFORM_MATRIX_STRIDE = 0x8A3D,
	GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E,
	GL_UNIFORM_BLOCK_BINDING = 0x8A3F,
	GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40,
	GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41,
	GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42,
	GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43,
	GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44,
	GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45,
	GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46,
	GL_INVALID_INDEX = 0xFFFFFFFFu,
#endif
	// GL_ARB_copy_buffer
#ifndef GL_COPY_READ_BUFFER_BINDING
	GL_COPY_READ_BUFFER_BINDING = 0x8F36,
#endif
#ifndef GL_COPY_READ_BUFFER
	GL_COPY_READ_BUFFER = GL_COPY_READ_BUFFER_BINDING,
#endif
#ifndef GL_COPY_WRITE_BUFFER_BINDING
	GL_COPY_WRITE_BUFFER_BINDING = 0x8F37,
#endif
#ifndef GL_COPY_WRITE_BUFFER
	GL_COPY_WRITE_BUFFER = GL_COPY_WRITE_BUFFER_BINDING,
#endif
	// GL_ARB_depth_clamp
#ifndef GL_DEPTH_CLAMP
	GL_DEPTH_CLAMP = 0x864F,
#endif
	// GL_ARB_provoking_vertex
#ifndef GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION
	GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C,
	GL_FIRST_VERTEX_CONVENTION = 0x8E4D,
	GL_LAST_VERTEX_CONVENTION = 0x8E4E,
	GL_PROVOKING_VERTEX = 0x8E4F,
#endif
	// GL_ARB_seamless_cube_map
#ifndef GL_TEXTURE_CUBE_MAP_SEAMLESS
	GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F,
#endif
	// GL_ARB_sync
#ifndef GL_MAX_SERVER_WAIT_TIMEOUT
	GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111,
	GL_OBJECT_TYPE = 0x9112,
	GL_SYNC_CONDITION = 0x9113,
	GL_SYNC_STATUS = 0x9114,
	GL_SYNC_FLAGS = 0x9115,
	GL_SYNC_FENCE = 0x9116,
	GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117,
	GL_UNSIGNALED = 0x9118,
	GL_SIGNALED = 0x9119,
	GL_ALREADY_SIGNALED = 0x911A,
	GL_TIMEOUT_EXCL_PIRED = 0x911B,
	GL_CONDITION_SATISFIED = 0x911C,
	GL_WAIT_FAILED = 0x911D,
	GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001,
	GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFFull,
#endif
	// GL_ARB_texture_multisample
#ifndef GL_SAMPLE_POSITION
	GL_SAMPLE_POSITION = 0x8E50,
	GL_SAMPLE_MASK = 0x8E51,
	GL_SAMPLE_MASK_VALUE = 0x8E52,
	GL_MAX_SAMPLE_MASK_WORDS = 0x8E59,
	GL_TEXTURE_2D_MULTISAMPLE = 0x9100,
	GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101,
	GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102,
	GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103,
	GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104,
	GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105,
	GL_TEXTURE_SAMPLES = 0x9106,
	GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107,
	GL_SAMPLER_2D_MULTISAMPLE = 0x9108,
	GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109,
	GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A,
	GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B,
	GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C,
	GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D,
	GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E,
	GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F,
	GL_MAX_INTEGER_SAMPLES = 0x9110,
#endif
	// GL_ARB_sample_shading
#ifndef GL_SAMPLE_SHADING_ARB
	GL_SAMPLE_SHADING_ARB = 0x8C36,
	GL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37,
#endif
	// GL_ARB_texture_cube_map_array
#ifndef GL_TEXTURE_CUBE_MAP_ARRAY_ARB
	GL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009,
	GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A,
	GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B,
	GL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C,
	GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D,
	GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E,
	GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F,
#endif
	// GL_ARB_texture_gather
#ifndef GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB
	GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E,
	GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F,
#endif
	// GL_ARB_shading_language_include
#ifndef GL_SHADER_INCLUDE_ARB
	GL_SHADER_INCLUDE_ARB = 0x8DAE,
	GL_NAMED_STRING_LENGTH_ARB = 0x8DE9,
	GL_NAMED_STRING_TYPE_ARB = 0x8DEA,
#endif
	// GL_ARB_texture_compression_bptc
#ifndef GL_COMPRESSED_RGBA_BPTC_UNORM_ARB
	GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C,
	GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D,
	GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E,
	GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F,
#endif
	// GL_ARB_blend_func_extended
#ifndef GL_SRC1_COLOR
	GL_SRC1_COLOR = 0x88F9,
	GL_ONE_MINUS_SRC1_COLOR = 0x88FA,
	GL_ONE_MINUS_SRC1_ALPHA = 0x88FB,
	GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC,
#endif
	// GL_ARB_occlusion_query2
#ifndef GL_ANY_SAMPLES_PASSED
	GL_ANY_SAMPLES_PASSED = 0x8C2F,
#endif
	// GL_ARB_sampler_objects
#ifndef GL_SAMPLER_BINDING
	GL_SAMPLER_BINDING = 0x8919,
#endif
	// GL_ARB_texture_rgb10_a2ui
#ifndef GL_RGB10_A2UI
	GL_RGB10_A2UI = 0x906F,
#endif
	// GL_ARB_texture_swizzle
#ifndef GL_TEXTURE_SWIZZLE_R
	GL_TEXTURE_SWIZZLE_R = 0x8E42,
	GL_TEXTURE_SWIZZLE_G = 0x8E43,
	GL_TEXTURE_SWIZZLE_B = 0x8E44,
	GL_TEXTURE_SWIZZLE_A = 0x8E45,
	GL_TEXTURE_SWIZZLE_RGBA = 0x8E46,
#endif
	// GL_ARB_timer_query
#ifndef GL_TIME_ELAPSED
	GL_TIME_ELAPSED = 0x88BF,
	GL_TIMESTAMP = 0x8E28,
#endif
	// GL_ARB_vertex_type_2_10_10_10_rev
#ifndef GL_INT_2_10_10_10_REV
	GL_INT_2_10_10_10_REV = 0x8D9F,
#endif
	// GL_ARB_draw_indirect
#ifndef GL_DRAW_INDIRECT_BUFFER
	GL_DRAW_INDIRECT_BUFFER = 0x8F3F,
	GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43,
#endif
	// GL_ARB_gpu_shader5
#ifndef GL_GEOMETRY_SHADER_INVOCATIONS
	GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F,
	GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A,
	GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B,
	GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C,
	GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D,
#endif
	// GL_ARB_gpu_shader_fp64
#ifndef GL_DOUBLE_VEC2
	GL_DOUBLE_VEC2 = 0x8FFC,
	GL_DOUBLE_VEC3 = 0x8FFD,
	GL_DOUBLE_VEC4 = 0x8FFE,
	GL_DOUBLE_MAT2 = 0x8F46,
	GL_DOUBLE_MAT3 = 0x8F47,
	GL_DOUBLE_MAT4 = 0x8F48,
	GL_DOUBLE_MAT2x3 = 0x8F49,
	GL_DOUBLE_MAT2x4 = 0x8F4A,
	GL_DOUBLE_MAT3x2 = 0x8F4B,
	GL_DOUBLE_MAT3x4 = 0x8F4C,
	GL_DOUBLE_MAT4x2 = 0x8F4D,
	GL_DOUBLE_MAT4x3 = 0x8F4E,
#endif
	// GL_ARB_shader_subroutine
#ifndef GL_ACTIVE_SUBROUTINES
	GL_ACTIVE_SUBROUTINES = 0x8DE5,
	GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6,
	GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47,
	GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48,
	GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49,
	GL_MAX_SUBROUTINES = 0x8DE7,
	GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8,
	GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A,
	GL_COMPATIBLE_SUBROUTINES = 0x8E4B,
#endif
	// GL_ARB_tessellation_shader
#ifndef GL_PATCHES
	GL_PATCHES = 0x000E,
	GL_PATCH_VERTICES = 0x8E72,
	GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73,
	GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74,
	GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75,
	GL_TESS_GEN_MODE = 0x8E76,
	GL_TESS_GEN_SPACING = 0x8E77,
	GL_TESS_GEN_VERTEX_ORDER = 0x8E78,
	GL_TESS_GEN_POINT_MODE = 0x8E79,
	GL_ISOLINES = 0x8E7A,
	GL_FRACTIONAL_ODD = 0x8E7B,
	GL_FRACTIONAL_EVEN = 0x8E7C,
	GL_MAX_PATCH_VERTICES = 0x8E7D,
	GL_MAX_TESS_GEN_LEVEL = 0x8E7E,
	GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F,
	GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80,
	GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81,
	GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82,
	GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83,
	GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84,
	GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85,
	GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86,
	GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89,
	GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A,
	GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C,
	GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D,
	GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E,
	GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F,
	GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0,
	GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1,
	GL_TESS_EVALUATION_SHADER = 0x8E87,
	GL_TESS_CONTROL_SHADER = 0x8E88,
#endif
	// GL_ARB_transform_feedback2
#ifndef GL_TRANSFORM_FEEDBACK
	GL_TRANSFORM_FEEDBACK = 0x8E22,
	GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23,
	GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = GL_TRANSFORM_FEEDBACK_PAUSED,
	GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24,
	GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = GL_TRANSFORM_FEEDBACK_ACTIVE,
	GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25,
#endif
	// GL_ARB_transform_feedback3
#ifndef GL_MAX_TRANSFORM_FEEDBACK_BUFFERS
	GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70,
	GL_MAX_VERTEX_STREAMS = 0x8E71,
#endif
	// GL_ARB_ES2_compatibility
#ifndef GL_FIXED
	GL_FIXED = 0x140C,
	GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A,
	GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B,
	GL_LOW_FLOAT = 0x8DF0,
	GL_MEDIUM_FLOAT = 0x8DF1,
	GL_HIGH_FLOAT = 0x8DF2,
	GL_LOW_INT = 0x8DF3,
	GL_MEDIUM_INT = 0x8DF4,
	GL_HIGH_INT = 0x8DF5,
	GL_SHADER_COMPILER = 0x8DFA,
	GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9,
	GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB,
	GL_MAX_VARYING_VECTORS = 0x8DFC,
	GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD,
	GL_RGB565 = 0x8D62,
#endif
	// GL_ARB_get_program_binary
#ifndef GL_PROGRAM_BINARY_RETRIEVABLE_HINT
	GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257,
	GL_PROGRAM_BINARY_LENGTH = 0x8741,
	GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE,
	GL_PROGRAM_BINARY_FORMATS = 0x87FF,
#endif
	// GL_ARB_separate_shader_objects
#ifndef GL_VERTEX_SHADER_BIT
	GL_VERTEX_SHADER_BIT = 0x00000001,
	GL_FRAGMENT_SHADER_BIT = 0x00000002,
	GL_GEOMETRY_SHADER_BIT = 0x00000004,
	GL_TESS_CONTROL_SHADER_BIT = 0x00000008,
	GL_TESS_EVALUATION_SHADER_BIT = 0x00000010,
	GL_ALL_SHADER_BITS = 0xFFFFFFFF,
	GL_PROGRAM_SEPARABLE = 0x8258,
	GL_ACTIVE_PROGRAM = 0x8259,
	GL_PROGRAM_PIPELINE_BINDING = 0x825A,
#endif
	// GL_ARB_viewport_array
#ifndef GL_MAX_VIEWPORTS
	GL_MAX_VIEWPORTS = 0x825B,
	GL_VIEWPORT_SUBCL_PIXEL_BITS = 0x825C,
	GL_VIEWPORT_BOUNDS_RANGE = 0x825D,
	GL_LAYER_PROVOKING_VERTEX = 0x825E,
	GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F,
	GL_UNDEFINED_VERTEX = 0x8260,
#endif
	// GL_ARB_cl_event
#ifndef GL_SYNC_EVENT_ARB
	GL_SYNC_EVENT_ARB = 0x8240,
	GL_SYNC_EVENT_COMPLETE_ARB = 0x8241,
#endif
	// GL_ARB_debug_output
#ifndef GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB
	GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242,
	GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243,
	GL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244,
	GL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245,
	GL_DEBUG_SOURCE_CL_API_ARB = 0x8246,
	GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247,
	GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248,
	GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249,
	GL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A,
	GL_DEBUG_SOURCE_OTHER_ARB = 0x824B,
	GL_DEBUG_TYPE_ERROR_ARB = 0x824C,
	GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D,
	GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E,
	GL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F,
	GL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250,
	GL_DEBUG_TYPE_OTHER_ARB = 0x8251,
	GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143,
	GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144,
	GL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145,
	GL_DEBUG_SEVERITY_HIGH_ARB = 0x9146,
	GL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147,
	GL_DEBUG_SEVERITY_LOW_ARB = 0x9148,
#endif
	// GL_ARB_robustness
#ifndef GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB
	GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004,
	GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252,
	GL_GUILTY_CONTEXT_RESET_ARB = 0x8253,
	GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254,
	GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255,
	GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256,
	GL_NO_RESET_NOTIFICATION_ARB = 0x8261,
#endif
	// GL_ARB_compressed_texture_pixel_storage
#ifndef GL_UNPACK_COMPRESSED_BLOCK_WIDTH
	GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127,
	GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128,
	GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129,
	GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A,
	GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B,
	GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C,
	GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D,
	GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E,
#endif
	// GL_ARB_internalformat_query
#ifndef GL_NUM_SAMPLE_COUNTS
	GL_NUM_SAMPLE_COUNTS = 0x9380,
#endif
	// GL_ARB_map_buffer_alignment
#ifndef GL_MIN_MAP_BUFFER_ALIGNMENT
	GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC,
#endif
	// GL_ARB_shader_atomic_counters
#ifndef GL_ATOMIC_COUNTER_BUFFER
	GL_ATOMIC_COUNTER_BUFFER = 0x92C0,
	GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1,
	GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2,
	GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3,
	GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4,
	GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5,
	GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB,
	GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC,
	GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD,
	GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE,
	GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF,
	GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0,
	GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1,
	GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2,
	GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3,
	GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4,
	GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5,
	GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6,
	GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7,
	GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8,
	GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC,
	GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9,
	GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA,
	GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB,
#endif
	// GL_ARB_shader_image_load_store
#ifndef GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT
	GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001,
	GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002,
	GL_UNIFORM_BARRIER_BIT = 0x00000004,
	GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008,
	GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020,
	GL_COMMAND_BARRIER_BIT = 0x00000040,
	GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080,
	GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100,
	GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200,
	GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400,
	GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800,
	GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000,
	GL_ALL_BARRIER_BITS = 0xFFFFFFFF,
	GL_MAX_IMAGE_UNITS = 0x8F38,
	GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39,
	GL_IMAGE_BINDING_NAME = 0x8F3A,
	GL_IMAGE_BINDING_LEVEL = 0x8F3B,
	GL_IMAGE_BINDING_LAYERED = 0x8F3C,
	GL_IMAGE_BINDING_LAYER = 0x8F3D,
	GL_IMAGE_BINDING_ACCESS = 0x8F3E,
	GL_IMAGE_1D = 0x904C,
	GL_IMAGE_2D = 0x904D,
	GL_IMAGE_3D = 0x904E,
	GL_IMAGE_2D_RECT = 0x904F,
	GL_IMAGE_CUBE = 0x9050,
	GL_IMAGE_BUFFER = 0x9051,
	GL_IMAGE_1D_ARRAY = 0x9052,
	GL_IMAGE_2D_ARRAY = 0x9053,
	GL_IMAGE_CUBE_MAP_ARRAY = 0x9054,
	GL_IMAGE_2D_MULTISAMPLE = 0x9055,
	GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056,
	GL_INT_IMAGE_1D = 0x9057,
	GL_INT_IMAGE_2D = 0x9058,
	GL_INT_IMAGE_3D = 0x9059,
	GL_INT_IMAGE_2D_RECT = 0x905A,
	GL_INT_IMAGE_CUBE = 0x905B,
	GL_INT_IMAGE_BUFFER = 0x905C,
	GL_INT_IMAGE_1D_ARRAY = 0x905D,
	GL_INT_IMAGE_2D_ARRAY = 0x905E,
	GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F,
	GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060,
	GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061,
	GL_UNSIGNED_INT_IMAGE_1D = 0x9062,
	GL_UNSIGNED_INT_IMAGE_2D = 0x9063,
	GL_UNSIGNED_INT_IMAGE_3D = 0x9064,
	GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065,
	GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066,
	GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067,
	GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068,
	GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069,
	GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A,
	GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B,
	GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C,
	GL_MAX_IMAGE_SAMPLES = 0x906D,
	GL_IMAGE_BINDING_FORMAT = 0x906E,
	GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7,
	GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8,
	GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9,
	GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA,
	GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB,
	GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC,
	GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD,
	GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE,
	GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF,
#endif
	// GL_ARB_texture_storage
#ifndef GL_TEXTURE_IMMUTABLE_FORMAT
	GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F,
#endif
	// GL_KHR_texture_compression_astc_ldr
#ifndef GL_COMPRESSED_RGBA_ASTC_4x4_KHR
	GL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0,
	GL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1,
	GL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2,
	GL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3,
	GL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4,
	GL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5,
	GL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6,
	GL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7,
	GL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8,
	GL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9,
	GL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA,
	GL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB,
	GL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC,
	GL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC,
	GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD,
#endif
	// GL_KHR_debug
#ifndef GL_DEBUG_OUTPUT_SYNCHRONOUS
	GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242,
	GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243,
	GL_DEBUG_CALLBACK_FUNCTION = 0x8244,
	GL_DEBUG_CALLBACK_USER_PARAM = 0x8245,
	GL_DEBUG_SOURCE_API = 0x8246,
	GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247,
	GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248,
	GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249,
	GL_DEBUG_SOURCE_APPLICATION = 0x824A,
	GL_DEBUG_SOURCE_OTHER = 0x824B,
	GL_DEBUG_TYPE_ERROR = 0x824C,
	GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D,
	GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E,
	GL_DEBUG_TYPE_PORTABILITY = 0x824F,
	GL_DEBUG_TYPE_PERFORMANCE = 0x8250,
	GL_DEBUG_TYPE_OTHER = 0x8251,
	GL_DEBUG_TYPE_MARKER = 0x8268,
	GL_DEBUG_TYPE_PUSH_GROUP = 0x8269,
	GL_DEBUG_TYPE_POP_GROUP = 0x826A,
	GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B,
	GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C,
	GL_DEBUG_GROUP_STACK_DEPTH = 0x826D,
	GL_BUFFER = 0x82E0,
	GL_SHADER = 0x82E1,
	GL_PROGRAM = 0x82E2,
	GL_QUERY = 0x82E3,
	GL_PROGRAM_PIPELINE = 0x82E4,
#ifndef GL_SAMPLER
	GL_SAMPLER = 0x82E6,
#endif
	GL_DISPLAY_LIST = 0x82E7,
	GL_MAX_LABEL_LENGTH = 0x82E8,
	GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143,
	GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144,
	GL_DEBUG_LOGGED_MESSAGES = 0x9145,
	GL_DEBUG_SEVERITY_HIGH = 0x9146,
	GL_DEBUG_SEVERITY_MEDIUM = 0x9147,
	GL_DEBUG_SEVERITY_LOW = 0x9148,
	GL_DEBUG_OUTPUT = 0x92E0,
	GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002,
#endif
	// GL_ARB_compute_shader
#ifndef GL_COMPUTE_SHADER
	GL_COMPUTE_SHADER = 0x91B9,
	GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB,
	GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC,
	GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD,
	GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262,
	GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263,
	GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264,
	GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265,
	GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266,
	GL_MAX_COMPUTE_LOCAL_INVOCATIONS = 0x90EB,
	GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE,
	GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF,
	GL_COMPUTE_LOCAL_WORK_SIZE = 0x8267,
	GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC,
	GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED,
	GL_DISPATCH_INDIRECT_BUFFER = 0x90EE,
	GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF,
	GL_COMPUTE_SHADER_BIT = 0x00000020,
#endif
	// GL_ARB_ES3_compatibility
#ifndef GL_COMPRESSED_RGB8_ETC2
	GL_COMPRESSED_RGB8_ETC2 = 0x9274,
	GL_COMPRESSED_SRGB8_ETC2 = 0x9275,
	GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276,
	GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277,
	GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278,
	GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279,
	GL_COMPRESSED_R11_EAC = 0x9270,
	GL_COMPRESSED_SIGNED_R11_EAC = 0x9271,
	GL_COMPRESSED_RG11_EAC = 0x9272,
	GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273,
	GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69,
	GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A,
	GL_MAX_ELEMENT_INDEX = 0x8D6B,
#endif
	// GL_ARB_explicit_uniform_location
#ifndef GL_MAX_UNIFORM_LOCATIONS
	GL_MAX_UNIFORM_LOCATIONS = 0x826E,
#endif
	// GL_ARB_framebuffer_no_attachments
#ifndef GL_FRAMEBUFFER_DEFAULT_WIDTH
	GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310,
	GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311,
	GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312,
	GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313,
	GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314,
	GL_MAX_FRAMEBUFFER_WIDTH = 0x9315,
	GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316,
	GL_MAX_FRAMEBUFFER_LAYERS = 0x9317,
	GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318,
#endif
	// GL_ARB_internalformat_query2
#ifndef GL_INTERNALFORMAT_SUPPORTED
	GL_INTERNALFORMAT_SUPPORTED = 0x826F,
	GL_INTERNALFORMAT_PREFERRED = 0x8270,
	GL_INTERNALFORMAT_RED_SIZE = 0x8271,
	GL_INTERNALFORMAT_GREEN_SIZE = 0x8272,
	GL_INTERNALFORMAT_BLUE_SIZE = 0x8273,
	GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274,
	GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275,
	GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276,
	GL_INTERNALFORMAT_SHARED_SIZE = 0x8277,
	GL_INTERNALFORMAT_RED_TYPE = 0x8278,
	GL_INTERNALFORMAT_GREEN_TYPE = 0x8279,
	GL_INTERNALFORMAT_BLUE_TYPE = 0x827A,
	GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B,
	GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C,
	GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D,
	GL_MAX_WIDTH = 0x827E,
	GL_MAX_HEIGHT = 0x827F,
	GL_MAX_DEPTH = 0x8280,
	GL_MAX_LAYERS = 0x8281,
	GL_MAX_COMBINED_DIMENSIONS = 0x8282,
	GL_COLOR_COMPONENTS = 0x8283,
	GL_DEPTH_COMPONENTS = 0x8284,
	GL_STENCIL_COMPONENTS = 0x8285,
	GL_COLOR_RENDERABLE = 0x8286,
	GL_DEPTH_RENDERABLE = 0x8287,
	GL_STENCIL_RENDERABLE = 0x8288,
	GL_FRAMEBUFFER_RENDERABLE = 0x8289,
	GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A,
	GL_FRAMEBUFFER_BLEND = 0x828B,
	GL_READ_CL_PIXELS = 0x828C,
	GL_READ_CL_PIXELS_FORMAT = 0x828D,
	GL_READ_CL_PIXELS_TYPE = 0x828E,
	GL_TEXTURE_IMAGE_FORMAT = 0x828F,
	GL_TEXTURE_IMAGE_TYPE = 0x8290,
	GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291,
	GL_GET_TEXTURE_IMAGE_TYPE = 0x8292,
	GL_MIPMAP = 0x8293,
	GL_MANUAL_GENERATE_MIPMAP = 0x8294,
	GL_AUTO_GENERATE_MIPMAP = 0x8295,
	GL_COLOR_ENCODING = 0x8296,
	GL_SRGB_READ = 0x8297,
	GL_SRGB_WRITE = 0x8298,
	GL_SRGB_DECODE_ARB = 0x8299,
	GL_FILTER = 0x829A,
	GL_VERTEX_TEXTURE = 0x829B,
	GL_TESS_CONTROL_TEXTURE = 0x829C,
	GL_TESS_EVALUATION_TEXTURE = 0x829D,
	GL_GEOMETRY_TEXTURE = 0x829E,
	GL_FRAGMENT_TEXTURE = 0x829F,
	GL_COMPUTE_TEXTURE = 0x82A0,
	GL_TEXTURE_SHADOW = 0x82A1,
	GL_TEXTURE_GATHER = 0x82A2,
	GL_TEXTURE_GATHER_SHADOW = 0x82A3,
	GL_SHADER_IMAGE_LOAD = 0x82A4,
	GL_SHADER_IMAGE_STORE = 0x82A5,
	GL_SHADER_IMAGE_ATOMIC = 0x82A6,
	GL_IMAGE_TEXEL_SIZE = 0x82A7,
	GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8,
	GL_IMAGE_CL_PIXEL_FORMAT = 0x82A9,
	GL_IMAGE_CL_PIXEL_TYPE = 0x82AA,
	GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC,
	GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD,
	GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE,
	GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF,
	GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1,
	GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2,
	GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3,
	GL_CLEAR_BUFFER = 0x82B4,
	GL_TEXTURE_VIEW = 0x82B5,
	GL_VIEW_COMPATIBILITY_CLASS = 0x82B6,
	GL_FULL_SUPPORT = 0x82B7,
	GL_CAVEAT_SUPPORT = 0x82B8,
	GL_IMAGE_CLASS_4_X_32 = 0x82B9,
	GL_IMAGE_CLASS_2_X_32 = 0x82BA,
	GL_IMAGE_CLASS_1_X_32 = 0x82BB,
	GL_IMAGE_CLASS_4_X_16 = 0x82BC,
	GL_IMAGE_CLASS_2_X_16 = 0x82BD,
	GL_IMAGE_CLASS_1_X_16 = 0x82BE,
	GL_IMAGE_CLASS_4_X_8 = 0x82BF,
	GL_IMAGE_CLASS_2_X_8 = 0x82C0,
	GL_IMAGE_CLASS_1_X_8 = 0x82C1,
	GL_IMAGE_CLASS_11_11_10 = 0x82C2,
	GL_IMAGE_CLASS_10_10_10_2 = 0x82C3,
	GL_VIEW_CLASS_128_BITS = 0x82C4,
	GL_VIEW_CLASS_96_BITS = 0x82C5,
	GL_VIEW_CLASS_64_BITS = 0x82C6,
	GL_VIEW_CLASS_48_BITS = 0x82C7,
	GL_VIEW_CLASS_32_BITS = 0x82C8,
	GL_VIEW_CLASS_24_BITS = 0x82C9,
	GL_VIEW_CLASS_16_BITS = 0x82CA,
	GL_VIEW_CLASS_8_BITS = 0x82CB,
	GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC,
	GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD,
	GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE,
	GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF,
	GL_VIEW_CLASS_RGTC1_RED = 0x82D0,
	GL_VIEW_CLASS_RGTC2_RG = 0x82D1,
	GL_VIEW_CLASS_BPTC_UNORM = 0x82D2,
	GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3,
#endif
	// GL_ARB_program_interface_query
#ifndef GL_UNIFORM
	GL_UNIFORM = 0x92E1,
	GL_UNIFORM_BLOCK = 0x92E2,
	GL_PROGRAM_INPUT = 0x92E3,
	GL_PROGRAM_OUTPUT = 0x92E4,
	GL_BUFFER_VARIABLE = 0x92E5,
	GL_SHADER_STORAGE_BLOCK = 0x92E6,
	GL_VERTEX_SUBROUTINE = 0x92E8,
	GL_TESS_CONTROL_SUBROUTINE = 0x92E9,
	GL_TESS_EVALUATION_SUBROUTINE = 0x92EA,
	GL_GEOMETRY_SUBROUTINE = 0x92EB,
	GL_FRAGMENT_SUBROUTINE = 0x92EC,
	GL_COMPUTE_SUBROUTINE = 0x92ED,
	GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE,
	GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF,
	GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0,
	GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1,
	GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2,
	GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3,
	GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4,
	GL_ACTIVE_RESOURCES = 0x92F5,
	GL_MAX_NAME_LENGTH = 0x92F6,
	GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7,
	GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8,
	GL_NAME_LENGTH = 0x92F9,
	GL_TYPE = 0x92FA,
	GL_ARRAY_SIZE = 0x92FB,
	GL_OFFSET = 0x92FC,
	GL_BLOCK_INDEX = 0x92FD,
	GL_ARRAY_STRIDE = 0x92FE,
	GL_MATRIX_STRIDE = 0x92FF,
	GL_IS_ROW_MAJOR = 0x9300,
	GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301,
	GL_BUFFER_BINDING = 0x9302,
	GL_BUFFER_DATA_SIZE = 0x9303,
	GL_NUM_ACTIVE_VARIABLES = 0x9304,
	GL_ACTIVE_VARIABLES = 0x9305,
	GL_REFERENCED_BY_VERTEX_SHADER = 0x9306,
	GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307,
	GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308,
	GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309,
	GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A,
	GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B,
	GL_TOP_LEVEL_ARRAY_SIZE = 0x930C,
	GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D,
	GL_LOCATION = 0x930E,
	GL_LOCATION_INDEX = 0x930F,
	GL_IS_PER_PATCH = 0x92E7,
#endif
	// GL_ARB_shader_storage_buffer_object
#ifndef GL_SHADER_STORAGE_BUFFER
	GL_SHADER_STORAGE_BUFFER = 0x90D2,
	GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3,
	GL_SHADER_STORAGE_BUFFER_START = 0x90D4,
	GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5,
	GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6,
	GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7,
	GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8,
	GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9,
	GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA,
	GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB,
	GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC,
	GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD,
	GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE,
	GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF,
	GL_SHADER_STORAGE_BARRIER_BIT = 0x2000,
	GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS,
#endif
	// GL_ARB_stencil_texturing
#ifndef GL_DEPTH_STENCIL_TEXTURE_MODE
	GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA,
#endif
	// GL_ARB_texture_buffer_range
#ifndef GL_TEXTURE_BUFFER_OFFSET
	GL_TEXTURE_BUFFER_OFFSET = 0x919D,
	GL_TEXTURE_BUFFER_SIZE = 0x919E,
	GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F,
#endif
	// GL_ARB_texture_view
#ifndef GL_TEXTURE_VIEW_MIN_LEVEL
	GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB,
	GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC,
	GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD,
	GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE,
	GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF,
#endif
	// GL_ARB_vertex_attrib_binding
#ifndef GL_VERTEX_ATTRIB_BINDING
	GL_VERTEX_ATTRIB_BINDING = 0x82D4,
	GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5,
	GL_VERTEX_BINDING_DIVISOR = 0x82D6,
	GL_VERTEX_BINDING_OFFSET = 0x82D7,
	GL_VERTEX_BINDING_STRIDE = 0x82D8,
	GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9,
	GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA,

#endif

	// http://www.opengl.org/wiki/Ubiquitous_Extensions
	// EXT_texture_filter_anisotropic
#ifndef GL_TEXTURE_MAX_ANISOTROPY_EXT
	GL_TEXTURE_MAX_ANISOTROPY_EXT	= 0x84FE,
	GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF,
#endif


	// NOTE - NOT PART OF THE OPENGL 4.3 STANDARD HEADER FILES
#ifndef GL_COMPRESSED_RGB_S3TC_DXT1_EXT

	GL_COMPRESSED_RGB_S3TC_DXT1_EXT        = 0x83F0,
	GL_COMPRESSED_RGBA_S3TC_DXT1_EXT       = 0x83F1,
	GL_COMPRESSED_RGBA_S3TC_DXT3_EXT       = 0x83F2,
	GL_COMPRESSED_RGBA_S3TC_DXT5_EXT       = 0x83F3,

#endif

	// NOTE - NOT PART OF THE OPENGL 4.3 STANDARD HEADER FILES
#ifndef GL_SRGB_EXT
	GL_SRGB_EXT =  0x8C40,
	GL_SRGB8_EXT = 0x8C41,
	GL_SRGB_ALPHA_EXT =  0x8C42,
	GL_SRGB8_ALPHA8_EXT =  0x8C43,
	GL_SLUMINANCE_ALPHA_EXT =  0x8C44,
	GL_SLUMINANCE8_ALPHA8_EXT =  0x8C45,
	GL_SLUMINANCE_EXT =  0x8C46,
	GL_SLUMINANCE8_EXT = 0x8C47,
	GL_COMPRESSED_SRGB_EXT = 0x8C48,
	GL_COMPRESSED_SRGB_ALPHA_EXT = 0x8C49,
	GL_COMPRESSED_SLUMINANCE_EXT = 0x8C4A,
	GL_COMPRESSED_SLUMINANCE_ALPHA_EXT =  0x8C4B,
	GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C,
	GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT =  0x8C4D,
	GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT =  0x8C4E,
	GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT =  0x8C4F,
#endif

// OpenGL 4.4
#ifndef GL_MAX_VERTEX_ATTRIB_STRIDE
	GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5,
	GL_MAP_PERSISTENT_BIT = 0x0040,
	GL_MAP_COHERENT_BIT = 0x0080,
	GL_DYNAMIC_STORAGE_BIT = 0x0100,
	GL_CLIENT_STORAGE_BIT = 0x0200,
	GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000,
	GL_BUFFER_IMMUTABLE_STORAGE = 0x821F,
	GL_BUFFER_STORAGE_FLAGS = 0x8220,
	GL_CLEAR_TEXTURE = 0x9365,
	GL_LOCATION_COMPONENT = 0x934A,
	GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B,
	GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C,
	GL_QUERY_BUFFER = 0x9192,
	GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000,
	GL_QUERY_BUFFER_BINDING = 0x9193,
	GL_QUERY_RESULT_NO_WAIT = 0x9194,
	GL_MIRROR_CLAMP_TO_EDGE = 0x8743,
#endif

// OpenGL 4.5
#ifndef GL_CONTEXT_LOST
	GL_CONTEXT_LOST = 0x0507,
	GL_NEGATIVE_ONE_TO_ONE = 0x935E,
	GL_ZERO_TO_ONE = 0x935F,
	GL_CLIP_ORIGIN = 0x935C,
	GL_CLIP_DEPTH_MODE = 0x935D,
	GL_QUERY_WAIT_INVERTED = 0x8E17,
	GL_QUERY_NO_WAIT_INVERTED = 0x8E18,
	GL_QUERY_BY_REGION_WAIT_INVERTED = 0x8E19,
	GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 0x8E1A,
	GL_MAX_CULL_DISTANCES = 0x82F9,
	GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 0x82FA,
	GL_TEXTURE_TARGET = 0x1006,
	GL_QUERY_TARGET = 0x82EA,
	GL_GUILTY_CONTEXT_RESET = 0x8253,
	GL_INNOCENT_CONTEXT_RESET = 0x8254,
	GL_UNKNOWN_CONTEXT_RESET = 0x8255,
	GL_RESET_NOTIFICATION_STRATEGY = 0x8256,
	GL_LOSE_CONTEXT_ON_RESET = 0x8252,
	GL_NO_RESET_NOTIFICATION = 0x8261,
	GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 0x00000004,
	GL_CONTEXT_RELEASE_BEHAVIOR = 0x82FB,
	GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 0x82FC,
#endif

	// ***********************************************************
	// *** Legacy defines for ClanLib OpenGL 1.3 (GL1) support ***
#ifndef GL_COMPARE_R_TO_TEXTURE
	GL_COMPARE_R_TO_TEXTURE = 0x884e,
#endif
#ifndef GL_POINT_SPRITE
	GL_POINT_SPRITE = 0x8861,
#endif
#ifndef GL_MAX_TEXTURE_COORDS
	GL_MAX_TEXTURE_COORDS = 0x8871,
#endif
#ifndef GL_MAX_TEXTURE_UNITS
	GL_MAX_TEXTURE_UNITS = 0x84E2,
#endif

	// ***********************************************************

#endif
};

}

/// \}


