/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupPattern
extends BinaryPattern {
    GroupPattern(Pattern pattern, Pattern pattern2) {
        super(pattern.isNullable() && pattern2.isNullable(), GroupPattern.combineHashCode(13, pattern.hashCode(), pattern2.hashCode()), pattern, pattern2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p1.expand(schemaPatternBuilder);
        Pattern pattern2 = this.p2.expand(schemaPatternBuilder);
        if (pattern != this.p1 || pattern2 != this.p2) {
            return schemaPatternBuilder.makeGroup(pattern, pattern2);
        }
        return this;
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_group");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_group");
            }
        }
        super.checkRestrictions(n == 2 ? 3 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !GroupPattern.contentTypeGroupable(this.p1.getContentType(), this.p2.getContentType())) {
            throw new RestrictionViolationException("group_string");
        }
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseGroup(this);
    }
}

