/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class UriInfo
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _method = new QName("method");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private static final QName _username = new QName("username");
    private static final QName _password = new QName("password");
    private static final QName _auth_method = new QName("auth_method");
    private static final QName _send_authorization = new QName("send_authorization");
    protected static final QName c_uriinfo = new QName("c", "http://www.w3.org/ns/xproc-step", "uri-info");
    private static final QName _uri = new QName("uri");
    private static final QName _readable = new QName("readable");
    private static final QName _writable = new QName("writable");
    private static final QName _exists = new QName("exists");
    private static final QName _absolute = new QName("absolute");
    private static final QName _directory = new QName("directory");
    private static final QName _hidden = new QName("hidden");
    private static final QName _file = new QName("file");
    private static final QName _last_modified = new QName("last-modified");
    private static final QName _size = new QName("size");
    private static final QName _absolute_path = new QName("absolute-path");
    private static final QName _canonical_path = new QName("canonical-path");
    private WritablePipe result = null;

    public UriInfo(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_href);
        URI uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        this.finest(this.step.getNode(), "Checking uri-info for " + uRI);
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_uriinfo);
        if (uRI.getScheme().equals("file")) {
            Object object;
            String string = runtimeValue.getString();
            if (string.startsWith("file:") && (string = string.substring(5)).startsWith("///")) {
                string = string.substring(2);
            }
            File file = new File(string);
            treeWriter.addAttribute(_href, runtimeValue.getString());
            treeWriter.addAttribute(_exists, file.exists() ? "true" : "false");
            treeWriter.addAttribute(_readable, file.canRead() ? "true" : "false");
            if (file.exists()) {
                treeWriter.addAttribute(_writable, file.canWrite() ? "true" : "false");
                treeWriter.addAttribute(_size, "" + file.length());
                treeWriter.addAttribute(_absolute, file.isAbsolute() ? "true" : "false");
                treeWriter.addAttribute(_directory, file.isDirectory() ? "true" : "false");
                treeWriter.addAttribute(_hidden, file.isHidden() ? "true" : "false");
                treeWriter.addAttribute(_file, file.isFile() ? "true" : "false");
                object = new GregorianCalendar();
                ((Calendar)object).setTimeInMillis(file.lastModified());
                TimeZone timeZone = TimeZone.getDefault();
                long l = file.lastModified() - (long)timeZone.getRawOffset();
                if (timeZone.useDaylightTime() && timeZone.inDaylightTime(((Calendar)object).getTime())) {
                    l -= (long)timeZone.getDSTSavings();
                }
                ((Calendar)object).setTimeInMillis(l);
                treeWriter.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", ((Calendar)object).get(1), ((Calendar)object).get(2) + 1, ((Calendar)object).get(5), ((Calendar)object).get(11), ((Calendar)object).get(12), ((Calendar)object).get(13)));
            } else {
                object = file.getAbsolutePath();
                int n = ((String)object).lastIndexOf("/");
                File file2 = new File((String)(object = ((String)object).substring(0, n)));
                treeWriter.addAttribute(_writable, file2.canWrite() ? "true" : "false");
            }
            treeWriter.addAttribute(_absolute_path, file.getAbsolutePath());
            treeWriter.addAttribute(_uri, file.toURI().toASCIIString());
            try {
                object = file.getCanonicalPath();
                treeWriter.addAttribute(_canonical_path, (String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            treeWriter.startContent();
            treeWriter.addEndElement();
        } else {
            String[] stringArray;
            HttpRequest httpRequest = new HttpRequest(this.runtime, this.step);
            Pipe pipe = new Pipe(this.runtime);
            Pipe pipe2 = new Pipe(this.runtime);
            httpRequest.setInput("source", pipe);
            httpRequest.setOutput("result", pipe2);
            TreeWriter treeWriter2 = new TreeWriter(this.runtime);
            treeWriter2.startDocument(this.step.getNode().getBaseURI());
            treeWriter2.addStartElement(XProcConstants.c_request);
            treeWriter2.addAttribute(_method, "HEAD");
            treeWriter2.addAttribute(_href, uRI.toASCIIString());
            treeWriter2.addAttribute(_status_only, "true");
            treeWriter2.addAttribute(_detailed, "true");
            for (QName qName : new XdmNode[]{_username, _password, _auth_method, _send_authorization}) {
                stringArray = this.getOption(qName);
                if (stringArray == null) continue;
                treeWriter2.addAttribute(qName, stringArray.getString());
            }
            treeWriter2.startContent();
            treeWriter2.addEndElement();
            treeWriter2.endDocument();
            pipe.write(treeWriter2.getResult());
            httpRequest.run();
            XdmNode xdmNode = S9apiUtils.getDocumentElement(pipe2.read());
            int n = Integer.parseInt(xdmNode.getAttributeValue(_status));
            treeWriter.addAttribute(_href, runtimeValue.getString());
            treeWriter.addAttribute(_status, "" + n);
            treeWriter.addAttribute(_readable, n >= 200 && n < 400 ? "true" : "false");
            treeWriter.addAttribute(_exists, n >= 400 && n < 500 ? "false" : "true");
            treeWriter.addAttribute(_uri, uRI.toASCIIString());
            for (QName qName : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                if ("Last-Modified".equals(qName.getAttributeValue(_name))) {
                    stringArray = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String string = qName.getAttributeValue(_value);
                    String string2 = string.substring(5, 7);
                    String string3 = string.substring(8, 11).toUpperCase();
                    String string4 = string.substring(12, 16);
                    String string5 = string.substring(17, 25);
                    String string6 = string.substring(26, 29);
                    int n2 = 0;
                    for (n2 = 0; n2 < 12 && !stringArray[n2].equals(string3); ++n2) {
                    }
                    treeWriter.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$s%5$s", Integer.parseInt(string4), n2 + 1, Integer.parseInt(string2), string5, "GMT".equals(string6) ? "Z" : ""));
                }
                if (!"Content-Length".equals(qName.getAttributeValue(_name))) continue;
                treeWriter.addAttribute(_size, qName.getAttributeValue(_value));
            }
            treeWriter.startContent();
            for (QName qName : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                treeWriter.addSubtree((XdmNode)qName);
            }
            treeWriter.addEndElement();
        }
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

