/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.InternalSaxonError;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.TreeBuilder;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public final class FragmentValue
extends SingletonNodeSet {
    private char[] buffer = new char[4096];
    private int used = 0;
    private Vector events = new Vector(20);
    private String baseURI = null;
    private FragmentEmitter emitter = new FragmentEmitter();
    private Controller controller;
    private static AttributeCollection emptyAttributeCollection = new AttributeCollection((NamePool)null);
    private static Integer START_ELEMENT = new Integer(1);
    private static Integer END_ELEMENT = new Integer(2);
    private static Integer CHARACTERS = new Integer(5);
    private static Integer PROCESSING_INSTRUCTION = new Integer(6);
    private static Integer COMMENT = new Integer(7);
    private static Integer ESCAPING_ON = new Integer(8);
    private static Integer ESCAPING_OFF = new Integer(9);

    public FragmentValue(Controller controller) {
        this.controller = controller;
        this.generalUseAllowed = false;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public String asString() {
        return new String(this.buffer, 0, this.used);
    }

    public void outputStringValue(Outputter outputter, Context context) throws TransformerException {
        outputter.writeContent(this.buffer, 0, this.used);
    }

    public double asNumber() {
        return Value.stringToNumber(this.asString());
    }

    public boolean asBoolean() {
        return true;
    }

    public int getCount() {
        return 1;
    }

    public Expression simplify() {
        return this;
    }

    public NodeInfo getFirst() {
        return this.getRootNode();
    }

    public NodeEnumeration enumerate() throws XPathException {
        if (!this.generalUseAllowed) {
            throw new XPathException("Cannot process a result tree fragment as a node-set under XSLT 1.0");
        }
        return new SingletonEnumeration(this.getRootNode());
    }

    public boolean equals(Value value) throws XPathException {
        if (value instanceof StringValue) {
            return this.asString().equals(value.asString());
        }
        return new StringValue(this.asString()).equals(value);
    }

    public boolean notEquals(Value value) throws XPathException {
        return new StringValue(this.asString()).notEquals(value);
    }

    public boolean compare(int n, Value value) throws XPathException {
        return new StringValue(this.asString()).compare(n, value);
    }

    public int getType() {
        return 4;
    }

    public int getDataType() {
        return 4;
    }

    public DocumentInfo getRootNode() {
        if (this.node != null) {
            return (DocumentInfo)this.node;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setSystemId(this.baseURI);
            treeBuilder.setNamePool(this.controller.getNamePool());
            ((Emitter)treeBuilder).startDocument();
            this.replay(treeBuilder);
            ((Emitter)treeBuilder).endDocument();
            this.node = treeBuilder.getCurrentDocument();
            this.controller.getDocumentPool().add((DocumentInfo)this.node, null);
            return (DocumentInfo)this.node;
        }
        catch (TransformerException transformerException) {
            throw new InternalSaxonError("Error building temporary tree: " + transformerException.getMessage());
        }
    }

    public void copy(Outputter outputter) throws TransformerException {
        Emitter emitter = outputter.getEmitter();
        this.replay(emitter);
    }

    public void replay(Emitter emitter) throws TransformerException {
        Enumeration enumeration = this.events.elements();
        while (enumeration.hasMoreElements()) {
            Object e;
            Object e2;
            Object e3 = enumeration.nextElement();
            if (e3 == START_ELEMENT) {
                e2 = enumeration.nextElement();
                e = enumeration.nextElement();
                Object e4 = enumeration.nextElement();
                int[] nArray = (int[])e4;
                emitter.startElement((Integer)e2, (AttributeCollection)e, nArray, nArray.length);
                continue;
            }
            if (e3 == END_ELEMENT) {
                e2 = enumeration.nextElement();
                emitter.endElement((Integer)e2);
                continue;
            }
            if (e3 == CHARACTERS) {
                e2 = enumeration.nextElement();
                emitter.characters(this.buffer, ((int[])e2)[0], ((int[])e2)[1]);
                continue;
            }
            if (e3 == PROCESSING_INSTRUCTION) {
                e2 = enumeration.nextElement();
                e = enumeration.nextElement();
                emitter.processingInstruction((String)e2, (String)e);
                continue;
            }
            if (e3 == COMMENT) {
                e2 = enumeration.nextElement();
                emitter.comment(((String)e2).toCharArray(), 0, ((String)e2).length());
                continue;
            }
            if (e3 == ESCAPING_ON) {
                emitter.setEscaping(true);
                continue;
            }
            if (e3 == ESCAPING_OFF) {
                emitter.setEscaping(false);
                continue;
            }
            throw new InternalSaxonError("Corrupt data in temporary tree: " + e3);
        }
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "** result tree fragment **");
    }

    static /* synthetic */ char[] access$602(FragmentValue fragmentValue, char[] cArray) {
        fragmentValue.buffer = cArray;
        return cArray;
    }

    private class FragmentEmitter
    extends Emitter {
        boolean previousCharacters = false;

        private FragmentEmitter() {
        }

        public void startDocument() {
            this.previousCharacters = false;
        }

        public void endDocument() {
            this.previousCharacters = false;
        }

        public void startElement(int n, Attributes attributes, int[] nArray, int n2) {
            FragmentValue.this.events.addElement(START_ELEMENT);
            FragmentValue.this.events.addElement(new Integer(n));
            int n3 = attributes.getLength();
            AttributeCollection attributeCollection = n3 == 0 ? emptyAttributeCollection : new AttributeCollection((AttributeCollection)attributes);
            FragmentValue.this.events.addElement(attributeCollection);
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            FragmentValue.this.events.addElement(nArray2);
            this.previousCharacters = false;
        }

        public void endElement(int n) {
            FragmentValue.this.events.addElement(END_ELEMENT);
            FragmentValue.this.events.addElement(new Integer(n));
            this.previousCharacters = false;
        }

        public void characters(char[] cArray, int n, int n2) {
            Object[] objectArray;
            while (FragmentValue.this.used + n2 >= FragmentValue.this.buffer.length) {
                objectArray = new char[FragmentValue.this.buffer.length * 2];
                System.arraycopy(FragmentValue.this.buffer, 0, objectArray, 0, FragmentValue.this.used);
                FragmentValue.access$602(FragmentValue.this, objectArray);
            }
            System.arraycopy(cArray, n, FragmentValue.this.buffer, FragmentValue.this.used, n2);
            if (this.previousCharacters) {
                objectArray = (int[])FragmentValue.this.events.elementAt(FragmentValue.this.events.size() - 1);
                objectArray[1] = objectArray[1] + n2;
            } else {
                FragmentValue.this.events.addElement(CHARACTERS);
                objectArray = new int[]{FragmentValue.this.used, n2};
                FragmentValue.this.events.addElement(objectArray);
            }
            FragmentValue.this.used += n2;
            this.previousCharacters = true;
        }

        public void processingInstruction(String string, String string2) {
            FragmentValue.this.events.addElement(PROCESSING_INSTRUCTION);
            FragmentValue.this.events.addElement(string);
            FragmentValue.this.events.addElement(string2);
            this.previousCharacters = false;
        }

        public void comment(char[] cArray, int n, int n2) {
            FragmentValue.this.events.addElement(COMMENT);
            FragmentValue.this.events.addElement(new String(cArray, n, n2));
            this.previousCharacters = false;
        }

        public void setEscaping(boolean bl) throws TransformerException {
            FragmentValue.this.events.addElement(bl ? ESCAPING_ON : ESCAPING_OFF);
            this.previousCharacters = false;
        }
    }
}

