/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyClassMethod$PyExposer;
import org.python.core.PyMethod;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="classmethod", doc="classmethod(function) -> method\n\nConvert a function to be a class method.\n\nA class method receives the class as implicit first argument,\njust like an instance method receives the instance.\nTo declare a class method, use this idiom:\n\n  class C:\n      def f(cls, arg1, arg2, ...): ...\n      f = classmethod(f)\n\nIt can be called either on the class (e.g. C.f()) or on an instance\n(e.g. C().f()).  The instance is ignored except for its class.\nIf a class method is called for a derived class, the derived class\nobject is passed as the implied first argument.\n\nClass methods are different than C++ or Java static methods.\nIf you want those, see the staticmethod builtin.")
public class PyClassMethod
extends PyObject {
    public static final PyType TYPE;
    protected PyObject callable;

    public PyClassMethod(PyObject callable) {
        if (!callable.isCallable()) {
            throw Py.TypeError("'" + callable.getType().fastGetName() + "' object is not callable");
        }
        this.callable = callable;
    }

    @ExposedNew
    static final PyObject classmethod_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (keywords.length != 0) {
            throw Py.TypeError("classmethod does not accept keyword arguments");
        }
        if (args.length != 1) {
            throw Py.TypeError("classmethod expected 1 argument, got " + args.length);
        }
        return new PyClassMethod(args[0]);
    }

    public PyObject __get__(PyObject obj) {
        return this.classmethod___get__(obj, null);
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this.classmethod___get__(obj, type);
    }

    final PyObject classmethod___get__(PyObject obj, PyObject type) {
        if (type == null) {
            type = obj.getType();
        }
        return new PyMethod(this.callable, type, type.getType());
    }

    static {
        PyType.addBuilder(PyClassMethod.class, new PyClassMethod$PyExposer());
        TYPE = PyType.fromClass(PyClassMethod.class);
    }
}

