/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.CalloutEmitter;
import com.nwalsh.saxon.FormatCallout;
import com.nwalsh.saxon.FormatGraphicCallout;
import com.nwalsh.saxon.FormatTextCallout;
import com.nwalsh.saxon.FormatUnicodeCallout;
import com.nwalsh.saxon.LineCountEmitter;
import com.nwalsh.saxon.NumberLinesEmitter;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NodeList;

public class Verbatim {
    private static boolean foStylesheet = false;
    private static boolean xhStylesheet = false;
    private static int modulus = 0;
    private static int width = 0;
    private static int startinglinenumber = 1;
    private static String separator = "";
    private static boolean calloutsSetup = false;
    private static int defaultColumn = 60;
    private static String graphicsPath = null;
    private static String graphicsExt = null;
    private static int graphicsMax = 10;
    private static String iconSize = null;
    private static FormatCallout fCallout = null;

    protected static String getVariable(Context context, String varName) {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (TransformerException te) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    private static void setupLineNumbering(Context context) {
        modulus = 5;
        width = 3;
        startinglinenumber = 1;
        separator = " ";
        foStylesheet = false;
        String varString = null;
        varString = Verbatim.getVariable(context, "linenumbering.everyNth");
        try {
            modulus = Integer.parseInt(varString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("$linenumbering.everyNth is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "linenumbering.width");
        try {
            width = Integer.parseInt(varString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("$linenumbering.width is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "linenumbering.startinglinenumber");
        try {
            startinglinenumber = Integer.parseInt(varString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("$linenumbering.startinglinenumber is not a number: " + varString);
        }
        separator = varString = Verbatim.getVariable(context, "linenumbering.separator");
        varString = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
    }

    public static NodeSetValue numberLines(Context context, NodeSetValue rtf_ns) {
        FragmentValue rtf = (FragmentValue)rtf_ns;
        Verbatim.setupLineNumbering(context);
        try {
            LineCountEmitter lcEmitter = new LineCountEmitter();
            rtf.replay((Emitter)lcEmitter);
            int numLines = lcEmitter.lineCount();
            int listingModulus = numLines < modulus ? 1 : modulus;
            double log10numLines = Math.log(numLines) / Math.log(10.0);
            int listingWidth = (double)width < log10numLines + 1.0 ? (int)Math.floor(log10numLines + 1.0) : width;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            NumberLinesEmitter nlEmitter = new NumberLinesEmitter(controller, namePool, startinglinenumber, listingModulus, listingWidth, separator, foStylesheet);
            rtf.replay((Emitter)nlEmitter);
            return nlEmitter.getResultTreeFragment();
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in numberLines");
            return rtf;
        }
    }

    private static void setupCallouts(Context context) {
        NamePool namePool = context.getController().getNamePool();
        boolean useGraphics = false;
        boolean useUnicode = false;
        int unicodeStart = 49;
        int unicodeMax = 0;
        String unicodeFont = "";
        defaultColumn = 60;
        graphicsPath = null;
        graphicsExt = null;
        graphicsMax = 0;
        iconSize = "7pt";
        foStylesheet = false;
        xhStylesheet = false;
        calloutsSetup = true;
        Object variable = null;
        String varString = null;
        varString = Verbatim.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
        xhStylesheet = varString.equals("xhtml");
        varString = Verbatim.getVariable(context, "callout.defaultcolumn");
        try {
            defaultColumn = Integer.parseInt(varString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("$callout.defaultcolumn is not a number: " + varString);
        }
        varString = Verbatim.getVariable(context, "callout.graphics");
        useGraphics = !varString.equals("0") && !varString.equals("");
        varString = Verbatim.getVariable(context, "callout.unicode");
        boolean bl = useUnicode = !varString.equals("0") && !varString.equals("");
        if (useGraphics) {
            graphicsPath = varString = Verbatim.getVariable(context, "callout.graphics.path");
            graphicsExt = varString = Verbatim.getVariable(context, "callout.graphics.extension");
            varString = Verbatim.getVariable(context, "callout.graphics.number.limit");
            try {
                graphicsMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException nfe) {
                System.out.println("$callout.graphics.number.limit is not a number: " + varString);
                graphicsMax = 0;
            }
            if (foStylesheet) {
                iconSize = varString = Verbatim.getVariable(context, "callout.icon.size");
            }
            fCallout = new FormatGraphicCallout(namePool, graphicsPath, graphicsExt, graphicsMax, iconSize, foStylesheet, xhStylesheet);
        } else if (useUnicode) {
            varString = Verbatim.getVariable(context, "callout.unicode.start.character");
            try {
                unicodeStart = Integer.parseInt(varString);
            }
            catch (NumberFormatException nfe) {
                System.out.println("$callout.unicode.start.character is not a number: " + varString);
                unicodeStart = 48;
            }
            varString = Verbatim.getVariable(context, "callout.unicode.number.limit");
            try {
                unicodeMax = Integer.parseInt(varString);
            }
            catch (NumberFormatException nfe) {
                System.out.println("$callout.unicode.number.limit is not a number: " + varString);
                unicodeStart = 0;
            }
            unicodeFont = Verbatim.getVariable(context, "callout.unicode.font");
            if (unicodeFont == null) {
                unicodeFont = "";
            }
            fCallout = new FormatUnicodeCallout(namePool, unicodeFont, unicodeStart, unicodeMax, foStylesheet, xhStylesheet);
        } else {
            fCallout = new FormatTextCallout(namePool, foStylesheet, xhStylesheet);
        }
    }

    public static NodeSetValue insertCallouts(Context context, NodeList areaspecNodeList, NodeSetValue rtf_ns) {
        FragmentValue rtf = (FragmentValue)rtf_ns;
        Verbatim.setupCallouts(context);
        try {
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            CalloutEmitter cEmitter = new CalloutEmitter(controller, namePool, defaultColumn, foStylesheet, fCallout);
            cEmitter.setupCallouts(areaspecNodeList);
            rtf.replay((Emitter)cEmitter);
            return cEmitter.getResultTreeFragment();
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in insertCallouts");
            return rtf;
        }
    }
}

