/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Hashtable;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class AddAttribute
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _attribute_name = new QName("", "attribute-name");
    private static final QName _attribute_value = new QName("", "attribute-value");
    private static final QName _attribute_prefix = new QName("", "attribute-prefix");
    private static final QName _attribute_namespace = new QName("", "attribute-namespace");
    private QName attrName = null;
    private String attrValue = null;
    private ProcessMatch matcher = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public AddAttribute(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_attribute_name);
        String string = runtimeValue.getString();
        String string2 = this.getOption(_attribute_prefix, (String)null);
        String string3 = this.getOption(_attribute_namespace, (String)null);
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the attribute name contains a colon");
        }
        this.attrName = string.contains(":") ? new QName(string, runtimeValue.getNode()) : new QName(string2 == null ? "" : string2, string3, string);
        this.attrValue = this.getOption(_attribute_value).getString();
        if ("xmlns".equals(this.attrName.getLocalName()) || "xmlns".equals(this.attrName.getPrefix()) || "http://www.w3.org/2000/xmlns/".equals(this.attrName.getNamespaceURI()) || !"xml".equals(this.attrName.getPrefix()) && "http://www.w3.org/XML/1998/namespace".equals(this.attrName.getNamespaceURI()) || "xml".equals(this.attrName.getPrefix()) && !"http://www.w3.org/XML/1998/namespace".equals(this.attrName.getNamespaceURI())) {
            throw XProcException.stepError(59);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(13);
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(13);
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        Object object;
        QName qName;
        Hashtable<QName, String> hashtable = new Hashtable<QName, String>();
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
        while (xdmSequenceIterator.hasNext()) {
            qName = (XdmNode)xdmSequenceIterator.next();
            object = qName.getStringValue();
            if (qName.getNodeName().equals((Object)this.attrName)) continue;
            hashtable.put(qName.getNodeName(), (String)object);
        }
        qName = this.attrName;
        if (this.attrName.getNamespaceURI() != null && !"".equals(this.attrName.getNamespaceURI())) {
            object = this.attrName.getPrefix();
            for (Object object2 : hashtable.keySet()) {
                if (!((String)object).equals(object2.getPrefix()) || this.attrName.getNamespaceURI().equals(object2.getNamespaceURI())) continue;
                object = "";
            }
            if ("".equals(object)) {
                Object object2;
                int n = 0;
                object2 = "_0";
                boolean bl = false;
                while (!bl) {
                    object2 = "_" + ++n;
                    bl = true;
                    for (QName qName2 : hashtable.keySet()) {
                        if (!((String)object2).equals(qName2.getPrefix())) continue;
                        bl = false;
                    }
                }
                qName = new QName((String)object2, this.attrName.getNamespaceURI(), this.attrName.getLocalName());
            }
        }
        hashtable.put(qName, this.attrValue);
        this.matcher.addStartElement(xdmNode);
        for (QName qName3 : hashtable.keySet()) {
            this.matcher.addAttribute(qName3, (String)hashtable.get(qName3));
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }
}

