/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.util.HashSet;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.iter.NamespaceIterator;

public class NamespaceDelete
extends DefaultStep {
    private static final QName _prefixes = new QName("", "prefixes");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public NamespaceDelete(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        HashSet<String> excludeUris = this.readPrefixes(this.step.getNode(), this.getOption(_prefixes).getString());
        while (this.source.moreDocuments()) {
            XdmNode doc = this.source.read();
            this.runtime.finest(this, this.step.getNode(), "Namespace-delete step " + this.step.getName() + " read " + doc.getDocumentURI());
            doc = S9apiUtils.removeNamespaces(this.runtime, doc, excludeUris, false);
            this.result.write(doc);
        }
    }

    private HashSet<String> readPrefixes(XdmNode node, String prefixList) {
        HashSet<String> excludeURIs = new HashSet<String>();
        excludeURIs.add("http://www.w3.org/ns/xproc");
        if (prefixList != null) {
            NodeInfo inode = node.getUnderlyingNode();
            NamePool pool = inode.getNamePool();
            int[] inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            for (String pfx : prefixList.split("\\s+")) {
                boolean found = false;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    String nspfx = pool.getPrefixFromNamespaceCode(ns);
                    String nsuri = pool.getURIFromNamespaceCode(ns);
                    if (!pfx.equals(nspfx) && (!"#default".equals(pfx) || !"".equals(nspfx)) && !"#all".equals(pfx)) continue;
                    found = true;
                    excludeURIs.add(nsuri);
                }
                if (found) continue;
                throw new XProcException(XProcConstants.staticError(57), "No binding for '" + pfx + ":'");
            }
        }
        return excludeURIs;
    }
}

