// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/services/alerts/AlertsService',
    'hp/core/EventDispatcher'], 
function(service, EventDispatcher) {"use strict";

    var ActivityAlertPresenter = ( function() {

        /**
         * @constructor
         * @type {ActivityPresenter}
         */
        function ActivityAlertPresenter() {

            var dispatcher = new EventDispatcher();

            /**
             * @public
             */
            this.init = function () {
            };
            
            this.getAlert = function (uri, handlers) {
                service.getEventByUri(uri, handlers);
            };
            
            this.getEvent = function (uri, handlers) {
                service.getEventByUri(uri, handlers);
            };
            
            this.addNote = function (uri, note, handlers) {
                service.addAlertNote(uri, note, handlers);
            };
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new ActivityAlertPresenter();
    }());

    return ActivityAlertPresenter;
});
