// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST'],
function(REST) {"use strict";

    var ApplianceService = (function() {

        /**
         * @constructor Service for retrieval of appliance version information.
         */
        function ApplianceService() {

            /**
             * Retrieve appliance version information from the server.
             * 
             * @param {Object} handlers The success and error handler methods.
             */
            this.getVersion = function(handlers) {
                REST.getURI('/rest/appliance/version', handlers);
            };

        }

        return new ApplianceService();
        
    }());

    return ApplianceService;
    
});

