//(C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Notifications',
        'hp/core/Localizer',
        'fs/presenter/settings/NetworkSetupPresenter',
        'fs/presenter/settings/AppliancePresenter',
        'fs/presenter/settings/DateTimeSetupPresenter',
        'fs/presenter/welcome/WelcomePresenter',
        'hp/model/Session',
        'hp/lib/date',
        'lib/jquery.dateFormat',
        'hp/lib/jquery.hpTimestamp'],
function(notifications,
         localizer,
         networkSetupPresenter,
         appliancePresenter,
         dateTimeSetupPresenter,
         welcomePresenter,
         session) { "use strict";

    var ApplianceShowView = (function() {

        var VIEW = '#fs-settings-appliance-panel',
            HOSTNAME = '#fs-settings-appliance-overview-hostname',
            IPADDR = '#fs-settings-appliance-overview-ipaddr',
            VERSION = '#fs-settings-appliance-overview-version',
            MODEL = '#fs-settings-appliance-overview-model',
            DATETIME = '#fs-settings-appliance-overview-datetime',
            UPDATE = '#fs-settings-appliance-overview-update',
            ADD_NOTIFICATION = 'addNotification',
            MDASH = '&mdash;',
            UNSET = 'hp-unset';

        var CLASS_IPV6_DISABLE = '.fs-settings-ipv6-remove';
        var LAN_STATUS = "#fs-lan-status",
            LAN_VALUE = "#fs-lan-value",
            CPU_STATUS = "#fs-cpu-status",
            CPU_VALUE = "#fs-cpu-value",
            MEMORY_STATUS = "#fs-memory-status",
            MEMORY_VALUE = "#fs-memory-value",
            NETWORK_EDIT = "#cic-settings-network-edit";
 


        var CLASS_NODE_STATUS = '.fs-node-status',
            CLASS_NODE_FIELD_VALUE = '.fs-node-field-value'  ;

        var authCategory = "appliance";

        /**
         * @constructor View logic for the Appliance pane in the Settings Overview page.
         */
        function ApplianceShowView() {

            // Displays an error in the Notifications view.  This is done by posting
            // a jQuery event that bubbles up the element stack to the SettingsView,
            // which owns the notifications area.
            function showError(error) {
                $(VIEW).trigger(ADD_NOTIFICATION, [{
                    summary: error.errorMessage,
                    details: error.resolution,
                    status: 'error'
                 }, true ] );
            }

            // Display the network data (called when it is received from the server).
            function showNetworkData(networkObject) {
                // The hostname is optional.
                if (networkObject.hostname) {
                    $(HOSTNAME).text(networkObject.hostname).removeClass(UNSET);
                } else {
                    $(HOSTNAME).text(localizer.getString('core.common.notset'));
                }

                // We always show the IPv4 address.  For single node configurations,
                // we show the physical address of the node; for two-node configurations,
                // we show the cluster virtual address.
                var addr;
                if (!networkObject.confOneNode) {
                    addr = 'cluster';
                } else {
                    addr = 'node' + networkObject.localNodeID;
                }
                $(IPADDR).text(networkObject.addrs[addr].ipv4).removeClass(UNSET);
            }

            // Display the appliance version data (called when it is received from the server).
            function showApplianceVersion(data) {
                // Format and show the version number with date.
                var date = Date.parseISOString(data.date);
                date = $.format.date(date, 'MMM d, yyyy');
                // REVISIT:  Need to internationalize the date format.
                $(VERSION).text(data.softwareVersion + ', ' + date).removeClass(UNSET);
                $(UPDATE).show();

                // Show the hardware model, or "virtual machine".
                if (data.modelNumber) {
                    $(MODEL).text(data.modelNumber).removeClass(UNSET);
                } else if (data.platformType == 'vm') {
                    $(MODEL).text(localizer.getString('fs.settings.appliance.platform.vm')).removeClass(UNSET);
                } else if (data.hardwareModel) {
                    $(MODEL).text(data.hardwareModel).removeClass(UNSET);
                } else {
                    $(MODEL).text(localizer.getString('core.common.notset'));
                }
            }

            // Retrieve the hostname and IP address from the server.
            function getNetworkData() {
                $(HOSTNAME).html(MDASH).addClass(UNSET);
                $(IPADDR).html(MDASH).addClass(UNSET);
                networkSetupPresenter.getNetworkConfiguration({
                    success: showNetworkData,
                    error: showError
                });
            }

            // Retrieve the appliance software version and platform type from the server.
            function getApplianceData() {
                $(VERSION).html(MDASH).addClass(UNSET);
                $(MODEL).html(MDASH).addClass(UNSET);
                $(UPDATE).hide();
                appliancePresenter.getVersion({
                    success: showApplianceVersion,
                    error: showError
                });
            }
            // Display the date and time data (called when it is received from the server).
            function showDateTime(data) {
                var dateVal = dateTimeSetupPresenter.parseDateTime(data);
                dateVal = $.format.date(dateVal, 'MMM d, yyyy hh:mm a');
                $(DATETIME).text(dateVal).removeClass(UNSET);
            }
            function registerEvents() {
                dateTimeSetupPresenter.on("dateAndTimeChange", showDateTime);
            }
            //Retrieve the date and time from the server.
            function getDateTimeData() {
                $(DATETIME).html(MDASH).addClass(UNSET);
                dateTimeSetupPresenter.getDateTime();
            }
            // Display the date and time data (called when it is received from the server).


           function setStatus(field, minConfigMet){
                if (minConfigMet) {
                    $(field).addClass('hp-status-ok');
                } else {
                    $(field).addClass('hp-status-error');
                }
            }
            function showStatus(nodeStatus) {

                $(LAN_VALUE).text(nodeStatus.lan + " " + nodeStatus.lanUnits);
                setStatus(LAN_STATUS, welcomePresenter.isLANMinConfigMet(nodeStatus));
                $(CPU_VALUE).text(nodeStatus.cpu + " @ " + nodeStatus.cpuSpeed + " " + nodeStatus.cpuSpeedUnits);
                setStatus(CPU_STATUS, welcomePresenter.isCPUMinConfigMet(nodeStatus));
                $(MEMORY_VALUE).text(nodeStatus.memory + " " + nodeStatus.memoryUnits);
                setStatus(MEMORY_STATUS, welcomePresenter.isMemoryMinConfigMet(nodeStatus));
            }

            function handleRequestError() {
                $(CLASS_NODE_FIELD_VALUE).addClass('hp-unavailable');
                $(CLASS_NODE_STATUS).addClass('hp-status-unknown');
            }

            function getNodeStatus() {

               welcomePresenter.getNodeStatus({
                    success : function(nodeStatus) {
                        showStatus(nodeStatus);
                    },
                    error : function(errorInfo) {
                        handleRequestError();
                    }
                });
            }
            /**
             * Initialize the view by starting the data retrieval from the server.
             */
            this.init = this.resume = function() {
                if (networkSetupPresenter.iPv6Disabled()) {
                   $(CLASS_IPV6_DISABLE).remove();
                }
                $(NETWORK_EDIT).toggle(session.canManageCategory(authCategory));
                getNetworkData();
                getApplianceData();
                registerEvents();
                getDateTimeData();
                getNodeStatus();

            };
        }

        return new ApplianceShowView();

    }());

    return ApplianceShowView;

});
