// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['jquery'],
    function() {  "use strict";

    var LicenseMoreView = (function() {

        var WRITTEN_OFFER_LINK = "#fs-settings-license-writtenoffer";

        function LicenseMoreView() {

            function onLoadSupportSuccess(data, status, xhr) {
                var writtenOfferHtml = $(data).filter('#hp-eula-partner-content');
                writtenOfferHtml = $.trim(writtenOfferHtml.text());
                var lengthStr = writtenOfferHtml.length;
                if (lengthStr != 0) {
                    $(WRITTEN_OFFER_LINK).show();
                }
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
                $(WRITTEN_OFFER_LINK).hide();
            }

            function checkToDisplayWrittenOfferLink() {
               $.ajax({
                   url: '/ui-js/pages/fs/license/support_access_and_written_offer.html',
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }

            this.resume = function() {
                $(WRITTEN_OFFER_LINK).hide();
                checkToDisplayWrittenOfferLink();
            };
            
            this.init = function() {
                this.resume();
            };
    }

    return new LicenseMoreView();

  }());

  return LicenseMoreView;

});