// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['fs/view/status/StatusPager'],
function (pager) { "use strict";

    var StatusStatePages = ( function() {

        var CONTAINER = '#fs-status-details';

        function StatusStatePages() {

            var registered = false;
            
            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;
                
                pager.mapPageView('status starting', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/starting.html',
                            'fs/view/status/StatusStartingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status waiting', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/waiting.html',
                            'fs/view/status/StatusWaitingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status error', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/error.html',
                            'fs/view/status/StatusErrorView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status recovery', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/recovery.html',
                            'fs/view/status/StatusRecoveryView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status restore', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/restore.html',
                            'fs/view/status/StatusRestoreView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                pager.mapPageView('status restoreNoResetError', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/restoreNoResetError.html',
                            'fs/view/status/StatusRestoreNoResetErrorView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                pager.mapPageView('status reset', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/reset.html',
                            'fs/view/status/StatusResetView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                pager.mapPageView('status upgrade', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/upgrade.html',
                            'fs/view/status/StatusUpgradeView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status unavailable', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/unavailable.html',
                            'fs/view/status/StatusUnavailableView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status use floating', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/useFloating.html',
                            'fs/view/status/StatusUseFloatingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status default redirector', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!fsPages/status/waiting.html',
                            'fs/view/status/StatusWaitingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                pager.mapPageView('status no route', {
                    container: CONTAINER,
                    enter: function (result) {
                        require(['text!hpPages/core/no_details.html',
                                 'fs/view/status/StatusView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
            };
        }
        return new StatusStatePages();
    }());

    return StatusStatePages;
});
