// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {StatusState}
 *
 */
define([], function() { //"use strict";

    var StatusState = (function () {
        /**
         * @constructor
         */
        function StatusState() {

            // mapping from health status to health status string
            var HEALTH_STATUS_MAP = {
                // resources
                OK             : "ok",
                UNKNOWN        : "unknown",
                WARNING        : "warning",
                MAJOR          : "warning",
                CRITICAL       : "error",
                DISABLED       : "disabled",
                // mock resources
                ok             : "ok",
                unknown        : "unknown",
                warning        : "warning",
                critical       : "error",
                major          : "warning",
                error          : "error",
                disabled       : "disabled",
                // alerts
                Warning        : "warning",
                // tasks
                Unknown        : "unknown",
                New            : "unknown",
                Running        : "unknown",
                Suspended      : "disabled",
                Terminated     : "disabled",
                Killed         : "disabled",
                Completed      : "ok",
                Error          : "error",
                Warning        : "warning"
            };

            /**
             * Get appropriate hpStatus name for a given resource status.
             * @param healthStatus one of the health status names for a resource.
             *        Typically this are one of the values from hp.ci.mgmt.model.HealthStatus.java
             * @return the matching status name to use for jquery.hpStatus
             */
            this.getHealthStatus = function (healthStatus) {
                var status = "unknown";

                if (healthStatus && HEALTH_STATUS_MAP.hasOwnProperty(healthStatus)) {
                    status = HEALTH_STATUS_MAP[healthStatus];
                }
                return status;
            };
        }

        return new StatusState();
    }());

    return StatusState;

});