// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['jquery'], function() {
    (function($) {
        // jQuery plugin definition
        $.fn.hpUtilizationMeter = function(currentVal,minVal,maxVal,thresholdVal) {
          
            var instance;
            function hpUtilizationMeter(elem) {
                var valueBar,
                    thresholdBar;

                function validateValues(currentValue,minValue,maxValue){
                    return (currentValue >= minValue && currentValue <=maxValue);
                }
                function calculateValuePercentage(currentValue,minValue,maxValue){
                    return (currentValue - minValue)/(maxValue - minValue)*100;
                }
                function calculatePeakPixels(thresholdValue,minValue,maxValue,parentWidth){
                    var scale = parentWidth / 100;
                    return ((thresholdValue - minValue)/(maxValue - minValue)*100) * scale;
                }

                this.initialize = function (elem) {
                    $(elem).addClass('hp-utilization-meter hp-unset');
                    valueBar = $('<div></div>').addClass('hp-value-bar').css('width', '');
                    valueBar.append($('<div></div>').addClass('hp-value'));
                    thresholdBar = $('<div></div>').addClass('hp-threshold').css('width', '');
                    $(elem).append(valueBar);
                    $(elem).append(thresholdBar);
                };
                /*
                 * If the "currentValue" is greater than the "thresholdValue" the bar will 
                 * be colored in a shade of red, else it is a shade of blue
                 *
                 * currentValue - colored region on the meter(required)
                 * minValue- left end of the meter(required)
                 * maxValue- right end of the meter (required)
                 * thresholdValue - Vertical Line (optional)
                 */
                
                this.update = function (currentValue, minValue, maxValue, thresholdValue) {
                    var valuePercentage = 0,
                        thresholdPercentage;

                    if (validateValues(currentValue, minValue, maxValue)) {
                        $(elem).removeClass('hp-unset');
                        valuePercentage =
                            calculateValuePercentage(currentValue, minValue, maxValue);
                        if (typeof thresholdValue ==='number' && thresholdValue != 0){
                            var parentWidth = valueBar.parent().width();
                            thresholdPercentage =
                                  calculatePeakPixels(thresholdValue, minValue, maxValue, parentWidth);
                            if (currentValue < thresholdValue) {
                                valueBar.removeClass('hp-value-above');
                                thresholdBar.removeClass('hp-threshold-below');
                                if (thresholdValue <= maxValue) {
                                    valueBar.addClass('hp-value-below');
                                    thresholdBar.addClass('hp-threshold-above');
                                    $(elem).removeClass('hp-utilization-meter-extend');
                                } else {
                                    valueBar.removeClass('hp-value-below');
                                    thresholdBar.removeClass('hp-threshold-above');
                                    $(elem).addClass('hp-utilization-meter-extend');
                                }
                            } else {
                                valueBar.removeClass('hp-value-below');
                                valueBar.addClass('hp-value-above');
                                thresholdBar.addClass('hp-threshold-below');
                                thresholdBar.removeClass('hp-threshold-above');
                                $(elem).removeClass('hp-utilization-meter-extend');
                            }
                            thresholdBar.css('width', thresholdPercentage + 'px');
                        } else {
                            valueBar.removeClass('hp-value-above');
                            valueBar.removeClass('hp-value-below');
                            thresholdBar.removeClass('hp-threshold-above');
                            thresholdBar.removeClass('hp-threshold-below');
                            $(elem).removeClass('hp-utilization-meter-extend');
                        }
                        
                        valueBar.css('width', valuePercentage + '%');
                        if (currentValue == minValue) {
                            valueBar.addClass('hp-value-at-min');
                        } else {
                            valueBar.removeClass('hp-value-at-min');
                        }
                        if (currentValue == maxValue) {
                            valueBar.addClass('hp-value-at-max');
                        } else {
                            valueBar.removeClass('hp-value-at-max');
                        }
                    } else {
                        $(elem).addClass('hp-unset');
                    }
                };
            }

            if ( typeof currentVal === 'number' ) { 
                this.each(function() {
                    instance = $.data( this, 'hpUtilizationMeter' );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error( "cannot update hpUtilizationMeter prior to initialization;");
                        }
                        return;
                    }
                    // update
                    instance.update(currentVal,minVal,maxVal,thresholdVal);
                });  
            } else {
                // pluginify
                var ret;
                this.each(function() {
                    var $elem = $(this);
                    instance = new hpUtilizationMeter($elem[0]);
                    $.data(this, 'hpUtilizationMeter', instance);
                    instance.initialize($elem[0]);
                    ret = ret ? ret.add($elem) : $elem;
                });
                return ret;
            }
        };
    }(jQuery));
});
