// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hp/core/EventDispatcher',
    'fs/services/tasks/TasksService',
    'fs/services/alerts/AlertsService',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/model/DevelopmentSettings',
    'hp/services/Log'], 
function(EventDispatcher, tasksService, alertsService, router, urlFragment, settings, log) {"use strict";

    var NotificationsPresenter = ( function() {

        /**
         * @constructor
         * @type {NotificationsPresenter}
         */
        function NotificationsPresenter() {

            var dispatcher = new EventDispatcher();
            var timer = null;
            var resource;
            var notifications;
            
            function sortNotifications(a, b) {
                // sort first by severity, then by timestamp
                // TODO: sort tasks correctly
                if (true || a.status === b.status) {
                    return ((a.timestamp > b.timestamp) ? -1 :
                        ((a.timestamp < b.timestamp) ? 1 : 0));
                } /* else {
                    if (a.status === 'error') return -1;
                    if (b.status === 'error') return 1;
                    if (a.status === 'warning') return -1;
                    if (b.status === 'warning') return 1;
                } */
            }
            
            function onTasksSuccess(tasks) {
                $.each(tasks.members, function (index, task) {
                    var status = task.taskStatus;
                    var children = [];
                    if (task.children) {
                        $.each(task.children, function (index, child) {
                            children.push({uri: child.uri, status: child.taskStatus,
                                state: child.taskState, summary: child.name});
                        });
                    }
                    notifications.push({
                        uri: task.uri,
                        status: task.taskStatus,
                        state: task.taskState,
                        changing: task.changing,
                        summary: task.name,
                        timestamp: task.modified,
                        sourceUri: task.associatedResourceUri,
                        //sourceName: task.sourceName,
                        progress: task.percentComplete,
                        step: task.progressStep,
                        details: task.details,
                        resolution: task.resolution,
                        // Tour only for now
                        actions: task.actions,
                        children: children
                    });
                });
                notifications.sort(sortNotifications);
                dispatcher.fire("notificationsChange", notifications);
            }
            
            function onTasksError(error) {
                //console.log("!!! NP tasks error", error); // !!!
            }
            
            function onAlertsSuccess(alerts) {
                $.each(alerts.members, function (index, alert) {
                    notifications.push({
                        uri: alert.uri,
                        status: alert.status,
                        summary: alert.name,
                        timestamp: alert.date,
                        sourceName: alert.sourceName,
                        sourceUri: alert.sourceUri,
                        details: alert.details,
                        resolution: alert.resolution,
                        actions: alert.actions // Tour only for now
                    });
                });
                notifications.sort(sortNotifications);
                dispatcher.fire("notificationsChange", notifications);
            }
            
            function onAlertsError(error) {
                //console.log("!!! NP alerts error", error); // !!!
            }
            
            function getAlertsAndTasks(selection) {
                var uri;
                if (selection) {
                    uri = selection.uris[0];
                } else {
                    uri = resource.getSelection().uris[0];
                }
				//Commented for now as Tasks and Alerts service is not yet implemented in HPSUM server
				//This comment should be removed after we support tasks and alerts in HPSUM server
				/*
                if (uri) {
                    notifications = [];
                    tasksService.getTasksByFilter(["resourceUri='" + uri + "'"], 25,
                        ["created:descending"],
                        {success: onTasksSuccess, error: onTasksError});
                    alertsService.getAlertsByFilter(["resourceUri='" + uri + "'",
                        "alertState='Active'"], false, 25,
                        ["severity:descending", "created:descending"],
                        {success: onAlertsSuccess, error: onAlertsError});
                }
                
                if (timer) {
                    clearTimeout(timer);
                    timer = setTimeout(getAlertsAndTasks, settings.getRefreshInterval());
                }
				*/
            }
            
            function onSelectionChange(selection) {
                getAlertsAndTasks(selection);
            }

            /**
             * @public
             */
            this.init = function (resourceArg) {
                resource = resourceArg;
            };
            
            this.pause = function () {
                timer = clearTimeout(timer);
                timer = null;
                resource.off('selectionChange', onSelectionChange);
            };
            
            this.resume = function () {
                resource.on('selectionChange', onSelectionChange);
                getAlertsAndTasks(resource.getSelection());
                if (timer) {
                    clearTimeout(timer);
                }
                timer = setTimeout(getAlertsAndTasks, settings.getRefreshInterval());
            };
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return NotificationsPresenter;
    }());

    return NotificationsPresenter;
});
