// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hp/core/EventDispatcher', 
        'hp/services/IndexService',
        'hp/services/IndexFilter',
        'hp/core/UrlFragment',
        'hp/services/Log'], 
function(EventDispatcher, indexService, IndexFilter, urlFragment, log) {"use strict";

    var SearchBoxPresenter = ( function() {

        // consts/statics can go here.
        //

        /**
         * @constructor
         * @type {SearchBoxPresenter}
         */
        function SearchBoxPresenter() {

            var dispatcher = new EventDispatcher();
            var global = true;
            var category = null;
            var history = {global: []}; // category -> [query, ...]
            
            function addToHistory(userQuery) {
                var recents = history[(global ? 'global' : category)];
                // see if we already have it
                var index = recents.indexOf(userQuery);
                if (index !== -1) {
                    recents.splice(index, 1);
                } else {
                    recents.splice(4, 1);
                }
                recents.unshift(userQuery);
            }

            /**
             * @public
             */
            this.init = function() {
            };
            
            /**
             * @public
             */
            this.suggestions = function(userQuery, start, count) {
                var searchCategory = (global ? null : category);
                indexService.suggestions(searchCategory, userQuery,
                    start, count, {
                    success : function(data) {
                        dispatcher.fire('searchSuggestionChange', data);
                    },
                    error : function(errorInfo) {
                        log.warn(errorInfo.errorMessage);
                    }
                });
            };
            
            this.recents = function () {
                if (global) {
                    return history.global;
                } else {
                    return history[category];
                }
            }
            
            this.setCategory = function (categoryArg) {
                var result = (category !== categoryArg || ! categoryArg);
                category = categoryArg;
                if (! history.hasOwnProperty(category)) {
                    history[category] = [];
                }
                return result;
            };
            
            this.isGlobal = function () {
                return global;
            };
            
            this.setGlobal = function (globalArg) {
                global = globalArg;
            };
            
            this.doSearch = function(userQuery) {
                // lazily get this, because Router requires Banner,
                // which requires SearchBoxView
                require(['hp/core/Router'], function(router) {
                    addToHistory(userQuery);
                    if (global) {
                        router.go('/search?query=' + userQuery, 'search');
                    } else {
                        var location = router.location();
                        var newFilter = new IndexFilter(location);
                        newFilter.updateLocalSearchQuery(location, userQuery);
                        location = newFilter.updateLocation(location);
                        router.go(urlFragment.replaceUris(location, []), 'search local');
                    }
                });
            };
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
        }

        return new SearchBoxPresenter();
    }());

    return SearchBoxPresenter;
});
