// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hp/core/EventDispatcher',
    'hp/services/IndexService',
    'hp/services/Log'], 
function(EventDispatcher, indexService, log) {"use strict";

    var SearchPresenter = ( function() {

        // consts/statics can go here.
        //

        /**
         * @constructor
         * @type {SearchPresenter}
         */
        function SearchPresenter() {

            var dispatcher = new EventDispatcher();

            /**
             * @public
             */
            this.init = function() {
            };
            /**
             * @public
             */
            this.search = function(userQuery, start, count) {
                indexService.searchIndexResources(userQuery, start, count, {
                    success : function(data) {
                        dispatcher.fire('searchResultChange', data);
                    },
                    error : function(errorInfo) {
                        log.warn(errorInfo.errorMessage);
                    }
                });
            };
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
        }

        return new SearchPresenter();
    }());

    return SearchPresenter;
});
