// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @constructor
 * @type {DetailsShowView}
 */
define(['hp/core/Router',
    'hp/core/Style',
    'hp/core/Localizer',
    'hp/core/UrlFragment',
    'jquery',
    'hp/lib/jquery.hpSelect',
    'hp/lib/jquery.hpEllipsis'],
function(router, style, localizer, urlFragment) {"use strict";

    var DetailsShowView = (function() {
      
        var FIRST_ANCHOR = 'a[href]:first';
        //var VIEW = '.hp-details-show-view';

        /**
         * Constructor
         */
        function DetailsShowView() {

            var selector = null;
            var header = null;
            var layoutTimer = null;

            function onLocationChange(location) {
                // see if we have an anchor at the location, strip off any resource
                var simplifiedLocation = urlFragment.stripToView(location);
                var anchor = $('a[href^="#' + simplifiedLocation + '"]', selector);
                if (0 === anchor.length) {
                    anchor = $(FIRST_ANCHOR, selector);
                }
                if (1 === anchor.length) {
                    // align panel selector with route location
                    $(selector).hpSelect('set', anchor.text());
                }
            }
            
            function layout() {
                // set max-width of h1 to avoid overlaps
                var h1 = $('h1', header);
                var width = 0;
                
                if (h1.length > 0) {
                    // count the width used by all contents except the h1
                    $.each(header.children(), function (index, elem) {
                        if (elem != h1[0]) {
                            width += $(elem).outerWidth();
                        }
                    });
                    // allow for status + changing icon not being set yet
                    width += Math.max(52, h1.position().left);
                    // make sure the header leaves us at least a little room
                    header.css('min-width', width + 100);
                    // take all available space, minus some padding
                    h1.css('max-width',
                        header.innerWidth() - (width + 40));
                }
            }
            
            function onResize(event) {
                if (event.target == window) {
                    clearTimeout(layoutTimer);
                    layoutTimer = setTimeout(layout, 50);
                }
            }

            /**
             * @public
             */
            this.init = function (selectorArg) {
                if (selectorArg) {
                    selector = selectorArg;
                    selector.hpSelect();
                    header = selector.parents('.hp-details-header');
                    // make sure selector has a view label
                    if (! $('> label', selector).text()) {
                        $('> label', selector).
                            text(localizer.getString('core.details.view'));
                    }
                } else {
                    header = $('.hp-details-header');
                }
                
                $('h1', header).hpEllipsis();
                
                $(window).on('resize', onResize);
                $('.hp-page').on('relayout', layout);
                // we delay so any CSS animation can finish
                setTimeout(layout, style.animationDelay());

                router.on('locationChange', onLocationChange);
            };
        }

        return DetailsShowView;
    }());

    return DetailsShowView;
});
