// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['jquery', 'lib/excanvas', 'hp/lib/jquery.hpStatus'],
function() { "use strict";

    var GraphicsLogicalSwitchView = (function() {
      
        var LOGICAL_SWITCH = '.hp-logical-switch';
        var CANVAS = LOGICAL_SWITCH + ' canvas';
        var LOGICAL_UPLINK = '.hp-logical-uplink';
        var UP_PORT = '.hp-up-port';
        var COLORS = ['#f5e3bb', '#F6C4F1', '#CFC1FF', ' #C0E5EF', '#DFEDAF'];
        var SELECTED_COLORS = ['#e5b856', '#E86BDC', '#8763FF', ' #62BDD6', '#B0D136'];
        
        /**
         * Constructor
         */
        function GraphicsLogicalSwitchView() {
          
            var wires = [];
          
            function itemCenter(item) {
                var containerOffset = $(LOGICAL_SWITCH).offset();
                var itemOffset = item.offset();
                //console.log("!!! " + itemPosition.left + ',' + itemPosition.top + ' ' + item.width() + 'x' + item.height());
                return {left: Math.ceil(itemOffset.left + (item.outerWidth() / 2) -
                        containerOffset.left),
                    top: Math.ceil(itemOffset.top + (item.outerHeight() / 2) -
                        containerOffset.top)};
            }
          
            function draw() {
                var logicalSwitch = $(LOGICAL_SWITCH);
                var canvas = $(CANVAS)[0];
                $(CANVAS).attr('width', logicalSwitch.outerWidth()-2).
                    attr('height', logicalSwitch.outerHeight()-2);
                if (! canvas.getContext) {
                    G_vmlCanvasManager.initElement(canvas);
                }
                if (canvas.getContext) {
                    var context = canvas.getContext('2d');
                    context.clearRect(0, 0, canvas.width, canvas.height);
                    var uplinkCoords = [];
                    var lastTop = 0;
                    
                    $(LOGICAL_UPLINK).each(function (index, uplink) {
                        var position = itemCenter($(uplink));
                        var delta = (index * 5);
                        var x = position.left-($(uplink).outerWidth()/2)-1.5;
                        uplinkCoords[index] = {
                            position: position,
                            delta: delta,
                            x: x,
                            top: position.top-($(uplink).outerHeight()/2)-5+0.5,
                            bottom: position.top+($(uplink).outerHeight()/2)+16+delta,
                            left: x,
                            right: x,
                            gutterBottom: 0,
                            rows: []
                          };
                        lastTop = Math.max(lastTop, uplinkCoords[index].top);
                    });
                    
                    $(LOGICAL_UPLINK).each(function (index, uplink) {
                        var coord = uplinkCoords[index];
                        var selected = $(uplink).hasClass('hp-selected');
                        
                        context.beginPath();
                        context.lineWidth = 4;
                        if (selected) {
                            context.strokeStyle = SELECTED_COLORS[index];
                        } else {
                            context.strokeStyle = COLORS[index];
                        }
                        context.moveTo(coord.x, coord.top);
                        context.lineTo(coord.x, coord.bottom);
                        context.stroke();
                        
                        context.lineWidth = 2;
                        
                        // simulate some physical uplink connections
                        $(UP_PORT).each(function (portIndex, port) {
                            if (portIndex % $(LOGICAL_UPLINK).length == index) {
                                var portPosition = itemCenter($(port));
                                var portX = portPosition.left-0.5;
                                var portBottom = portPosition.top-19+0.5;
                                var portTop = portBottom-(30-(coord.delta));
                                var row = coord.rows[coord.rows.length-1];
                                
                                if (coord.rows.length === 0 || row.y !== portTop) {
                                    row = {left: portX, right: portX, y: portTop};
                                    coord.rows.push(row);
                                } else {
                                    row.left = Math.min(row.left, portX);
                                    row.right = Math.max(row.right, portX);
                                }
                                
                                if (coord.top === lastTop && row.y === coord.rows[0].y) {
                                    portTop = coord.bottom;
                                }
                                if (portTop === coord.bottom) {
                                    // in top row, adjust left/right
                                    coord.left = Math.min(coord.left, portX);
                                    coord.right = Math.max(coord.right, portX);
                                }
                                context.moveTo(portX, portBottom);
                                context.lineTo(portX, portTop);
                                if (selected) {
                                    context.moveTo(portX-2, portBottom-9);
                                    context.lineTo(portX+2, portBottom-9);
                                    context.lineTo(portX+2, portBottom);
                                    context.lineTo(portX-2, portBottom);
                                    context.lineTo(portX-2, portBottom-9);
                                }
                            }
                        });
                        
                        $.each(coord.rows, function (index, row) {
                            if (coord.top !== lastTop || row.y !== coord.rows[0].y) {
                                context.moveTo(5+coord.delta, row.y);
                                context.lineTo(row.right, row.y);
                                coord.gutterBottom = Math.max(coord.gutterBottom, row.y);
                            }
                        });
                        
                        if (coord.gutterBottom > 0) {
                            context.moveTo(5+coord.delta, coord.gutterBottom);
                            context.lineTo(5+coord.delta, coord.bottom);
                            if (coord.top !== lastTop) {
                                context.lineTo(coord.x+10, coord.bottom);
                            }
                        }
                        
                        if (coord.top === lastTop && coord.rows.length === 1) {
                            // one row
                            context.moveTo(coord.left, coord.bottom);
                            context.lineTo(coord.right, coord.bottom);
                        } else if (coord.top === lastTop) {
                            context.moveTo(5+coord.delta, coord.bottom);
                            context.lineTo(Math.max(coord.rows[0].right, coord.right),
                                coord.bottom);
                        }

                        context.stroke();
                    });
                }
            }
            
            function toggleLogicalUplink(ev) {
                var found = false;
                $(LOGICAL_UPLINK).each(function (index, uplink) {
                    var offset = $(uplink).offset();
                    if (offset.top < ev.pageY &&
                        (offset.top + $(uplink).outerHeight()) > ev.pageY &&
                        offset.left < ev.pageX &&
                        (offset.left + $(uplink).outerWidth()) > ev.pageX) {
                          
                        if ($(uplink).hasClass('hp-selected')) {
                            $(uplink).removeClass('hp-selected');
                        } else {
                            $(LOGICAL_UPLINK).removeClass('hp-selected');
                            $(uplink).addClass('hp-selected');
                        }
                        draw();
                        found = true;
                        return false;
                    }
                });
                if (! found) {
                    $(LOGICAL_UPLINK).removeClass('hp-selected');
                    draw();
                }
            }
            
            /**
             * @public
             */
            this.init = function() {
                $('.hp-status').hpStatus();
                this.resume();
            };
            
            this.pause = function () {
                $(window).off('resize', draw);
                $(CANVAS).off('click', toggleLogicalUplink);
            };
            
            this.resume = function () {
                $(window).on('resize', draw);
                $(CANVAS).on('click', toggleLogicalUplink);
                draw();
            };
        }

        return new GraphicsLogicalSwitchView();
    }());
    
    return GraphicsLogicalSwitchView;
});
