// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupEditView)
 * This is a view class for Editing Group.
 */

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Validator',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
    'hp/core/Localizer',
    'hp/core/Notifications',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle'],
function(presenter, router, urlFragment, validator, FormStateView, helpMenu, localizer, notifications) { "use strict";
 
	var EditGroupView = ( function() {
			// consts can go here
			var ADD = '#hpsum-group-edit',
			    CANCEL = '#hpsum-group-edit-close',
			    RESET = "#hpsum-group-reset", 
			    PANEL_SELECTOR = '#hpsum-group-edit-panel-selector',
			    PANELS = '#hpsum-group-edit-panels',
			    TITLE = '#hpsum-group-title',
			    NAME = '#hpsum-group-name',
			    NAMEERR = '#hpsum-group-name-error',
			    DESC = '#hpsum-group-description',
			    ADD_NODES_TABLE = '#hpsum-add-group-nodes-table',
			    REMOVE_NODES_TABLE = '#hpsum-remove-group-nodes-table',
			    USERNAME = '#hpsum-group-user-name',
			    USERNAMEERR = '#hpsum-group-user-name-error',
			    PASSWORD = '#hpsum-group-password',
			    PASSWORDERR = '#hpsum-group-password-error',
			    ROUTE_PREFIX = '/group/edit';
      
			/**
			 * @constructor
			 */
			function EditGroupView() {
				var formStateView = new FormStateView(),
				    nodes = [],
				    groupCurrentNodes = [],
				    groupItem = null,
				    selectedAddNodes = [],
				    selectedRemoveNodes = [],
				    editInProgress = false,
				    closeEditWindow = false,
				    editGroupSuccess = false,
				    attributes = {
				    	hapi: {
				    		username: "",
				    		password: ""
				    	}
				    };
				
				function onItemChange(item) {
					reset();
					groupItem = item.hapi;

					if (groupItem) {
						$(TITLE).text(groupItem.group_name);
					} else {
						$(CANCEL).trigger('click');
					}
				}
				
				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function onNameEdit() {
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
					$(NAME).unbind('keyup', onNameEdit);
				}

				function onUserNameEdit() {
					$(USERNAMEERR).hide();
					$(USERNAME).removeClass("hp-error");
					$(USERNAME).unbind('keyup', onUserNameEdit);
				}
				
				function onPasswordEdit() {
					$(PASSWORDERR).hide();
					$(PASSWORD).removeClass("hp-error");
					$(PASSWORD).unbind('keyup', onPasswordEdit);
				}

				function onGroupEditSuccess(data) {
					if (data.hapi.hmessage.match(/Group name already exists/i)) {
						$(NAMEERR).text(localizer.getString('hpsum.group.groupAlreadyExists'));
						$(NAME).addClass("hp-error");
						$(NAMEERR).show();
						$(NAME).keyup(onNameEdit);
						editGroupSuccess = false;
						closeEditWindow = false;
					}
					else {
					reset();
					editGroupSuccess = true;
					closeEditWindow = true;
					}
				}

				function onGroupEditError(msg) {
					editInProgress = false;
					$(NAMEERR).text(msg);
					$(NAME).addClass("hp-error");
					$(NAMEERR).show();
				}

				function reset() {
					formStateView.reset();
					editInProgress = false;
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
				}

				function validate() {
					
					if (!validateCredentialsValues) {
						return false;			
					}
					
					return validateName() || validateDescription() || validateSelectedNodes() || validateCredentials();
				}

				function validateName() {
					var success = true;
					if ($(NAME).val() == '') {
						success = false;
					}
					return success;
				}

				function validateDescription() {
					var success = true;
					if ($(DESC).val() == '') {
						success = false;
					}
					return success;
				}

				function validateSelectedNodes() {
					return getSelectedAddNodes().length > 0 || getSelectedRemoveNodes().length > 0;
				}

				function validateCredentialsValues() {
					var success = true;
					if ($(USERNAME).val() == '' && $(PASSWORD).val() != '') {
						$(USERNAMEERR).text(localizer.getString('hpsum.group.requiredUserName'));
						$(USERNAME).addClass("hp-error");
						$(USERNAMEERR).show();
						$(USERNAME).keyup(onUserNameEdit);
						success = false;
					}
					else if ($(USERNAME).val() != '' && $(PASSWORD).val() == '') {
						$(PASSWORDERR).text(localizer.getString('hpsum.group.requiredPassword'));
						$(PASSWORD).addClass("hp-error");
						$(PASSWORDERR).show();
						$(PASSWORD).keyup(onPasswordEdit);
						success = false;
					}
					
					return success;
				}
				
				function validateCredentials() {
					var success = true;
					if ($(USERNAME).val() == '' && $(PASSWORD).val() == ''){
						success = false;
					}
					return success;
				}
				
				function getSelectedAddNodes() {
					return selectedAddNodes;
				}

				function getSelectedRemoveNodes() {
					return selectedRemoveNodes;
				}

				function onEditGroup() {
					if (validate()) {
						if (!editInProgress) {
							editInProgress = true;

							if (validateCredentials()) {
								attributes.hapi.username = $(USERNAME).val();
								attributes.hapi.password = $(PASSWORD).val();

								presenter.setAttributes(groupItem, attributes, {
									success : function(data) {
										editGroupSuccess = true;
									},
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
									}
								});
								closeEditWindow = true;
							}
														
							if (getSelectedRemoveNodes().length > 0) {
								var selectedRemoveNodes = getSelectedRemoveNodes();
								presenter.removeNodes(groupItem, {
									nodes : selectedRemoveNodes
								}, {
									success : function(data) {
										editGroupSuccess = true;
									},
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
									}
								});
								closeEditWindow = true;
							}

							if (validateName() || validateDescription() || getSelectedAddNodes().length > 0) {
								var selectedAddNodes = getSelectedAddNodes();
								presenter.editItem(groupItem, {
									name : $(NAME).val(),
									description : $(DESC).val(),
									nodes : selectedAddNodes
								}, {
									success : onGroupEditSuccess,
									error : function(errorMessage) {
										notifications.show(errorMessage, 'error');
										closeEditWindow = true;
									}
								});
							}
							
							editInProgress = false;
							
							if (closeEditWindow) {
								if (editGroupSuccess) {
									notifications.show(localizer.getString("hpsum.group.editedGroup") + ' ' + groupItem.group_name, 'ok');
								}
								reset();
								$(CANCEL).trigger('click');
							} 
							
						}
					}
				}

				function getAllNodesSuccess(results) {
					nodes = presenter.getNodeArray();
					
					var tableAddNodes = [], tableRemoveNodes = [], jdx = 0;

					for (var idx = 0; idx < nodes.length; ++idx) {
						if ($.inArray(nodes[idx].id, groupCurrentNodes) != -1) {
							tableRemoveNodes.push({
								node_id: nodes[idx].id,
								name : nodes[idx].name,
								type : nodes[idx].type,
								node_status : nodes[idx].node_status
							});
							jdx++;
						} else {
							tableAddNodes.push({
								node_id: nodes[idx].id,
								name : nodes[idx].name,
								type : nodes[idx].type,
								node_status : nodes[idx].node_status
							});
						}
					}

					$(ADD_NODES_TABLE).dataTable().fnClearTable(true);
					$(ADD_NODES_TABLE).dataTable().fnAddData(tableAddNodes);
					selectedAddNodes = [];
					$(ADD_NODES_TABLE + " tbody tr").click(function(e) {
						var aData = $(ADD_NODES_TABLE).dataTable().fnGetData(this),
							selectdNodesLenght = selectedAddNodes.length,
						    idx;
						if ($(this).hasClass('hp-selected')) {
							$(this).removeClass('hp-selected');
							for (idx = 0; idx < selectdNodesLenght; idx += 1) {
								if (selectedAddNodes[idx] === aData.node_id) {
									selectedAddNodes.splice(idx, 1);
									break;
								}
							}
						} else {
							$(this).addClass('hp-selected');
							selectedAddNodes = selectedAddNodes.concat(aData.node_id)
						}
					});

					$(REMOVE_NODES_TABLE).dataTable().fnClearTable(true);
					$(REMOVE_NODES_TABLE).dataTable().fnAddData(tableRemoveNodes);					
					selectedRemoveNodes = [];
					$(REMOVE_NODES_TABLE + " tbody tr").click(function(e) {
						var aData = $(REMOVE_NODES_TABLE).dataTable().fnGetData(this),
							selectdNodesLenght = selectedRemoveNodes.length,
						    idx;
						if ($(this).hasClass('hp-selected')) {
							$(this).removeClass('hp-selected');
							for (idx = 0; idx < selectdNodesLenght; idx += 1) {
								if (selectedRemoveNodes[idx] === aData.node_id) {
									selectedRemoveNodes.splice(idx, 1);
									break;
								}
							}
						} else {
							$(this).addClass('hp-selected');
							selectedRemoveNodes = selectedAddNodes.concat(aData.node_id)
						}
					});
				}

				function getAllNodesError(data) {
				}

				function getGroupDataSuccess(groupData) {
					groupCurrentNodes = groupData.hapi.group_nodes.group_node;
					
					presenter.getAllNodes({
						success : getAllNodesSuccess,
						error : getAllNodesError
					});
				}

          
				/**
				 * @public
				 * Intialize the group edit view.
				 */
				this.init = function() {

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});

					var dummyAddNodesData = [];
					$(ADD_NODES_TABLE).dataTable({
						oLanguage : { sEmptyTable :
							localizer.getString("hpsum.group.noMoreNodesAvailable")
						},
						bPaginate : false,
						bProcessing : true,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyRemoveNodesData,
						aoColumns : [{
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});

					var dummyRemoveNodesData = [];
					$(REMOVE_NODES_TABLE).dataTable({
						oLanguage : { sEmptyTable :
							localizer.getString("hpsum.group.noNodesInGroup")
						},
						bPaginate : false,
						bProcessing : true,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						bDestroy : true,
						aaData : dummyRemoveNodesData,
						aoColumns : [{
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});

					$(ADD).live('click', function(ev) {
						onEditGroup.call(this);
						ev.preventDefault();
					});

					$(RESET).live('click', function() {
						reset.call();
					});

					router.watch('group edit section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					this.resume();
				};

				/**
				 * @public
				 * Resume the group edit view.
				 */
				this.resume = function() {
					$(RESET).trigger('click');
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");

					$(ADD_NODES_TABLE).dataTable().fnClearTable(true);
					$(REMOVE_NODES_TABLE).dataTable().fnClearTable(true);
					
					presenter.getData({
						success : getGroupDataSuccess
					});
					
					presenter.on("itemChange", onItemChange);
				};

			
				/**
				 * @public
				 * Pause the group edit view.
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
				};

			}

			return EditGroupView;
		}());

	return new EditGroupView();

    		
});

