// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'lib/jquery.selectBox'],

function(presenter,router, urlFragment, notifications, FormStateView, localizer) {"use strict";

	var GroupInventoryView = ( function() {

			//Consts can go here
			var OK = '#hpsum-group-inventory-ok',
			    CANCEL = '#hpsum-group-inventory-close',
			    PANEL_SELECTOR = '#hpsum-group-inventory-panel-selector',
			    PANELS = '#hpsum-group-inventory-panels',
			    FORM = '#hpsum-group-inventory-form',
			    FAILEDMSG = '#hpsum-group-inventory-failed-details',
			    FAILEDPANEL = '#hpsum-group-inventory-failed',
			    BASELINES = '#hpsum-group-baselines-search',
			    ASSOCBASELINE = '#hpsum-group-baseline',
			    HOTFIX = '#hpsum-group-addpackage-search',
			    ASSOCHOTFIX = '#hpsum-group-addpackage',
			    NAME = '#hpsum-group-inventory-name',
			    ROUTE_PREFIX = '/group/inventory';

			/**
			 * Constructor
			 */
			function GroupInventoryView() {

				var formStateView = new FormStateView();
				var inventoryInProgress = false, groupItem = null, baselines = '', hotfixes = '', assocBaseline = '', newBaseline = null, newHotFix = null, assocHotFix = '', searchResults = [];

				function onItemChange(item) {
					item = item.hapi;

					if (item) {
						$(NAME).text(item.group_name);
						$(ASSOCBASELINE).text('');
						$(ASSOCHOTFIX).text('');
						groupItem = item;
						newBaseline = null;
						newHotFix = null;
						if (item.baselines) {
							for (var i = 0; i < item.baselines.length; i++) {
								var baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
								if (baseline) {
									if (baseline.name.match(/^Additional Package/i)) {
										$(ASSOCHOTFIX).text(baseline.name);
										assocHotFix = baseline;
									} else {
										$(ASSOCBASELINE).text(baseline.name);
										assocBaseline = baseline;
									}
								}
							}
						}
					} else {
						$(CANCEL).trigger('click');
					}
					formStateView.reset();
				}

				function onInventoryError(errorMessage) {
					$(FAILEDPANEL).show();
					$(FAILEDMSG).text(errorMessage);
					$(OK).attr("disabled", "disabled");
					inventoryInProgress = false;
				}

				function onInventorySuccess(item) {
					inventoryInProgress = false;
					formStateView.reset();
					$(CANCEL).trigger('click');
				}

				function onInventory() {
					var fail = false;
					var finalBaseline;
					var finalHotFix;
					var baselineJson = [];
					if (!inventoryInProgress) {
						if ((newBaseline == null) && (assocBaseline == null))
							finalBasline = null;
						else if (newBaseline == null)
							finalBaseline = assocBaseline;
						else
							finalBaseline = newBaseline;
						if ((newHotFix == null) && (assocHotFix == null))
							finalHotFix = null;
						else if (newHotFix == null)
							finalHotFix = assocHotFix;
						else
							finalHotFix = newHotFix;

						if ((finalHotFix == null) && (finalBaseline == null))
							fail = true;
						else if (finalHotFix == null)
							baselineJson.push(finalBaseline.id);
						else if (finalBaseline == null)
							baselineJson.push(finalHotFix.id);
						else {
							baselineJson.push(finalBaseline.id);
							baselineJson.push(finalHotFix.id);
						}
						if (fail == true) {
							$(FAILEDPANEL).show();
							$(FAILEDMSG).text(localizer.getString('hpsum.group.errorPleaseSelectBaseline'));
						} else {
							groupItem.baselines = baselineJson;
							inventoryInProgress = true;
							presenter.startInventory(groupItem, {
								success : onInventorySuccess,
								error : onInventoryError
							});
						}
					}
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				this.resume = function() {
					presenter.on('itemChange', onItemChange);
					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});
					$(PANELS).hpStackedPanels('resume');
					$(OK).removeAttr("disabled");
					$(FAILEDPANEL).hide();
					$(BASELINES).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					$(HOTFIX).hpSearchCombo('set', {
						id : '',
						name : ''
					});
				};

				this.pause = function() {
					presenter.off('itemChange', onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

				function baselinesAvailable(data) {
				}

				function getBaseline(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(baselines, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getHotfixes(string, handlers) {
					var results = [];
					if (string && string.length > 0) {
						results = $.grep(hotfixes, function(option, index) {
							return (option.name.match(new RegExp(string, 'i')));
						});
					}
					handlers.success({
						count : results.length,
						members : results
					});
				}

				function getBaselinesSuccess(searchResults) {
					baselines = $.grep(searchResults, function(option, index) {
						return !(option.name.match(new RegExp('^Additional', 'i')));
					});
					hotfixes = $.grep(searchResults, function(option, index) {
						return (option.name.match(new RegExp('^Additional', 'i')));
					});

				}

				function getBaselinesError(msg) {

				}

				/**
				 * @public
				 */
				this.init = function() {

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});
					$(FAILEDPANEL).hide();
					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					formStateView.init({
						form : FORM,
						routePattern : ROUTE_PREFIX + '.*',
						autoTrack : true
					});

					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});

					$(BASELINES).hpSearchCombo({
						getResults : getBaseline
					});
					$(HOTFIX).hpSearchCombo({
						getResults : getHotfixes
					});
					$(BASELINES).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCBASELINE).text(item.name);
							newBaseline = item;
						} else {
							$(ASSOCBASELINE).text(assocBaseline.name);
							newBaseline = null;
						}
						$(FAILEDPANEL).hide();
					});
					$(HOTFIX).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCHOTFIX).text(item.name);
							newHotFix = item;
						} else {
							$(ASSOCHOTFIX).text(assocHotFix.name);
							newHotFix = null;
						}

						$(FAILEDPANEL).hide();
					});

					$(OK).on('click', function(ev) {
						onInventory();
						ev.preventDefault();
					});

					router.watch('group inventory section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					this.resume();
				};
			}

			return new GroupInventoryView();
		}());

	return GroupInventoryView;
});

