// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/server/ServerPresenter',
    'hpsum/view/server/ServerEditBiosView',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox'],
function(presenter, serverEditBiosView, router, urlFragment, notifications, FormStateView) { "use strict";

    var ServerEditView = (function() {
      
        var OK = '#tour-server-edit-ok';
        var CANCEL = '#tour-server-edit-cancel';
        var PANEL_SELECTOR = '#tour-server-edit-panel-selector';
        var PANELS = '#tour-server-edit-panels';
        var FORM = '#tour-server-edit-form';
        var TITLE = '#tour-server-details-title';
        var NAME = '#tour-server-name';
        var EDIT_BIOS_SETTINGS = '#tour-server-edit-bios-settings';
        var ROUTE_PREFIX = '/server/edit';
        
        /**
         * Constructor
         */
        function ServerEditView() {
          
            var formStateView = new FormStateView();
            var updateInProgress = false;
                
            function onItemChange(item) {
                if (item) {
                    $(TITLE).text(item.name);
                    $(NAME).val(item.name);
                } else {
                    $(TITLE).text('');
                }
                formStateView.reset();
            }
            
            function onItemError(errorMessage) {
                formStateView.noItem(errorMessage);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(PANEL_SELECTOR, selection.uris);
                urlFragment.replaceHrefUris(CANCEL, selection.uris);
                $(PANELS).hpStackedPanels('setPanelByLocation', '#' + router.location());
            }
            
            function onItemUpdateSuccess(item) {
                updateInProgress = false;
                formStateView.reset();
                $(CANCEL).trigger('click');
            }

            /**
             * @private
             */
            function onItemUpdateError(errorMessage) {
                notifications.show(errorMessage);
                updateInProgress = false;
            }
            
            function onUpdateItem() {
                if (! updateInProgress) {
                    updateInProgress = true;
                    presenter.updateSelectedItems({name: $(NAME).val()}, {
                        success : onItemUpdateSuccess,
                        error : onItemUpdateError
                    });
                }
            }
            
            function onEditBiosSettings() {
                serverEditBiosView.init();
                serverEditBiosView.resume();
            }
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
            this.resume = function () {
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                $(PANELS).hpStackedPanels('resume');
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                $(PANELS).hpStackedPanels('pause');
            };
          
            /**
             * @public
             */
            this.init = function () {
              
                $('.hp-select').selectBox({autoWidth: false});
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: true});
                
                $(EDIT_BIOS_SETTINGS).on('click', onEditBiosSettings);
                
                $(OK).on('click', function(ev) {
                    onUpdateItem();
                    ev.preventDefault();
                });
                
                $(CANCEL).bind('click', function(ev) {
                    formStateView.reset();
                });
                
                router.watch('server edit section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                this.resume();
            };
        }

        return new ServerEditView();
    }());
    
    return ServerEditView;
});
