#!/bin/sh

pause_exit ()
{
  if [ $skip -eq 0 ]; then
    echo Press Enter to continue
    read foo
  fi
  exit 0
}

cat <<-___BANNER

HP Smart Update Manager 5.x to 6.x target port script

This script will attempt to find targets saved in the HP SUM 5.x INI file
and create similar nodes in the HP SUM 6.x database.

After porting is done, targets will show up as new nodes in HP SUM 6.x
and will need credentials updated and a baseline assigned.
 
___BANNER


if [ "x$1" = "x-h" ]; then
cat <<-___HERE
syntax: $0 [-y] [-h] [-script] [-user <username> -password <password>]
   -y      = continue without pausing for prompts
   -script = create script instead
             A file is created with commands to be run instead of running them 
             immediately. The file can then be edited manually before being run.
   -user <username> -password <password> 
             Set default username and password when adding ported targets.  
             Default without this option is user=username and password=passwd.
___HERE
  exit 0
fi

echo For additional options, run $0 -h

#set defaults
skip=0
script=0
script_name=custom_port.sh
user=username
password=passwd

#look through arguments
while test $# -gt 0
do
  case "$1" in
  -y) skip=1
      ;;
  -script) script=1
           echo Output will go to script: $script_name
      ;;
  -user) if [ "x$2" != "x" ]; then
           user=$2
           echo Using $2 as default username
           shift
         else
           echo Missing <username> after -user
           exit -1
         fi
         ;;
  -password) if [ "x$2" != "x" ]; then
               password=$2
               echo Using $2 as default password
               shift
             else
                echo Missing <password> after -password
                exit -1
             fi
             ;;
   *) echo Unknown argument: $1
      echo For syntax use: $0 -h
      exit -1
      ;;
   esac
   shift
done
        

echo                       -
if [ $skip -eq 0 ]; then
  echo -n Are you sure you want to port targets? [y or n] : 
  read ok

  if [ "x$ok" != "xy" ]; then
    echo Exiting without porting any targets
    pause_exit
  fi
fi

oldloc=/etc/xdg/Hewlett-Packard/HPSUM.ini

if [ ! -f $oldloc ]; then
  echo Could not find HP SUM 5.x INI file in $oldloc
  exit -1
fi

if [ ! -f ./hpsum ]; then
  echo Could not find HP SUM 6.x in current directory [./hpsum]
  exit -1
fi

if [ $script -eq 1 ]; then
  echo "!#/bin/sh" > $script_name
fi

for target in `grep address $oldloc | sed 's/.*=//'`; do
  if [ "$target" != "localhost" ]; then
    echo Copying old 5.x target [$target] to 6.x 
    if [ $script -eq 1 ]; then
      echo "./hpsum add --nodes $target user=$user password=$password" >> $script_name
    else
      ./hpsum add --nodes $target user=$user password=$password
    fi
  fi
done

if [ $script -eq 1 ]; then
  chmod +x $script_name
  cat <<-___ENDMSG

   $script_name now contains the commands that are needed to port the targets 
   to HP SUM 6.0.  You can edit this file before running it in order to 
   manually remove/add targets and change credentials if you want.  
   Then execute:
       ./$script_name
   to run the script.
___ENDMSG
fi

pause_exit

