# hinawa crate

Rust API bindings and wrappers for [hinawa library](https://github.com/alsa-project/libhinawa) to
operate Linux FireWire character device for asynchronous packet and topology generation
in IEEE 1394 bus.

The hinawa library version 2.5 is the minimum supported version for underlying library.

The hinawa crate is automatically generated by [gir tool](https://gtk-rs.org/gir/book/) provided
by [gtk-rs project](https://gtk-rs.org/). Hinawa-3.0 file from hinawa library is used for the
generation. But some functions are implemented manually.

## Usage

Add the following line to your Cargo.toml file:

```toml
[dependencies]
hinawa = "0.7"
```

The API documentation is available in <https://docs.rs/hinawa/>.

## License

The hinawa crate is released under [MIT license](https://spdx.org/licenses/MIT.html).

## Dependency

The hinawa crate depends on API crates provided by [gtk-rs project](https://gtk-rs.org/) for
type/object system, event loop, and dispacher.

## Features

* dox

   * Suppress probing hinawa library. It's automatically enabled when generating documentation
     in docs.rs.

## Repository

The hinawa crate is the part of ALSA project and maintained by
[ALSA gobject-introspection team](https://alsa-project.github.io/gobject-introspection-docs/).
The remote repository is located in <https://github.com/alsa-project/hinawa-rs/>.

## Support

If finding issue, please file it in <https://github.com/alsa-project/hinawa-rs/>.

## Sample programs
Some programs are available under `examples` directory.

* `read-quadlet.rs`

    * demonstration to read quadlet data from node in IEEE 1394 bus.
